/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.darwin.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dev.nokee.core.exec.CachingProcessBuilderEngine;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.LoggingEngine;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.runtime.base.internal.repositories.AbstractRouteHandler;
import dev.nokee.runtime.base.internal.repositories.GradleModuleMetadata;
import dev.nokee.runtime.base.internal.tools.CommandLineToolDescriptor;
import dev.nokee.runtime.base.internal.tools.ToolRepository;
import dev.nokee.runtime.darwin.internal.XcodeSdk;
import dev.nokee.runtime.darwin.internal.parsers.XcodebuildParsers;
import dev.nokee.runtime.nativebase.internal.LibraryElements;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;

public class FrameworkRouteHandler
extends AbstractRouteHandler {
    private static final Logger LOGGER = Logger.getLogger(FrameworkRouteHandler.class.getName());
    public static final String CONTEXT_PATH = "/dev/nokee/framework";
    private static final Map<String, Object> CURRENT_PLATFORM_ATTRIBUTES = ImmutableMap.builder().put((Object)OperatingSystemFamily.OPERATING_SYSTEM_ATTRIBUTE.getName(), (Object)"macos").put((Object)MachineArchitecture.ARCHITECTURE_ATTRIBUTE.getName(), (Object)"x86-64").build();
    private final ToolRepository toolRepository;
    private final CommandLineToolExecutionEngine<CachingProcessBuilderEngine.Handle> engine = new CachingProcessBuilderEngine((CommandLineToolExecutionEngine)LoggingEngine.wrap((CommandLineToolExecutionEngine)new ProcessBuilderEngine()));

    @Inject
    public FrameworkRouteHandler(ToolRepository toolRepository) {
        this.toolRepository = toolRepository;
    }

    private String findSdkVersion(XcodeSdk sdk) {
        return ((CachingProcessBuilderEngine.Handle)CommandLineTool.of((File)((CommandLineToolDescriptor)this.toolRepository.findAll("xcrun").iterator().next()).getPath()).withArguments(new Object[]{"-sdk", sdk.getIdentifier(), "--show-sdk-version"}).execute(this.engine)).getResult().getStandardOutput().getAsString().trim();
    }

    private File findSdkPath(XcodeSdk sdk) {
        return (File)((CachingProcessBuilderEngine.Handle)CommandLineTool.of((File)((CommandLineToolDescriptor)this.toolRepository.findAll("xcrun").iterator().next()).getPath()).withArguments(new Object[]{"-sdk", sdk.getIdentifier(), "--show-sdk-path"}).execute(this.engine)).getResult().getStandardOutput().parse(it -> new File(it.trim()));
    }

    private XcodeSdk findMacOsSdks() {
        CommandLineToolDescriptor xcodebuilt = (CommandLineToolDescriptor)this.toolRepository.findAll("xcodebuild").iterator().next();
        return ((Set)((CachingProcessBuilderEngine.Handle)CommandLineTool.of((File)xcodebuilt.getPath()).withArguments(new Object[]{"-showsdks"}).execute(this.engine)).getResult().getStandardOutput().parse(XcodebuildParsers.showSdkParser())).stream().filter(it -> it.getIdentifier().startsWith("macosx")).findFirst().orElseThrow(() -> new RuntimeException(String.format("MacOS SDK not found using '%s' version %s", xcodebuilt.getPath().getAbsolutePath(), xcodebuilt.getVersion())));
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }

    public boolean isKnownModule(String moduleName) {
        if (this.getLocalPath(moduleName).exists()) {
            return true;
        }
        LOGGER.info(String.format("The requested framework '%s' wasn't found at in '%s/System/Library/Frameworks/'.", moduleName, this.findSdkPath(this.findMacOsSdks()).getPath()));
        return false;
    }

    public boolean isKnownVersion(String moduleName, String version) {
        XcodeSdk sdk = this.findMacOsSdks();
        if (!this.findSdkVersion(sdk).equals(version)) {
            LOGGER.info(String.format("The requested framework '%s' version '%s' doesn't match current SDK version '%s'.", moduleName, version, this.findSdkVersion(sdk)));
            return false;
        }
        if (!this.getLocalPath(moduleName).exists()) {
            LOGGER.info(String.format("The requested framework '%s' wasn't found at in '%s/System/Library/Frameworks/'.", moduleName, this.findSdkPath(sdk).getPath()));
            return false;
        }
        return true;
    }

    public List<String> findVersions(String moduleName) {
        XcodeSdk sdk = this.findMacOsSdks();
        return Collections.singletonList(this.findSdkVersion(sdk));
    }

    public GradleModuleMetadata getResourceMetadata(String moduleName, String version) {
        return this.getValue(moduleName, version);
    }

    public String handle(String moduleName, String version, String target) {
        if (target.endsWith(".framework.localpath")) {
            File localPath = this.getLocalPath(moduleName);
            if ((target = target.substring(target.lastIndexOf("/") + 1)).startsWith(moduleName + ".framework")) {
                return localPath.getPath();
            }
            target = target.substring(0, target.lastIndexOf(".localpath"));
            return new File(localPath, "Frameworks/" + target).getPath();
        }
        return null;
    }

    File getLocalPath(String frameworkName) {
        return new File(this.findSdkPath(this.findMacOsSdks()), "System/Library/Frameworks/" + frameworkName + ".framework");
    }

    GradleModuleMetadata getValue(String frameworkName, String version) {
        GradleModuleMetadata.Variant.File file = GradleModuleMetadata.Variant.File.ofLocalFile((File)this.getLocalPath(frameworkName));
        ImmutableList.Builder l = ImmutableList.builder().add((Object)this.compileVariant("compile", file, Collections.emptyList())).add((Object)this.linkVariant("link", file, Collections.emptyList())).add((Object)this.runtimeVariant("runtime", Collections.emptyList()));
        this.findSubFrameworks(this.getLocalPath(frameworkName)).forEach(it -> {
            l.add((Object)this.compileVariant("compileCapable", GradleModuleMetadata.Variant.File.ofLocalFile((File)it), this.toCapabilities(frameworkName, (File)it)));
            l.add((Object)this.linkVariant("linkCapable", GradleModuleMetadata.Variant.File.ofLocalFile((File)it), this.toCapabilities(frameworkName, (File)it)));
            l.add((Object)this.runtimeVariant("runtimeCapable", this.toCapabilities(frameworkName, (File)it)));
        });
        ImmutableList v = l.build();
        return GradleModuleMetadata.of((GradleModuleMetadata.Component)GradleModuleMetadata.Component.of((String)"dev.nokee.framework", (String)frameworkName, (String)version), (List)v);
    }

    List<GradleModuleMetadata.Variant.Capability> toCapabilities(String frameworkName, File subframework) {
        return Collections.singletonList(new GradleModuleMetadata.Variant.Capability(frameworkName, subframework.getName().substring(0, subframework.getName().lastIndexOf(".")), this.findSdkVersion(this.findMacOsSdks())));
    }

    List<File> findSubFrameworks(File framework) {
        if (!new File(framework, "Frameworks").exists()) {
            return Collections.emptyList();
        }
        try {
            return Files.walk(new File(framework, "Frameworks").toPath(), 1, FileVisitOption.FOLLOW_LINKS).filter(it -> Files.isDirectory(it, new LinkOption[0]) && it.getFileName().toString().endsWith(".framework")).map(Path::toFile).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    GradleModuleMetadata.Variant compileVariant(String name, GradleModuleMetadata.Variant.File file, List<GradleModuleMetadata.Variant.Capability> capabilities) {
        ImmutableMap attributes = ImmutableMap.builder().put((Object)"org.gradle.usage", (Object)"cplusplus-api").put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.getName(), (Object)"framework-bundle").build();
        return new GradleModuleMetadata.Variant(name, (Map)attributes, Collections.singletonList(file), capabilities);
    }

    GradleModuleMetadata.Variant linkVariant(String name, GradleModuleMetadata.Variant.File file, List<GradleModuleMetadata.Variant.Capability> capabilities) {
        ImmutableMap attributes = ImmutableMap.builder().put((Object)"org.gradle.usage", (Object)"native-link").put((Object)LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE.getName(), (Object)"framework-bundle").putAll(CURRENT_PLATFORM_ATTRIBUTES).build();
        return new GradleModuleMetadata.Variant(name, (Map)attributes, Collections.singletonList(file), capabilities);
    }

    GradleModuleMetadata.Variant runtimeVariant(String name, List<GradleModuleMetadata.Variant.Capability> capabilities) {
        ImmutableMap attributes = ImmutableMap.builder().put((Object)"org.gradle.usage", (Object)"native-runtime").putAll(CURRENT_PLATFORM_ATTRIBUTES).build();
        return new GradleModuleMetadata.Variant(name, (Map)attributes, Collections.emptyList(), capabilities);
    }
}

