/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.darwin.internal.locators;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.google.common.collect.ImmutableSet;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolOutputParser;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.runtime.base.internal.tools.CommandLineToolDescriptor;
import dev.nokee.runtime.base.internal.tools.CommandLineToolLocator;
import dev.nokee.runtime.base.internal.tools.DefaultCommandLineToolDescriptor;
import dev.nokee.runtime.darwin.internal.locators.XcodeUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.util.VersionNumber;
import org.xml.sax.SAXException;

public class XcodeLocator
implements CommandLineToolLocator {
    public Set<CommandLineToolDescriptor> findAll(String toolName) {
        switch (toolName) {
            case "ibtool": {
                return ImmutableSet.of((Object)this.findInterfaceBuilderTool());
            }
            case "codesign": {
                return ImmutableSet.of((Object)this.findCodeSignatureTool());
            }
            case "actool": {
                return ImmutableSet.of((Object)this.findAssetCompilerTool());
            }
        }
        throw new UnsupportedOperationException("Doesn't know tool...");
    }

    public Set<String> getKnownTools() {
        return ImmutableSet.of((Object)"ibtool", (Object)"codesign", (Object)"actool");
    }

    public CommandLineToolDescriptor findInterfaceBuilderTool() {
        File tool = XcodeUtils.findTool("ibtool");
        VersionNumber version = (VersionNumber)((ProcessBuilderEngine.Handle)CommandLineTool.of((File)tool).withArguments(new Object[]{"--version"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().parse(XcodeLocator.asVersion("com.apple.ibtool.version"));
        return new DefaultCommandLineToolDescriptor(tool, version.toString());
    }

    public CommandLineToolDescriptor findAssetCompilerTool() {
        File tool = XcodeUtils.findTool("actool");
        VersionNumber version = (VersionNumber)((ProcessBuilderEngine.Handle)CommandLineTool.of((File)tool).withArguments(new Object[]{"--version"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().parse(XcodeLocator.asVersion("com.apple.actool.version"));
        return new DefaultCommandLineToolDescriptor(tool, version.toString());
    }

    public CommandLineToolDescriptor findCodeSignatureTool() {
        File tool = XcodeUtils.findTool("codesign");
        VersionNumber version = VersionNumber.parse((String)"11.3.1");
        return new DefaultCommandLineToolDescriptor(tool, version.toString());
    }

    private static CommandLineToolOutputParser<VersionNumber> asVersion(String toolKey) {
        return content -> {
            try {
                NSObject obj = PropertyListParser.parse((byte[])content.getBytes());
                if (!(obj instanceof NSDictionary)) {
                    throw new RuntimeException();
                }
                NSDictionary dict = (NSDictionary)obj;
                if (!((obj = dict.get((Object)toolKey)) instanceof NSDictionary)) {
                    throw new RuntimeException();
                }
                dict = (NSDictionary)obj;
                return VersionNumber.parse((String)((String)dict.get((Object)"short-bundle-version").toJavaObject(String.class)));
            }
            catch (PropertyListFormatException | IOException | ParseException | ParserConfigurationException | SAXException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

