/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.darwin.internal.locators;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import dev.nokee.core.exec.CommandLineTool;
import dev.nokee.core.exec.CommandLineToolExecutionEngine;
import dev.nokee.core.exec.CommandLineToolOutputParser;
import dev.nokee.core.exec.ProcessBuilderEngine;
import dev.nokee.runtime.base.internal.tools.CommandLineToolDescriptor;
import dev.nokee.runtime.base.internal.tools.CommandLineToolLocator;
import dev.nokee.runtime.base.internal.tools.DefaultCommandLineToolDescriptor;
import java.io.File;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.util.VersionNumber;

public class XcrunLocator
implements CommandLineToolLocator {
    private static final Pattern XCRUN_VERSION_PATTERN = Pattern.compile("(\\d+(.\\d+)?)");

    public Set<CommandLineToolDescriptor> findAll(String toolName) {
        File tool = OperatingSystem.current().findInPath("xcrun");
        VersionNumber version = (VersionNumber)((ProcessBuilderEngine.Handle)CommandLineTool.of((File)tool).withArguments(new Object[]{"--version"}).execute((CommandLineToolExecutionEngine)new ProcessBuilderEngine())).waitFor().assertNormalExitValue().getStandardOutput().parse(XcrunLocator.asXcodeRunVersion());
        return ImmutableSet.of((Object)new DefaultCommandLineToolDescriptor(tool, version.toString()));
    }

    public Set<String> getKnownTools() {
        return ImmutableSet.of((Object)"xcrun");
    }

    @VisibleForTesting
    static CommandLineToolOutputParser<VersionNumber> asXcodeRunVersion() {
        return content -> {
            Matcher matcher = XCRUN_VERSION_PATTERN.matcher(content);
            if (matcher.find()) {
                return VersionNumber.parse((String)matcher.group(1));
            }
            throw new RuntimeException("Invalid version");
        };
    }
}

