/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.runtime.nativebase.internal;

import dev.nokee.runtime.nativebase.TargetMachine;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import java.util.function.Predicate;
import lombok.NonNull;

public class DefaultTargetMachine
implements TargetMachine {
    @NonNull
    private final DefaultOperatingSystemFamily operatingSystemFamily;
    @NonNull
    private final DefaultMachineArchitecture architecture;

    public static Predicate<TargetMachine> isTargetingHost() {
        return targetMachine -> DefaultOperatingSystemFamily.HOST.equals(targetMachine.getOperatingSystemFamily()) && DefaultMachineArchitecture.HOST.equals(targetMachine.getArchitecture());
    }

    @Override
    @NonNull
    public DefaultOperatingSystemFamily getOperatingSystemFamily() {
        return this.operatingSystemFamily;
    }

    @Override
    @NonNull
    public DefaultMachineArchitecture getArchitecture() {
        return this.architecture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultTargetMachine)) {
            return false;
        }
        DefaultTargetMachine other = (DefaultTargetMachine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DefaultOperatingSystemFamily this$operatingSystemFamily = this.getOperatingSystemFamily();
        DefaultOperatingSystemFamily other$operatingSystemFamily = other.getOperatingSystemFamily();
        if (this$operatingSystemFamily == null ? other$operatingSystemFamily != null : !((Object)this$operatingSystemFamily).equals(other$operatingSystemFamily)) {
            return false;
        }
        DefaultMachineArchitecture this$architecture = this.getArchitecture();
        DefaultMachineArchitecture other$architecture = other.getArchitecture();
        return !(this$architecture == null ? other$architecture != null : !((Object)this$architecture).equals(other$architecture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultTargetMachine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DefaultOperatingSystemFamily $operatingSystemFamily = this.getOperatingSystemFamily();
        result = result * 59 + ($operatingSystemFamily == null ? 43 : ((Object)$operatingSystemFamily).hashCode());
        DefaultMachineArchitecture $architecture = this.getArchitecture();
        result = result * 59 + ($architecture == null ? 43 : ((Object)$architecture).hashCode());
        return result;
    }

    public String toString() {
        return "DefaultTargetMachine(operatingSystemFamily=" + this.getOperatingSystemFamily() + ", architecture=" + this.getArchitecture() + ")";
    }

    public DefaultTargetMachine(@NonNull DefaultOperatingSystemFamily operatingSystemFamily, @NonNull DefaultMachineArchitecture architecture) {
        if (operatingSystemFamily == null) {
            throw new NullPointerException("operatingSystemFamily is marked non-null but is null");
        }
        if (architecture == null) {
            throw new NullPointerException("architecture is marked non-null but is null");
        }
        this.operatingSystemFamily = operatingSystemFamily;
        this.architecture = architecture;
    }
}

