/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.testing.xctest.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.nokee.language.base.tasks.SourceCompile;
import dev.nokee.language.objectivec.tasks.ObjectiveCCompile;
import dev.nokee.language.swift.internal.SwiftSourceSet;
import dev.nokee.platform.base.BinaryAwareComponent;
import dev.nokee.platform.base.DependencyAwareComponent;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.DefaultBuildVariant;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.platform.ios.internal.IosApplicationOutgoingDependencies;
import dev.nokee.platform.ios.internal.plugins.IosApplicationRules;
import dev.nokee.platform.nativebase.BundleBinary;
import dev.nokee.platform.nativebase.NativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.BaseNativeBinary;
import dev.nokee.platform.nativebase.internal.BaseNativeComponent;
import dev.nokee.platform.nativebase.internal.BaseNativeVariant;
import dev.nokee.platform.nativebase.internal.DefaultBinaryLinkage;
import dev.nokee.platform.nativebase.internal.dependencies.AbstractBinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.BinaryAwareNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultNativeComponentDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.DefaultSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.HeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NativeIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NativeOutgoingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoHeaderIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.NoSwiftModuleIncomingDependencies;
import dev.nokee.platform.nativebase.internal.dependencies.SwiftModuleIncomingDependencies;
import dev.nokee.runtime.base.internal.Dimension;
import dev.nokee.runtime.nativebase.internal.DefaultMachineArchitecture;
import dev.nokee.runtime.nativebase.internal.DefaultOperatingSystemFamily;
import dev.nokee.testing.xctest.internal.DefaultUnitTestXCTestTestSuiteComponent;
import dev.nokee.testing.xctest.internal.DefaultXCTestTestSuiteVariant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.nativeplatform.toolchain.Swiftc;
import org.gradle.util.GUtil;

public abstract class BaseXCTestTestSuiteComponent
extends BaseNativeComponent<DefaultXCTestTestSuiteVariant>
implements DependencyAwareComponent<NativeComponentDependencies>,
BinaryAwareComponent {
    private final DefaultNativeComponentDependencies dependencies;

    @Inject
    public BaseXCTestTestSuiteComponent(NamingScheme names) {
        super(names, DefaultXCTestTestSuiteVariant.class);
        this.dependencies = (DefaultNativeComponentDependencies)this.getObjects().newInstance(DefaultNativeComponentDependencies.class, new Object[]{names});
        this.getDimensions().convention((Iterable)ImmutableSet.of((Object)DefaultOperatingSystemFamily.DIMENSION_TYPE, (Object)DefaultMachineArchitecture.DIMENSION_TYPE, (Object)DefaultBinaryLinkage.DIMENSION_TYPE));
        this.getBuildVariants().convention(this.getProviders().provider(this::createBuildVariants));
        this.getBuildVariants().finalizeValueOnRead();
        this.getBuildVariants().disallowChanges();
        this.getDimensions().disallowChanges();
    }

    public abstract Property<GroupId> getGroupId();

    public abstract Property<BaseNativeComponent<?>> getTestedComponent();

    private Iterable<BuildVariant> createBuildVariants() {
        return ImmutableList.of((Object)DefaultBuildVariant.of((Dimension[])new Dimension[]{DefaultOperatingSystemFamily.forName((String)"ios"), DefaultMachineArchitecture.X86_64, DefaultBinaryLinkage.BUNDLE}));
    }

    public DefaultNativeComponentDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super NativeComponentDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    protected Provider<DefaultXCTestTestSuiteVariant> getDefaultVariant() {
        return this.getProviders().provider(() -> {
            List variants = this.getVariants().get().stream().map(it -> {
                Preconditions.checkArgument((boolean)(it instanceof BaseNativeVariant));
                return it;
            }).collect(Collectors.toList());
            if (variants.isEmpty()) {
                return null;
            }
            return (DefaultXCTestTestSuiteVariant)((Object)((Object)BaseXCTestTestSuiteComponent.one(variants)));
        });
    }

    protected DefaultXCTestTestSuiteVariant createVariant(String name, BuildVariant buildVariant, AbstractBinaryAwareNativeComponentDependencies variantDependencies) {
        NamingScheme names = this.getNames().forBuildVariant(buildVariant, (Collection)this.getBuildVariants().get());
        DefaultXCTestTestSuiteVariant result = (DefaultXCTestTestSuiteVariant)((Object)this.getObjects().newInstance(DefaultXCTestTestSuiteVariant.class, new Object[]{name, names, buildVariant, variantDependencies}));
        return result;
    }

    protected AbstractBinaryAwareNativeComponentDependencies newDependencies(NamingScheme names, BuildVariant buildVariant) {
        boolean hasSwift;
        DefaultNativeComponentDependencies variantDependencies = this.getDependencies();
        if (((Set)this.getBuildVariants().get()).size() > 1) {
            variantDependencies = variantDependencies.extendsWith(names);
        }
        SwiftModuleIncomingDependencies incomingSwiftDependencies = null;
        HeaderIncomingDependencies incomingHeaderDependencies = null;
        boolean bl = hasSwift = !this.getSourceCollection().withType(SwiftSourceSet.class).isEmpty();
        if (hasSwift) {
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(DefaultSwiftModuleIncomingDependencies.class, new Object[]{names, variantDependencies});
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(NoHeaderIncomingDependencies.class, new Object[0]);
        } else {
            incomingHeaderDependencies = (HeaderIncomingDependencies)this.getObjects().newInstance(DefaultHeaderIncomingDependencies.class, new Object[]{names, variantDependencies, buildVariant});
            incomingSwiftDependencies = (SwiftModuleIncomingDependencies)this.getObjects().newInstance(NoSwiftModuleIncomingDependencies.class, new Object[0]);
        }
        NativeIncomingDependencies incoming = (NativeIncomingDependencies)this.getObjects().newInstance(NativeIncomingDependencies.class, new Object[]{names, buildVariant, variantDependencies, incomingSwiftDependencies, incomingHeaderDependencies});
        NativeOutgoingDependencies outgoing = (NativeOutgoingDependencies)this.getObjects().newInstance(IosApplicationOutgoingDependencies.class, new Object[]{names, buildVariant, variantDependencies});
        return (AbstractBinaryAwareNativeComponentDependencies)this.getObjects().newInstance(BinaryAwareNativeComponentDependencies.class, new Object[]{variantDependencies, incoming, outgoing});
    }

    @Inject
    protected abstract DependencyHandler getDependencyHandler();

    protected void onEachVariant(BuildVariant buildVariant, VariantProvider<DefaultXCTestTestSuiteVariant> variant, NamingScheme names) {
        variant.configure(testSuite -> testSuite.getBinaries().configureEach(BundleBinary.class, binary -> {
            Provider moduleName = this.getTestedComponent().map(it -> it.getNames().getBaseName().getAsCamelCase());
            binary.getCompileTasks().configureEach(SourceCompile.class, task -> {
                task.getCompilerArgs().addAll(this.getProviders().provider(() -> ImmutableList.of((Object)"-target", (Object)"x86_64-apple-ios13.2-simulator", (Object)"-F", (Object)(IosApplicationRules.getSdkPath() + "/System/Library/Frameworks"), (Object)"-iframework", (Object)(DefaultUnitTestXCTestTestSuiteComponent.getSdkPlatformPath() + "/Developer/Library/Frameworks"))));
                task.getCompilerArgs().addAll(task.getToolChain().map(toolChain -> {
                    if (toolChain instanceof Swiftc) {
                        return ImmutableList.of((Object)"-sdk", (Object)IosApplicationRules.getSdkPath());
                    }
                    return ImmutableList.of((Object)"-isysroot", (Object)IosApplicationRules.getSdkPath());
                }));
                if (task instanceof ObjectiveCCompile) {
                    task.getCompilerArgs().addAll((Object[])new String[]{"-fobjc-arc"});
                }
            });
            binary.getLinkTask().configure(task -> {
                task.getLinkerArgs().addAll(this.getProviders().provider(() -> ImmutableList.of((Object)"-target", (Object)"x86_64-apple-ios13.2-simulator")));
                task.getLinkerArgs().addAll(task.getToolChain().map(toolChain -> {
                    if (toolChain instanceof Swiftc) {
                        return ImmutableList.of((Object)"-sdk", (Object)IosApplicationRules.getSdkPath());
                    }
                    return ImmutableList.of((Object)"-isysroot", (Object)IosApplicationRules.getSdkPath());
                }));
                task.getLinkerArgs().addAll(this.getProviders().provider(() -> ImmutableList.of((Object)"-Xlinker", (Object)"-rpath", (Object)"-Xlinker", (Object)"@executable_path/Frameworks", (Object)"-Xlinker", (Object)"-rpath", (Object)"-Xlinker", (Object)"@loader_path/Frameworks", (Object)"-Xlinker", (Object)"-export_dynamic", (Object)"-Xlinker", (Object)"-no_deduplicate", (Object[])new String[]{"-Xlinker", "-objc_abi_version", "-Xlinker", "2", "-fobjc-arc", "-fobjc-link-runtime", "-bundle_loader", ((RegularFile)this.getLayout().getBuildDirectory().file("exes/main/" + (String)moduleName.get()).get()).getAsFile().getAbsolutePath(), "-L" + DefaultUnitTestXCTestTestSuiteComponent.getSdkPlatformPath() + "/Developer/usr/lib", "-F" + DefaultUnitTestXCTestTestSuiteComponent.getSdkPlatformPath() + "/Developer/Library/Frameworks", "-framework", "XCTest"})));
            });
        }));
    }

    public void finalizeExtension(Project project) {
        this.getVariants().configureEach(variant -> variant.getBinaries().configureEach(BaseNativeBinary.class, binary -> binary.getBaseName().convention((Object)GUtil.toCamelCase((CharSequence)project.getName()))));
        super.finalizeExtension(project);
    }
}

