/*
 * Decompiled with CFR 0.152.
 */
package dev.nokee.testing.xctest.internal;

import com.google.common.collect.ImmutableList;
import dev.nokee.core.exec.internal.PathAwareCommandLineTool;
import dev.nokee.platform.base.Binary;
import dev.nokee.platform.base.internal.BuildVariant;
import dev.nokee.platform.base.internal.Component;
import dev.nokee.platform.base.internal.GroupId;
import dev.nokee.platform.base.internal.NamingScheme;
import dev.nokee.platform.base.internal.VariantProvider;
import dev.nokee.platform.ios.internal.SignedIosApplicationBundleInternal;
import dev.nokee.platform.ios.tasks.internal.CreateIosApplicationBundleTask;
import dev.nokee.platform.ios.tasks.internal.ProcessPropertyListTask;
import dev.nokee.platform.ios.tasks.internal.SignIosApplicationBundleTask;
import dev.nokee.platform.nativebase.BundleBinary;
import dev.nokee.platform.nativebase.internal.BundleBinaryInternal;
import dev.nokee.platform.nativebase.tasks.LinkBundle;
import dev.nokee.testing.xctest.internal.BaseXCTestTestSuiteComponent;
import dev.nokee.testing.xctest.internal.DefaultXCTestTestSuiteVariant;
import dev.nokee.testing.xctest.tasks.internal.CreateIosXCTestBundleTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public abstract class DefaultUiTestXCTestTestSuiteComponent
extends BaseXCTestTestSuiteComponent
implements Component {
    @Inject
    public DefaultUiTestXCTestTestSuiteComponent(NamingScheme names) {
        super(names);
    }

    @Override
    protected void onEachVariant(BuildVariant buildVariant, VariantProvider<DefaultXCTestTestSuiteVariant> variant, NamingScheme names) {
        super.onEachVariant(buildVariant, variant, names);
        variant.configure(testSuite -> {
            testSuite.getBinaries().configureEach(BundleBinary.class, binary -> ((BundleBinaryInternal)binary).getBaseName().set((Object)names.getBaseName().getAsCamelCase()));
            String moduleName = testSuite.getNames().getBaseName().getAsCamelCase();
            TaskProvider processUiTestPropertyListTask = this.getTasks().register("processUiTestPropertyList", ProcessPropertyListTask.class, task -> {
                task.getIdentifier().set(this.getProviders().provider(() -> (String)((GroupId)this.getGroupId().get()).get().get() + "." + moduleName));
                task.getModule().set((Object)moduleName);
                task.getSources().from(new Object[]{"src/uiTest/resources/Info.plist"});
                task.getOutputFile().set(this.getLayout().getBuildDirectory().file("ios/uiTest/Info.plist"));
            });
            TaskProvider createUiTestXCTestBundle = this.getTasks().register("createUiTestXCTestBundle", CreateIosXCTestBundleTask.class, task -> {
                task.getXCTestBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "-Runner-unsigned.xctest"));
                task.getSources().from(new Object[]{processUiTestPropertyListTask.flatMap(it -> it.getOutputFile())});
                task.getSources().from(new Object[]{testSuite.getBinaries().withType(BundleBinary.class).getElements().map(binaries -> binaries.stream().map(binary -> ((LinkBundle)binary.getLinkTask().get()).getLinkedFile()).collect(Collectors.toList()))});
            });
            Provider codeSignatureTool = this.getProviders().provider(() -> new PathAwareCommandLineTool(new File("/usr/bin/codesign")));
            TaskProvider signUiTestXCTestBundle = this.getTasks().register("signUiTestXCTestBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUiTestXCTestBundle.flatMap(CreateIosXCTestBundleTask::getXCTestBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + ".xctest"));
                task.getCodeSignatureTool().set(codeSignatureTool);
                task.getCodeSignatureTool().disallowChanges();
            });
            TaskProvider createUiTestApplicationBundleTask = this.getTasks().register("createUiTestLauncherApplicationBundle", CreateIosApplicationBundleTask.class, task -> {
                task.getApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "-Runner-unsigned.app"));
                task.getSources().from(new Object[]{this.getXCTRunner()});
                task.getPlugIns().from(new Object[]{signUiTestXCTestBundle.flatMap(SignIosApplicationBundleTask::getSignedApplicationBundle)});
                task.getFrameworks().from(new Object[]{this.getXCTestFrameworks()});
                task.getSwiftSupportRequired().set((Object)false);
            });
            TaskProvider signTask = this.getTasks().register("signUiTestLauncherApplicationBundle", SignIosApplicationBundleTask.class, task -> {
                task.getUnsignedApplicationBundle().set(createUiTestApplicationBundleTask.flatMap(CreateIosApplicationBundleTask::getApplicationBundle));
                task.getSignedApplicationBundle().set(this.getLayout().getBuildDirectory().file("ios/products/uiTest/" + moduleName + "-Runner.app"));
                task.getCodeSignatureTool().set(codeSignatureTool);
                task.getCodeSignatureTool().disallowChanges();
            });
            testSuite.getBinaryCollection().add((Object)((Binary)this.getObjects().newInstance(SignedIosApplicationBundleInternal.class, new Object[]{signTask})));
        });
        TaskProvider bundle = this.getTasks().register(names.getTaskName("bundle"), task -> task.dependsOn(new Object[]{variant.map(it -> it.getBinaries().withType(SignedIosApplicationBundleInternal.class).get())}));
    }

    private Provider<File> getXCTestBundleInjectDynamicLibrary() {
        return this.getProviders().provider(() -> new File(DefaultUiTestXCTestTestSuiteComponent.getSdkPlatformPath(), "Developer/usr/lib/libXCTestBundleInject.dylib"));
    }

    private Provider<List<File>> getXCTestFrameworks() {
        return this.getProviders().provider(() -> ImmutableList.builder().add((Object)new File(DefaultUiTestXCTestTestSuiteComponent.getSdkPlatformPath(), "Developer/Library/PrivateFrameworks/XCTAutomationSupport.framework")).add((Object)new File(DefaultUiTestXCTestTestSuiteComponent.getSdkPlatformPath(), "Developer/usr/lib/libXCTestSwiftSupport.dylib")).add((Object)new File(DefaultUiTestXCTestTestSuiteComponent.getSdkPlatformPath(), "Developer/Library/Frameworks/XCTest.framework")).build());
    }

    public static String getSdkPlatformPath() {
        try {
            Process process = new ProcessBuilder("xcrun", "--sdk", "iphonesimulator", "--show-sdk-platform-path").start();
            process.waitFor();
            return IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset()).trim();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Provider<File> getXCTRunner() {
        return this.getProviders().provider(() -> new File(DefaultUiTestXCTestTestSuiteComponent.getSdkPlatformPath(), "Developer/Library/Xcode/Agents/XCTRunner.app/XCTRunner"));
    }
}

