/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.serverlib;

import org.incendo.serverlib.CheckType;

public abstract class Check {
    private static final String EXPLANATION_BORDER = "************************************************************";
    private final CheckType type;

    public Check(CheckType type) {
        this.type = type;
    }

    public final CheckType type() {
        return this.type;
    }

    public abstract boolean shouldFlag();

    public abstract String[] explain();

    public final void printExplanation() {
        System.err.println(EXPLANATION_BORDER);
        System.err.printf("* Detected unsafe software: %s (type: %s)\n", this.getClass().getSimpleName(), this.type().name());
        System.err.println("*");
        for (String line : this.explain()) {
            System.err.printf("* %s\n", line);
        }
        System.err.println(EXPLANATION_BORDER);
    }
}

