/*
 * Decompiled with CFR 0.152.
 */
package dev.nx.gradle.utils.parsing;

import dev.nx.gradle.utils.parsing.JavaAstTestParserKt;
import dev.nx.gradle.utils.parsing.KotlinAstTestParserKt;
import dev.nx.gradle.utils.parsing.RegexTestParserKt;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"getAllVisibleClassesWithNestedAnnotation", "", "", "file", "Ljava/io/File;", "testTask", "Lorg/gradle/api/Task;", "project-graph"})
public final class TestClassParserKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Map<String, String> getAllVisibleClassesWithNestedAnnotation(@NotNull File file, @Nullable Task testTask) {
        Map<String, String> result;
        block41: {
            Map<String, String> map;
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Task task = testTask;
            Logger logger2 = logger = task != null ? task.getLogger() : null;
            if (logger2 != null) {
                logger2.info("=== Processing test file: " + file.getName() + " ===");
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null)) {
                Map<String, String> astResult;
                Logger logger3 = logger;
                if (logger3 != null) {
                    logger3.info("Attempting Java AST parsing for: " + file.getName());
                }
                try {
                    Map<String, String> map2;
                    astResult = JavaAstTestParserKt.parseJavaFileWithAst(file);
                    if (astResult != null && !astResult.isEmpty()) {
                        Logger logger4 = logger;
                        if (logger4 != null) {
                            logger4.info("Java AST parsing successful for: " + file.getName() + ", found " + astResult.size() + " classes: " + astResult.keySet());
                        }
                        map2 = astResult;
                    } else {
                        Logger logger5 = logger;
                        if (logger5 != null) {
                            logger5.info("Java AST parsing returned empty/null, falling back to regex for: " + file.getName());
                        }
                        map2 = RegexTestParserKt.parseTestClassesWithRegex(file);
                    }
                    astResult = map2;
                }
                catch (Exception e) {
                    Logger logger6 = logger;
                    if (logger6 != null) {
                        logger6.warn("Java AST parsing exception for " + file.getName() + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                    }
                    Logger logger7 = logger;
                    if (logger7 != null) {
                        logger7.info("Falling back to regex parsing for: " + file.getName());
                    }
                    astResult = RegexTestParserKt.parseTestClassesWithRegex(file);
                }
                catch (Error e) {
                    Logger logger8 = logger;
                    if (logger8 != null) {
                        logger8.warn("Java AST parsing error for " + file.getName() + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                    }
                    Logger logger9 = logger;
                    if (logger9 != null) {
                        logger9.info("Falling back to regex parsing for: " + file.getName());
                    }
                    astResult = RegexTestParserKt.parseTestClassesWithRegex(file);
                }
                map = astResult;
            } else {
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string2, (String)".kt", (boolean)false, (int)2, null)) {
                    Map<String, String> map3;
                    Logger logger10 = logger;
                    if (logger10 != null) {
                        logger10.info("Attempting Kotlin AST parsing for: " + file.getName());
                    }
                    try {
                        Map<String, String> map4;
                        if (!KotlinAstTestParserKt.isKotlinCompilerAvailable(logger)) {
                            Logger logger11 = logger;
                            if (logger11 != null) {
                                logger11.info("Kotlin compiler not available, using regex parsing for: " + file.getName());
                            }
                            Logger logger12 = logger;
                            if (logger12 != null) {
                                logger12.debug("Kotlin AST parsing failed: Required Kotlin compiler classes not found on classpath");
                            }
                            return RegexTestParserKt.parseTestClassesWithRegex(file);
                        }
                        Pair<Disposable, PsiManager> envPair = KotlinAstTestParserKt.createKotlinEnvironment();
                        if (envPair == null) {
                            Logger logger13 = logger;
                            if (logger13 != null) {
                                logger13.warn("Failed to create Kotlin environment, falling back to regex");
                            }
                            return RegexTestParserKt.parseTestClassesWithRegex(file);
                        }
                        Disposable disposable = (Disposable)envPair.component1();
                        PsiManager psiManager = (PsiManager)envPair.component2();
                        try {
                            Map<String, String> map5;
                            Map<String, String> astResult = KotlinAstTestParserKt.parseKotlinFileWithAst(file, psiManager, logger);
                            if (astResult != null) {
                                Logger logger14 = logger;
                                if (logger14 != null) {
                                    logger14.info("Successfully used Kotlin AST parsing for: " + file.getName());
                                }
                                map5 = astResult;
                            } else {
                                Logger logger15 = logger;
                                if (logger15 != null) {
                                    logger15.info("Kotlin AST parsing failed, falling back to regex for: " + file.getName());
                                }
                                map5 = RegexTestParserKt.parseTestClassesWithRegex(file);
                            }
                            map4 = map5;
                        }
                        finally {
                            disposable.dispose();
                        }
                        map3 = map4;
                    }
                    catch (Exception e) {
                        Logger logger16 = logger;
                        if (logger16 != null) {
                            logger16.warn("Kotlin AST parsing failed for " + file.getName() + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                        }
                        Logger logger17 = logger;
                        if (logger17 != null) {
                            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                            logger17.debug("Exception details: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])stackTraceElementArray, (int)3), null, null, null, (int)0, null, TestClassParserKt::getAllVisibleClassesWithNestedAnnotation$lambda$0, (int)31, null));
                        }
                        Logger logger18 = logger;
                        if (logger18 != null) {
                            logger18.info("Falling back to regex parsing for: " + file.getName());
                        }
                        map3 = RegexTestParserKt.parseTestClassesWithRegex(file);
                    }
                    catch (Error e) {
                        Logger logger19 = logger;
                        if (logger19 != null) {
                            logger19.warn("Kotlin AST parsing failed for " + file.getName() + ": " + e.getClass().getSimpleName() + " - " + e.getMessage());
                        }
                        Logger logger20 = logger;
                        if (logger20 != null) {
                            StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                            logger20.debug("Error details: " + CollectionsKt.joinToString$default((Iterable)ArraysKt.take((Object[])stackTraceElementArray, (int)3), null, null, null, (int)0, null, TestClassParserKt::getAllVisibleClassesWithNestedAnnotation$lambda$1, (int)31, null));
                        }
                        Logger logger21 = logger;
                        if (logger21 != null) {
                            logger21.info("Falling back to regex parsing for: " + file.getName());
                        }
                        map3 = RegexTestParserKt.parseTestClassesWithRegex(file);
                    }
                    map = map3;
                } else {
                    Logger logger22 = logger;
                    if (logger22 != null) {
                        logger22.info("Using regex parsing for non-Java/Kotlin file: " + file.getName());
                    }
                    map = RegexTestParserKt.parseTestClassesWithRegex(file);
                }
            }
            result = map;
            Logger logger23 = logger;
            if (logger23 == null) break block41;
            Map<String, String> map6 = result;
            logger23.info("Final result for " + file.getName() + ": " + (map6 != null ? map6.keySet() : null));
        }
        return result;
    }

    public static /* synthetic */ Map getAllVisibleClassesWithNestedAnnotation$default(File file, Task task, int n, Object object) {
        if ((n & 2) != 0) {
            task = null;
        }
        return TestClassParserKt.getAllVisibleClassesWithNestedAnnotation(file, task);
    }

    private static final CharSequence getAllVisibleClassesWithNestedAnnotation$lambda$0(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final CharSequence getAllVisibleClassesWithNestedAnnotation$lambda$1(StackTraceElement it) {
        String string = it.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

