/*
 * Decompiled with CFR 0.152.
 */
package dev.oak3.sbs4j;

import dev.oak3.sbs4j.exception.ValueDeserializationException;
import dev.oak3.sbs4j.util.ByteUtils;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerBuffer {
    private final ByteBuffer buffer;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializerBuffer.class);
    private static final String LOG_BUFFER_INIT_MESSAGE_HEX_STRING = "Initializing DeserializerBuffer with hexString: {} and byte order {}";
    private static final String LOG_BUFFER_INIT_MESSAGE = "Initializing DeserializerBuffer with bytes: {} and byte order {}";
    private static final String LOG_BUFFER_VALUE_MESSAGE_STRING = "Buffer value: {}";
    private static final String LOG_SERIALIZED_VALUE_MESSAGE_STRING = "Deserialized value for {}: {}";
    private static final String SERIALIZE_EXCEPTION_OUT_OF_BOUNDS_MESSAGE_STRING = "Value %s out of bounds for expected type %s";

    public DeserializerBuffer(String hexString) {
        this(hexString.length() != 0 ? ByteUtils.parseHexString(hexString) : new byte[]{});
    }

    public DeserializerBuffer(String hexString, ByteOrder byteOrder) {
        this(hexString.length() != 0 ? ByteUtils.parseHexString(hexString) : new byte[]{}, byteOrder);
        LOGGER.debug(LOG_BUFFER_INIT_MESSAGE_HEX_STRING, (Object)hexString, (Object)byteOrder);
    }

    public DeserializerBuffer(byte[] bytes) {
        this(bytes, ByteOrder.LITTLE_ENDIAN);
    }

    public DeserializerBuffer(byte[] bytes, ByteOrder byteOrder) {
        this.buffer = ByteBuffer.wrap(bytes);
        this.buffer.order(byteOrder);
        this.buffer.mark();
        LOGGER.debug(LOG_BUFFER_INIT_MESSAGE, (Object)Arrays.toString(bytes), (Object)byteOrder);
    }

    public Boolean readBool() throws ValueDeserializationException {
        try {
            byte buf = this.buffer.get();
            LOGGER.debug(LOG_BUFFER_VALUE_MESSAGE_STRING, (Object)buf);
            if (buf == 1) {
                return true;
            }
            if (buf == 0) {
                return false;
            }
            throw new ValueDeserializationException(String.format(SERIALIZE_EXCEPTION_OUT_OF_BOUNDS_MESSAGE_STRING, buf, Boolean.class.getSimpleName()));
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading boolean from buffer", bufferUnderflowException);
        }
    }

    public byte readU8() throws ValueDeserializationException {
        try {
            byte u8 = this.buffer.get();
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Byte.class.getSimpleName(), (Object)u8);
            return u8;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U8 from buffer", bufferUnderflowException);
        }
    }

    public byte[] readByteArray(int length) throws ValueDeserializationException {
        try {
            byte[] bytes = this.readBytes(length);
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Byte.class.getSimpleName(), (Object)bytes);
            return bytes;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading byte array from buffer", bufferUnderflowException);
        }
    }

    public float readF32() throws ValueDeserializationException {
        try {
            float floatNumber = this.buffer.getFloat();
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Float.class.getSimpleName(), (Object)Float.valueOf(floatNumber));
            return floatNumber;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading F32 from buffer", bufferUnderflowException);
        }
    }

    public double readF64() throws ValueDeserializationException {
        try {
            double doubleNumber = this.buffer.getDouble();
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Double.class.getSimpleName(), (Object)doubleNumber);
            return doubleNumber;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading F64 from buffer", bufferUnderflowException);
        }
    }

    public int readI32() throws ValueDeserializationException {
        try {
            int integerNumber = this.buffer.getInt();
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Long.class.getSimpleName(), (Object)integerNumber);
            return integerNumber;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading I32 from buffer", bufferUnderflowException);
        }
    }

    public long readU32() throws ValueDeserializationException {
        try {
            int signedInteger = this.buffer.getInt();
            long unsignedIntegerLong = Integer.toUnsignedLong(signedInteger);
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Long.class.getSimpleName(), (Object)unsignedIntegerLong);
            return unsignedIntegerLong;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U32 from buffer", bufferUnderflowException);
        }
    }

    public long readI64() throws ValueDeserializationException {
        try {
            long longNumber = this.buffer.getLong();
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)Long.class.getSimpleName(), (Object)longNumber);
            return longNumber;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading I64 from buffer", bufferUnderflowException);
        }
    }

    public BigInteger readU64() throws ValueDeserializationException {
        try {
            ByteBuffer bb = ByteBuffer.allocate(9);
            bb.put((byte)0);
            bb.putLong(this.buffer.getLong());
            BigInteger unsignedLong = new BigInteger(bb.array());
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)BigInteger.class.getSimpleName(), (Object)unsignedLong);
            return unsignedLong;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U64 from buffer", bufferUnderflowException);
        }
    }

    public BigInteger readU128() throws ValueDeserializationException {
        try {
            return this.readBigInteger();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U128 from buffer", bufferUnderflowException);
        }
    }

    public BigInteger readU256() throws ValueDeserializationException {
        try {
            return this.readBigInteger();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U256 from buffer", bufferUnderflowException);
        }
    }

    public BigInteger readU512() throws ValueDeserializationException {
        try {
            return this.readBigInteger();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading U512 from buffer", bufferUnderflowException);
        }
    }

    protected BigInteger readBigInteger() {
        byte lengthOfNextNumber = this.buffer.get();
        LOGGER.debug("Length of next number: {}", (Object)lengthOfNextNumber);
        byte[] buf = new byte[lengthOfNextNumber + 1];
        this.buffer.get(buf, 1, lengthOfNextNumber);
        LOGGER.debug(LOG_BUFFER_VALUE_MESSAGE_STRING, (Object)buf);
        if (this.buffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ByteUtils.reverse(buf, 1, buf.length - 1);
        }
        BigInteger bigInt = new BigInteger(buf);
        LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)BigInteger.class.getSimpleName(), (Object)bigInt);
        return bigInt;
    }

    public String readString() throws ValueDeserializationException {
        try {
            int length = this.buffer.getInt();
            LOGGER.debug("Reading string of length: {}", (Object)length);
            byte[] bufString = new byte[length];
            this.buffer.get(bufString, 0, length);
            LOGGER.debug(LOG_BUFFER_VALUE_MESSAGE_STRING, (Object)bufString);
            String string = new String(bufString, StandardCharsets.UTF_8);
            LOGGER.debug(LOG_SERIALIZED_VALUE_MESSAGE_STRING, (Object)String.class.getSimpleName(), (Object)string);
            return string;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new ValueDeserializationException("Error while reading String from buffer", bufferUnderflowException);
        }
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    protected byte[] readBytes(int length) {
        byte[] buf = new byte[length];
        this.buffer.get(buf, 0, length);
        LOGGER.debug(LOG_BUFFER_VALUE_MESSAGE_STRING, (Object)buf);
        return buf;
    }
}

