/*
 * Decompiled with CFR 0.152.
 */
package dev.oak3.sbs4j.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteUtils.class);

    public static void reverse(byte[] bytes) {
        ByteUtils.reverse(bytes, 0, bytes.length - 1);
    }

    public static void reverse(byte[] bytes, int from, int to) {
        LOGGER.debug("Reversing {}", (Object)bytes);
        int i = from;
        while ((double)i < Math.ceil((float)(to - from) / 2.0f) + (double)from) {
            byte temp = bytes[i];
            bytes[i] = bytes[to - i + from];
            bytes[to - i + from] = temp;
            ++i;
        }
        LOGGER.debug("Reversed {}", (Object)bytes);
    }

    public static byte[] parseHexString(String hexString) throws IllegalArgumentException {
        int len = hexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + hexString);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = ByteUtils.hexToByte(hexString.charAt(i));
            int l = ByteUtils.hexToByte(hexString.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + hexString);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    private static int hexToByte(char charToConvert) {
        if ('0' <= charToConvert && charToConvert <= '9') {
            return charToConvert - 48;
        }
        if ('A' <= charToConvert && charToConvert <= 'F') {
            return charToConvert - 65 + 10;
        }
        if ('a' <= charToConvert && charToConvert <= 'f') {
            return charToConvert - 97 + 10;
        }
        return -1;
    }

    public static String encodeHexString(byte[] byteArray) {
        return ByteUtils.encodeHexString(byteArray, HexCase.LOWER);
    }

    public static String encodeHexString(byte[] byteArray, HexCase hexCase) {
        StringBuilder r = new StringBuilder(byteArray.length * 2);
        for (byte b : byteArray) {
            r.append(hexCase.getHexCodes()[b >> 4 & 0xF]);
            r.append(hexCase.getHexCodes()[b & 0xF]);
        }
        return r.toString();
    }

    public static enum HexCase {
        LOWER("0123456789abcdef".toCharArray()),
        UPPER("0123456789ABCDEF".toCharArray());

        private final char[] hexCodes;

        public char[] getHexCodes() {
            return this.hexCodes;
        }

        private HexCase(char[] hexCodes) {
            this.hexCodes = hexCodes;
        }
    }
}

