/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MockDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.hub.HubConfiguration;
import liquibase.hub.HubService;
import liquibase.hub.HubServiceFactory;
import liquibase.hub.core.MockHubService;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.MockChangeLogParser;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.sdk.resource.MockResourceAccessor;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.ui.ConsoleUIService;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.spockframework.runtime.ErrorCollector;
import org.spockframework.runtime.SpockRuntime;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.BlockKind;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="LiquibaseTest.groovy", line=40)
public class LiquibaseTest
extends Specification
implements GroovyObject {
    @FieldMetadata(line=42, name="setupScopeId", ordinal=0, initializer=false)
    private String setupScopeId;
    @FieldMetadata(line=43, name="mockResourceAccessor", ordinal=1, initializer=false)
    private MockResourceAccessor mockResourceAccessor;
    @FieldMetadata(line=44, name="mockDatabase", ordinal=2, initializer=false)
    private Database mockDatabase;
    @FieldMetadata(line=45, name="mockLockServiceFactory", ordinal=3, initializer=false)
    private LockServiceFactory mockLockServiceFactory;
    @FieldMetadata(line=46, name="mockLockService", ordinal=4, initializer=false)
    private LockService mockLockService;
    @FieldMetadata(line=47, name="mockHubService", ordinal=5, initializer=false)
    private MockHubService mockHubService;
    @FieldMetadata(line=49, name="mockChangeLogParserFactory", ordinal=6, initializer=false)
    private ChangeLogParserFactory mockChangeLogParserFactory;
    @FieldMetadata(line=50, name="mockChangeLogParser", ordinal=7, initializer=false)
    private ChangeLogParser mockChangeLogParser;
    @FieldMetadata(line=51, name="mockChangeLog", ordinal=8, initializer=false)
    private DatabaseChangeLog mockChangeLog;
    @FieldMetadata(line=52, name="mockChangeLogIterator", ordinal=9, initializer=false)
    private ChangeLogIterator mockChangeLogIterator;
    @FieldMetadata(line=54, name="h2Connection", ordinal=10, initializer=false)
    private JdbcConnection h2Connection;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LiquibaseTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private Object setup() {
        MockHubService mockHubService;
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        Object var2_2 = null;
        this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType(var2_2, JdbcConnection.class);
        Object object = callSiteArray[0].callConstructor(MockResourceAccessor.class);
        this.mockResourceAccessor = (MockResourceAccessor)ScriptBytecodeAdapter.castToType((Object)object, MockResourceAccessor.class);
        callSiteArray[1].call(ChangeLogParserFactory.class, (Object)this.mockChangeLogParserFactory);
        Object object2 = callSiteArray[2].callConstructor(MockDatabase.class);
        this.mockDatabase = (Database)ScriptBytecodeAdapter.castToType((Object)object2, Database.class);
        Object object3 = callSiteArray[3].call(Scope.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[4].call((Object)"liquibase.plugin.", callSiteArray[5].callGetProperty(HubService.class)), MockHubService.class}));
        this.setupScopeId = ShortTypeHandling.castToString((Object)object3);
        this.mockHubService = mockHubService = (MockHubService)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].callGetProperty(Scope.class), HubServiceFactory.class)), MockHubService.class);
        callSiteArray[9].call((Object)this.mockHubService);
        Object databaseChangeLog = callSiteArray[10].callConstructor(DatabaseChangeLog.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"changeLogId", callSiteArray[11].call(callSiteArray[12].callGetProperty(MockHubService.class))}));
        callSiteArray[13].call(databaseChangeLog, callSiteArray[14].callConstructor(ChangeSet.class, ArrayUtil.createArray((Object)"test", (Object)"test", (Object)false, (Object)false, (Object)"test", (Object)"", (Object)"", (Object)databaseChangeLog)));
        return callSiteArray[15].call(callSiteArray[16].call(ChangeLogParserFactory.class), callSiteArray[17].callConstructor(MockChangeLogParser.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"changeLogs", ScriptBytecodeAdapter.createMap((Object[])new Object[]{"com/example/changelog.mock", databaseChangeLog})})));
    }

    private Object cleanup() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        callSiteArray[18].call((Object)this.mockHubService);
        callSiteArray[19].call(LockServiceFactory.class);
        callSiteArray[20].call(ChangeLogParserFactory.class);
        callSiteArray[21].call(Scope.class, (Object)this.setupScopeId);
        callSiteArray[22].call(ChangeLogParserFactory.class);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.h2Connection, null)) {
            return callSiteArray[23].call((Object)this.h2Connection);
        }
        return null;
    }

    private JdbcConnection getInMemoryH2DatabaseConnection() throws SQLException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        String urlFormat = "jdbc:h2:mem:%s";
        return (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].callConstructor(JdbcConnection.class, callSiteArray[25].call(DriverManager.class, callSiteArray[26].callStatic(String.class, (Object)urlFormat, callSiteArray[27].call(callSiteArray[28].call(UUID.class))))), JdbcConnection.class);
    }

    private Liquibase createUnmanagedDatabase(JdbcConnection connection) throws SQLException, LiquibaseException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        String createTableSql = "CREATE TABLE PUBLIC.TABLE_A (ID INTEGER);";
        PreparedStatement stmt = (PreparedStatement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call(callSiteArray[30].call((Object)connection), (Object)createTableSql), PreparedStatement.class);
        try {
            callSiteArray[31].call((Object)stmt);
        }
        catch (Throwable throwable) {
            callSiteArray[33].call((Object)stmt);
            throw throwable;
        }
        callSiteArray[32].call((Object)stmt);
        return (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].callConstructor(Liquibase.class, (Object)"liquibase/tagged-changelog.xml", callSiteArray[35].callConstructor(ClassLoaderResourceAccessor.class), (Object)connection), Liquibase.class);
    }

    private Liquibase createDatabaseAtTag(JdbcConnection connection, String tag) throws LiquibaseException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[36].callConstructor(Liquibase.class, (Object)"liquibase/tagged-changelog.xml", callSiteArray[37].callConstructor(ClassLoaderResourceAccessor.class), (Object)connection), Liquibase.class);
        callSiteArray[38].call((Object)liquibase, (Object)tag, (Object)"");
        return liquibase;
    }

    private boolean hasDatabaseChangeLogTable(Liquibase liquibase) throws DatabaseException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[39].call(callSiteArray[40].call(SnapshotGeneratorFactory.class), callSiteArray[41].callGetProperty((Object)liquibase)));
    }

    private void assertTags(Liquibase liquibase, String ... expectedTags) throws DatabaseException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        List actualTags = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object ranChangeset = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].callGetProperty((Object)liquibase))), Iterator.class);
        while (iterator.hasNext()) {
            ranChangeset = iterator.next();
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[45].call(ranChangeset), null)) continue;
            callSiteArray[46].call((Object)actualTags, callSiteArray[47].call(ranChangeset));
        }
        callSiteArray[48].callStatic(Assert.class, callSiteArray[49].call(Arrays.class, (Object)expectedTags), (Object)actualTags);
    }

    private void assertSqlOutputAppliesTags(String output, String ... expectedTags) throws IOException {
        BufferedReader reader;
        CallSite[] callSiteArray;
        block5: {
            callSiteArray = LiquibaseTest.$getCallSiteArray();
            String insertTagH2SqlTemplate = "INSERT INTO PUBLIC\\.DATABASECHANGELOG \\(.*, DESCRIPTION,.*, TAG\\) VALUES \\(.*, 'tagDatabase',.*, '%s'\\);";
            List patterns = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Object tag = null;
            Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call((Object)expectedTags), Iterator.class);
            while (iterator.hasNext()) {
                tag = iterator.next();
                callSiteArray[51].call((Object)patterns, callSiteArray[52].call(Pattern.class, callSiteArray[53].call(String.class, (Object)insertTagH2SqlTemplate, tag)));
            }
            reader = (BufferedReader)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].callConstructor(BufferedReader.class, callSiteArray[55].callConstructor(StringReader.class, (Object)output)), BufferedReader.class);
            try {
                String line = null;
                int index = 0;
                while (true) {
                    Object object = callSiteArray[56].call((Object)reader);
                    line = ShortTypeHandling.castToString((Object)object);
                    if (!(ScriptBytecodeAdapter.compareNotEqual((Object)object, null) && ScriptBytecodeAdapter.compareLessThan((Object)index, (Object)callSiteArray[57].call((Object)patterns)))) break;
                    Matcher matcher = (Matcher)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call(callSiteArray[59].call((Object)patterns, (Object)index), (Object)line), Matcher.class);
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)matcher))) continue;
                    int n = index;
                    index = DefaultTypeTransformation.intUnbox((Object)callSiteArray[61].call((Object)n));
                }
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    callSiteArray[62].callStatic(Assert.class, (Object)(index > 0 && ScriptBytecodeAdapter.compareEqual((Object)index, (Object)callSiteArray[63].call((Object)patterns)) ? 1 : 0));
                    break block5;
                }
                callSiteArray[64].callStatic(Assert.class, (Object)(index > 0 && ScriptBytecodeAdapter.compareEqual((Object)index, (Object)callSiteArray[65].call((Object)patterns)) ? 1 : 0));
            }
            catch (Throwable throwable) {
                callSiteArray[67].call((Object)reader);
                throw throwable;
            }
        }
        callSiteArray[66].call((Object)reader);
    }

    @FeatureMetadata(line=132, name="testConstructor", ordinal=0, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_0() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[68].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[69].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            MockResourceAccessor resourceAccessor = this.mockResourceAccessor;
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[70].callConstructor(Liquibase.class, (Object)"com/example/test.xml", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertNotNull(\"change log object may not be null\", liquibase.getLog())", (int)140, (int)9, null, Assert.class, (String)"assertNotNull", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"change log object may not be null"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"getLog"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(8).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)7);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertNotNull(\"change log object may not be null\", liquibase.getLog())", (int)140, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertEquals(\"correct name of the change log file is returned\",\n                \"com/example/test.xml\", liquibase.getChangeLogFile())", (int)142, (int)9, null, Assert.class, (String)"assertEquals", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"correct name of the change log file is returned"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"com/example/test.xml"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getChangeLogFile"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertEquals(\"correct name of the change log file is returned\",\n                \"com/example/test.xml\", liquibase.getChangeLogFile())", (int)142, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSame(\"ressourceAccessor property is set as requested\",\n                resourceAccessor, liquibase.getResourceAccessor())", (int)145, (int)9, null, Assert.class, (String)"assertSame", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"ressourceAccessor property is set as requested"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)resourceAccessor), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getResourceAccessor"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSame(\"ressourceAccessor property is set as requested\",\n                resourceAccessor, liquibase.getResourceAccessor())", (int)145, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertNotNull(\"parameters list for the change log is not null\",\n                liquibase.getChangeLogParameters())", (int)148, (int)9, null, Assert.class, (String)"assertNotNull", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"parameters list for the change log is not null"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"getChangeLogParameters"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(8).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)7);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertNotNull(\"parameters list for the change log is not null\",\n                liquibase.getChangeLogParameters())", (int)148, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertEquals(\"Standard database changelog parameters were not set\",\n                \"DATABASECHANGELOGLOCK\",\n                liquibase.getChangeLogParameters().getValue(\"database.databaseChangeLogLockTableName\", null)\n        )", (int)150, (int)9, null, Assert.class, (String)"assertEquals", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"Standard database changelog parameters were not set"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"DATABASECHANGELOGLOCK"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(11).intValue()), ScriptBytecodeAdapter.invokeMethodN(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getChangeLogParameters")))), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), (Object)"getValue")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(8).intValue()), (Object)"database.databaseChangeLogLockTableName"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(9).intValue()), null)}))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(14).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)13);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertEquals(\"Standard database changelog parameters were not set\",\n                \"DATABASECHANGELOGLOCK\",\n                liquibase.getChangeLogParameters().getValue(\"database.databaseChangeLogLockTableName\", null)\n        )", (int)150, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSame(\"database object for the change log is set as requested\",\n                mockDatabase, liquibase.getDatabase())", (int)155, (int)9, null, Assert.class, (String)"assertSame", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"database object for the change log is set as requested"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)this.mockDatabase), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getDatabase"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSame(\"database object for the change log is set as requested\",\n                mockDatabase, liquibase.getDatabase())", (int)155, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[71].call(callSiteArray[72].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=159, name="testConstructorChangelogPathsStandardize", ordinal=1, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_1() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[73].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callConstructor(Liquibase.class, (Object)"path\\with\\windows\\separators.xml", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertEquals(\"Windows path separators are translated correctly\",\n                \"path/with/windows/separators.xml\", liquibase.getChangeLogFile())", (int)164, (int)9, null, Assert.class, (String)"assertEquals", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"Windows path separators are translated correctly"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"path/with/windows/separators.xml"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getChangeLogFile"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertEquals(\"Windows path separators are translated correctly\",\n                \"path/with/windows/separators.xml\", liquibase.getChangeLogFile())", (int)164, (int)9, null, (Throwable)throwable);
            }
            Object object = callSiteArray[76].callConstructor(Liquibase.class, (Object)"path/with/unix/separators.xml", (Object)this.mockResourceAccessor, (Object)this.mockDatabase);
            liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)object, Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertEquals(\"Unix path separators are left intact\",\n                \"path/with/unix/separators.xml\", liquibase.getChangeLogFile())", (int)170, (int)9, null, Assert.class, (String)"assertEquals", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"Unix path separators are left intact"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"path/with/unix/separators.xml"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getChangeLogFile"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertEquals(\"Unix path separators are left intact\",\n                \"path/with/unix/separators.xml\", liquibase.getChangeLogFile())", (int)170, (int)9, null, (Throwable)throwable);
            }
            Object object2 = callSiteArray[77].callConstructor(Liquibase.class, (Object)"/absolute/path/remains.xml", (Object)this.mockResourceAccessor, (Object)this.mockDatabase);
            liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)object2, Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertEquals(\"An absolute path is left intact\",\n                \"/absolute/path/remains.xml\", liquibase.getChangeLogFile())", (int)176, (int)9, null, Assert.class, (String)"assertEquals", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"An absolute path is left intact"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"/absolute/path/remains.xml"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"getChangeLogFile"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertEquals(\"An absolute path is left intact\",\n                \"/absolute/path/remains.xml\", liquibase.getChangeLogFile())", (int)176, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[78].call(callSiteArray[79].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=198, name="testGetResourceAccessor", ordinal=2, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_2() throws LiquibaseException {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[82].callConstructor(Liquibase.class, (Object)"com/example/test.xml", (Object)this.mockResourceAccessor, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)this.mockDatabase, Database.class)), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSame(\"ressourceAccessor is set as requested\",\n                liquibase.getResourceAccessor(), liquibase.getResourceAccessor())", (int)203, (int)9, null, Assert.class, (String)"assertSame", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"ressourceAccessor is set as requested"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"getResourceAccessor")))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(9).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), (Object)"getResourceAccessor"))))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(12).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)11);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSame(\"ressourceAccessor is set as requested\",\n                liquibase.getResourceAccessor(), liquibase.getResourceAccessor())", (int)203, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[83].call(callSiteArray[84].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=218, name="update() communicates with hub", ordinal=3, blocks={@BlockMetadata(kind=BlockKind.SETUP, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_3() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[85].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Map scopedObjects = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callConstructor(HashMap.class), Map.class);
            TestConsoleUIService uiService = (TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[88].callConstructor(TestConsoleUIService.class), TestConsoleUIService.class));
            callSiteArray[89].call((Object)scopedObjects, callSiteArray[90].call(callSiteArray[91].callGetProperty(Scope.Attr.class)), (Object)uiService);
            Object scopeId = callSiteArray[92].call(Scope.class, null, (Object)scopedObjects);
            Reference liquibase = new Reference((Object)((Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callConstructor(Liquibase.class, (Object)"com/example/changelog.mock", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class)));
            public class __spock_feature_0_3_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference liquibase;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __spock_feature_0_3_closure1(Object _outerInstance, Object _thisObject, Reference liquibase) {
                    Reference reference;
                    CallSite[] callSiteArray = __spock_feature_0_3_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.liquibase = reference = liquibase;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = __spock_feature_0_3_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(this.liquibase.get());
                }

                public Liquibase getLiquibase() {
                    CallSite[] callSiteArray = __spock_feature_0_3_closure1.$getCallSiteArray();
                    return (Liquibase)ScriptBytecodeAdapter.castToType((Object)this.liquibase.get(), Liquibase.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = __spock_feature_0_3_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __spock_feature_0_3_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "update";
                    return new CallSiteArray(__spock_feature_0_3_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __spock_feature_0_3_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[94].call(Scope.class, callSiteArray[95].call(callSiteArray[96].callGetProperty(HubConfiguration.class)), (Object)"API_KEY", (Object)new __spock_feature_0_3_closure1((Object)this, (Object)this, liquibase));
            callSiteArray[97].call(Scope.class, scopeId);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"mockHubService.sentObjects.toString() ==\n                \"[setRanChangeSets/Connection jdbc://test ($MockHubService.randomUUID):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/$MockHubService.randomUUID:[$MockHubService.operationCreateDate]]\"", (int)234, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(12).intValue()), (Object)ScriptBytecodeAdapter.compareEqual((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), callSiteArray[98].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)this.mockHubService))), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(11).intValue()), (Object)new GStringImpl(new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), callSiteArray[99].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), MockHubService.class))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(8).intValue()), callSiteArray[100].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), MockHubService.class))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(10).intValue()), callSiteArray[101].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(9).intValue()), MockHubService.class)))}, new String[]{"[setRanChangeSets/Connection jdbc://test (", "):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/", ":[", "]]"})))));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"mockHubService.sentObjects.toString() ==\n                \"[setRanChangeSets/Connection jdbc://test ($MockHubService.randomUUID):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/$MockHubService.randomUUID:[$MockHubService.operationCreateDate]]\"", (int)234, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[102].call(callSiteArray[103].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=239, name="update(\"\") communicates with hub", ordinal=4, blocks={@BlockMetadata(kind=BlockKind.SETUP, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_4() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[104].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Map scopedObjects = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[106].callConstructor(HashMap.class), Map.class);
            TestConsoleUIService uiService = (TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[107].callConstructor(TestConsoleUIService.class), TestConsoleUIService.class));
            callSiteArray[108].call((Object)scopedObjects, callSiteArray[109].call(callSiteArray[110].callGetProperty(Scope.Attr.class)), (Object)uiService);
            Object scopeId = callSiteArray[111].call(Scope.class, null, (Object)scopedObjects);
            Reference liquibase = new Reference((Object)((Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[112].callConstructor(Liquibase.class, (Object)"com/example/changelog.mock", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class)));
            public class __spock_feature_0_4_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference liquibase;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __spock_feature_0_4_closure2(Object _outerInstance, Object _thisObject, Reference liquibase) {
                    Reference reference;
                    CallSite[] callSiteArray = __spock_feature_0_4_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.liquibase = reference = liquibase;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = __spock_feature_0_4_closure2.$getCallSiteArray();
                    return callSiteArray[0].call(this.liquibase.get(), (Object)"");
                }

                public Liquibase getLiquibase() {
                    CallSite[] callSiteArray = __spock_feature_0_4_closure2.$getCallSiteArray();
                    return (Liquibase)ScriptBytecodeAdapter.castToType((Object)this.liquibase.get(), Liquibase.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = __spock_feature_0_4_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __spock_feature_0_4_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "update";
                    return new CallSiteArray(__spock_feature_0_4_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __spock_feature_0_4_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[113].call(Scope.class, callSiteArray[114].call(callSiteArray[115].callGetProperty(HubConfiguration.class)), (Object)"API_KEY", (Object)new __spock_feature_0_4_closure2((Object)this, (Object)this, liquibase));
            callSiteArray[116].call(Scope.class, scopeId);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"mockHubService.sentObjects.toString() ==\n          \"[setRanChangeSets/Connection jdbc://test ($MockHubService.randomUUID):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/$MockHubService.randomUUID:[$MockHubService.operationCreateDate]]\"", (int)254, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(12).intValue()), (Object)ScriptBytecodeAdapter.compareEqual((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), callSiteArray[117].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)this.mockHubService))), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(11).intValue()), (Object)new GStringImpl(new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), callSiteArray[118].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), MockHubService.class))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(8).intValue()), callSiteArray[119].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), MockHubService.class))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(10).intValue()), callSiteArray[120].callGetProperty($spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(9).intValue()), MockHubService.class)))}, new String[]{"[setRanChangeSets/Connection jdbc://test (", "):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/", ":[", "]]"})))));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"mockHubService.sentObjects.toString() ==\n          \"[setRanChangeSets/Connection jdbc://test ($MockHubService.randomUUID):[test/changelog.xml::1::mock-author, test/changelog.xml::2::mock-author, test/changelog.xml::3::mock-author], startOperation/$MockHubService.randomUUID:[$MockHubService.operationCreateDate]]\"", (int)254, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[121].call(callSiteArray[122].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=259, name="getConnection does not return warning message if API key does not exist and the changelog is registered", ordinal=5, blocks={@BlockMetadata(kind=BlockKind.SETUP, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_5() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[123].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[124].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Map scopedObjects = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[125].callConstructor(HashMap.class), Map.class);
            Reference uiService = new Reference((Object)((TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[126].callConstructor(TestConsoleUIService.class), TestConsoleUIService.class))));
            callSiteArray[127].call((Object)scopedObjects, callSiteArray[128].call(callSiteArray[129].callGetProperty(Scope.Attr.class)), (Object)((TestConsoleUIService)((Object)uiService.get())));
            Object scopeId = callSiteArray[130].call(Scope.class, null, (Object)scopedObjects);
            Reference liquibase = new Reference((Object)((Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[131].callConstructor(Liquibase.class, (Object)"com/example/changelog.mock", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class)));
            Reference connection = new Reference(null);
            Reference messages = new Reference(null);
            Reference changeLogId = new Reference(callSiteArray[132].call(callSiteArray[133].call(UUID.class)));
            public class __spock_feature_0_5_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference liquibase;
                private /* synthetic */ Reference changeLogId;
                private /* synthetic */ Reference connection;
                private /* synthetic */ Reference messages;
                private /* synthetic */ Reference uiService;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __spock_feature_0_5_closure3(Object _outerInstance, Object _thisObject, Reference liquibase, Reference changeLogId, Reference connection, Reference messages, Reference uiService) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.liquibase = reference5 = liquibase;
                    this.changeLogId = reference4 = changeLogId;
                    this.connection = reference3 = connection;
                    this.messages = reference2 = messages;
                    this.uiService = reference = uiService;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    DatabaseChangeLog changeLog = (DatabaseChangeLog)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.liquibase.get()), DatabaseChangeLog.class);
                    callSiteArray[1].call((Object)changeLog, this.changeLogId.get());
                    Object object = callSiteArray[2].call(this.liquibase.get(), (Object)changeLog);
                    this.connection.set((Object)((Connection)ScriptBytecodeAdapter.castToType((Object)object, Connection.class)));
                    Object object2 = callSiteArray[3].call(this.uiService.get());
                    this.messages.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object2, List.class)));
                    return object2;
                }

                public Liquibase getLiquibase() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return (Liquibase)ScriptBytecodeAdapter.castToType((Object)this.liquibase.get(), Liquibase.class);
                }

                public Object getChangeLogId() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return this.changeLogId.get();
                }

                public Connection getConnection() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return (Connection)ScriptBytecodeAdapter.castToType((Object)this.connection.get(), Connection.class);
                }

                public List getMessages() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.messages.get(), List.class);
                }

                public TestConsoleUIService getUiService() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return (TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)this.uiService.get(), TestConsoleUIService.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = __spock_feature_0_5_closure3.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __spock_feature_0_5_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getDatabaseChangeLog";
                    stringArray[1] = "setChangeLogId";
                    stringArray[2] = "getConnection";
                    stringArray[3] = "getMessages";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    __spock_feature_0_5_closure3.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(__spock_feature_0_5_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __spock_feature_0_5_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[134].call(Scope.class, callSiteArray[135].call(callSiteArray[136].callGetProperty(HubConfiguration.class)), null, (Object)new __spock_feature_0_5_closure3((Object)this, (Object)this, liquibase, changeLogId, connection, messages, uiService));
            callSiteArray[137].call(Scope.class, scopeId);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"connection == null", (int)281, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)ScriptBytecodeAdapter.compareEqual((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)((Connection)connection.get())), (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), null))));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"connection == null", (int)281, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"messages.isEmpty()", (int)282, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)((List)messages.get())), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"isEmpty")), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"messages.isEmpty()", (int)282, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[138].call(callSiteArray[139].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=285, name="getConnection does not return warning message if API key exists but the changelog is not registered", ordinal=6, blocks={@BlockMetadata(kind=BlockKind.SETUP, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_6() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[140].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[141].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            Map scopedObjects = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[142].callConstructor(HashMap.class), Map.class);
            Reference uiService = new Reference((Object)((TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callConstructor(TestConsoleUIService.class), TestConsoleUIService.class))));
            callSiteArray[144].call((Object)scopedObjects, callSiteArray[145].call(callSiteArray[146].callGetProperty(Scope.Attr.class)), (Object)((TestConsoleUIService)((Object)uiService.get())));
            Object scopeId = callSiteArray[147].call(Scope.class, null, (Object)scopedObjects);
            Reference messages = new Reference(null);
            Reference liquibase = new Reference((Object)((Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callConstructor(Liquibase.class, (Object)"com/example/changelog.mock", (Object)this.mockResourceAccessor, (Object)this.mockDatabase), Liquibase.class)));
            Reference connection = new Reference(null);
            Object message = null;
            public class __spock_feature_0_6_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference liquibase;
                private /* synthetic */ Reference connection;
                private /* synthetic */ Reference messages;
                private /* synthetic */ Reference uiService;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public __spock_feature_0_6_closure4(Object _outerInstance, Object _thisObject, Reference liquibase, Reference connection, Reference messages, Reference uiService) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.liquibase = reference4 = liquibase;
                    this.connection = reference3 = connection;
                    this.messages = reference2 = messages;
                    this.uiService = reference = uiService;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    DatabaseChangeLog changeLog = (DatabaseChangeLog)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(this.liquibase.get()), DatabaseChangeLog.class);
                    callSiteArray[1].call((Object)changeLog, null);
                    Object object = callSiteArray[2].call(this.liquibase.get(), (Object)changeLog);
                    this.connection.set((Object)((Connection)ScriptBytecodeAdapter.castToType((Object)object, Connection.class)));
                    Object object2 = callSiteArray[3].call(this.uiService.get());
                    this.messages.set((Object)((List)ScriptBytecodeAdapter.castToType((Object)object2, List.class)));
                    return object2;
                }

                public Liquibase getLiquibase() {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    return (Liquibase)ScriptBytecodeAdapter.castToType((Object)this.liquibase.get(), Liquibase.class);
                }

                public Connection getConnection() {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    return (Connection)ScriptBytecodeAdapter.castToType((Object)this.connection.get(), Connection.class);
                }

                public List getMessages() {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    return (List)ScriptBytecodeAdapter.castToType((Object)this.messages.get(), List.class);
                }

                public TestConsoleUIService getUiService() {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    return (TestConsoleUIService)((Object)ScriptBytecodeAdapter.castToType((Object)this.uiService.get(), TestConsoleUIService.class));
                }

                public Object doCall() {
                    CallSite[] callSiteArray = __spock_feature_0_6_closure4.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __spock_feature_0_6_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "getDatabaseChangeLog";
                    stringArray[1] = "setChangeLogId";
                    stringArray[2] = "getConnection";
                    stringArray[3] = "getMessages";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    __spock_feature_0_6_closure4.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(__spock_feature_0_6_closure4.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = __spock_feature_0_6_closure4.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[149].call(Scope.class, callSiteArray[150].call(callSiteArray[151].callGetProperty(HubConfiguration.class)), (Object)"API_KEY", (Object)new __spock_feature_0_6_closure4((Object)this, (Object)this, liquibase, connection, messages, uiService));
            callSiteArray[152].call(Scope.class, scopeId);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"connection == null", (int)306, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)ScriptBytecodeAdapter.compareEqual((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)((Connection)connection.get())), (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), null))));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"connection == null", (int)306, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"messages.isEmpty()", (int)307, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)((List)messages.get())), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"isEmpty")), (Object[])new Object[0], (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"messages.isEmpty()", (int)307, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[153].call(callSiteArray[154].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=371, name="syncChangeLogForUnmanagedDatabase", ordinal=7, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_7() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[156].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[157].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].callCurrent((GroovyObject)this, (Object)this.h2Connection), Liquibase.class);
            callSiteArray[159].callStatic(Assert.class, callSiteArray[160].callCurrent((GroovyObject)this, (Object)liquibase));
            callSiteArray[161].call((Object)liquibase, (Object)"");
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"hasDatabaseChangeLogTable(liquibase)", (int)381, (int)16, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"hasDatabaseChangeLogTable(liquibase)", (int)381, (int)16, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTags(liquibase, \"1.0\", \"1.1\", \"2.0\")", (int)382, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"1.1"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"2.0")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(7).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)6);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTags(liquibase, \"1.0\", \"1.1\", \"2.0\")", (int)382, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[162].call(callSiteArray[163].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=385, name="syncChangeLogToTagForUnmanagedDatabase", ordinal=8, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_8() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[166].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[167].callCurrent((GroovyObject)this, (Object)this.h2Connection), Liquibase.class);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!hasDatabaseChangeLogTable(liquibase)", (int)392, (int)16, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}))) ? 1 : 0)));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!hasDatabaseChangeLogTable(liquibase)", (int)392, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[168].call((Object)liquibase, (Object)"1.1", (Object)"");
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"hasDatabaseChangeLogTable(liquibase)", (int)398, (int)16, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"hasDatabaseChangeLogTable(liquibase)", (int)398, (int)16, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTags(liquibase, \"1.0\", \"1.1\")", (int)399, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"1.1")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(6).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)5);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTags(liquibase, \"1.0\", \"1.1\")", (int)399, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[169].call(callSiteArray[170].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=402, name="syncChangeLogForManagedDatabase", ordinal=9, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_9() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[171].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[172].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[173].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[174].callCurrent((GroovyObject)this, (Object)this.h2Connection, (Object)"1.0"), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"hasDatabaseChangeLogTable(liquibase)", (int)409, (int)16, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"hasDatabaseChangeLogTable(liquibase)", (int)409, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[175].call((Object)liquibase, (Object)"");
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTags(liquibase, \"1.0\", \"1.1\", \"2.0\")", (int)415, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"1.1"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)"2.0")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(7).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)6);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTags(liquibase, \"1.0\", \"1.1\", \"2.0\")", (int)415, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[176].call(callSiteArray[177].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=418, name="syncChangeLogToTagForManagedDatabase", ordinal=10, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_10() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[178].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[179].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[180].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[181].callCurrent((GroovyObject)this, (Object)this.h2Connection, (Object)"1.0"), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"hasDatabaseChangeLogTable(liquibase)", (int)424, (int)16, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"hasDatabaseChangeLogTable(liquibase)", (int)424, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[182].call((Object)liquibase, (Object)"1.1", (Object)"");
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTags(liquibase, \"1.0\", \"1.1\")", (int)430, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)"1.1")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(6).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)5);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTags(liquibase, \"1.0\", \"1.1\")", (int)430, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[183].call(callSiteArray[184].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=433, name="syncChangeLogSqlForUnmanagedDatabase", ordinal=11, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_11() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[185].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[186].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[187].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            StringWriter writer = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[188].callConstructor(StringWriter.class), StringWriter.class);
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[189].callCurrent((GroovyObject)this, (Object)this.h2Connection), Liquibase.class);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!hasDatabaseChangeLogTable(liquibase)", (int)441, (int)16, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}))) ? 1 : 0)));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!hasDatabaseChangeLogTable(liquibase)", (int)441, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[190].call((Object)liquibase, (Object)"", (Object)writer);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!hasDatabaseChangeLogTable(liquibase)", (int)447, (int)16, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}))) ? 1 : 0)));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!hasDatabaseChangeLogTable(liquibase)", (int)447, (int)16, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.0\", \"1.1\", \"2.0\")", (int)448, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertSqlOutputAppliesTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)writer), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), (Object)"1.1"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), (Object)"2.0")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(10).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)9);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.0\", \"1.1\", \"2.0\")", (int)448, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[191].call(callSiteArray[192].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=451, name="syncChangeLogToTagSqlForUnmanagedDatabase", ordinal=12, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_12() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[193].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[194].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[195].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            StringWriter writer = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[196].callConstructor(StringWriter.class), StringWriter.class);
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[197].callCurrent((GroovyObject)this, (Object)this.h2Connection), Liquibase.class);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!hasDatabaseChangeLogTable(liquibase)", (int)459, (int)16, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}))) ? 1 : 0)));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!hasDatabaseChangeLogTable(liquibase)", (int)459, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[198].call((Object)liquibase, (Object)"1.1", (Object)"", (Object)writer);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!hasDatabaseChangeLogTable(liquibase)", (int)465, (int)9, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}))) ? 1 : 0)));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!hasDatabaseChangeLogTable(liquibase)", (int)465, (int)9, null, (Throwable)throwable);
            }
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.0\", \"1.1\")", (int)466, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertSqlOutputAppliesTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)writer), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), (Object)"1.0"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), (Object)"1.1")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.0\", \"1.1\")", (int)466, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[199].call(callSiteArray[200].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=469, name="syncChangeLogSqlForManagedDatabase", ordinal=13, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_13() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[201].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[202].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[203].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            StringWriter writer = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].callConstructor(StringWriter.class), StringWriter.class);
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[205].callCurrent((GroovyObject)this, (Object)this.h2Connection, (Object)"1.0"), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"hasDatabaseChangeLogTable(liquibase)", (int)477, (int)16, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase)}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(4).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)3);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"hasDatabaseChangeLogTable(liquibase)", (int)477, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[206].call((Object)liquibase, (Object)"", (Object)writer);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.1\", \"2.0\")", (int)483, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertSqlOutputAppliesTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)writer), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), (Object)"1.1"), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), (Object)"2.0")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.1\", \"2.0\")", (int)483, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[207].call(callSiteArray[208].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=486, name="syncChangeLogToTagSqlForManagedDatabase", ordinal=14, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={}), @BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_14() throws Exception {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[209].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[210].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[211].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            StringWriter writer = (StringWriter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[212].callConstructor(StringWriter.class), StringWriter.class);
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[213].callCurrent((GroovyObject)this, (Object)this.h2Connection, (Object)"1.0"), Liquibase.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTrue(hasDatabaseChangeLogTable(liquibase))", (int)494, (int)9, null, Assert.class, (String)"assertTrue", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"hasDatabaseChangeLogTable")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)liquibase)}))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(7).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)6);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTrue(hasDatabaseChangeLogTable(liquibase))", (int)494, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[214].call((Object)liquibase, (Object)"1.1", (Object)"", (Object)writer);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.1\")", (int)500, (int)9, null, (Object)((Object)this), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)"assertSqlOutputAppliesTags")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)writer), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"toString")))), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), (Object)"1.1")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(8).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)7);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertSqlOutputAppliesTags(writer.toString(), \"1.1\")", (int)500, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[215].call(callSiteArray[216].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=503, name="validateContextLabelEntryHasNotBeenAddedPreviously", ordinal=15, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_15() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[217].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[218].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[219].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[220].callCurrent((GroovyObject)this, (Object)this.h2Connection, (Object)"1.0"), Liquibase.class);
            Contexts context = (Contexts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[221].callConstructor(Contexts.class, (Object)"testContext"), Contexts.class);
            LabelExpression label = (LabelExpression)ScriptBytecodeAdapter.castToType((Object)callSiteArray[222].callConstructor(LabelExpression.class, (Object)"testLabel"), LabelExpression.class);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertFalse(liquibase.isUpToDateFastCheck(context, label))", (int)511, (int)9, null, Assert.class, (String)"assertFalse", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethodN(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"isUpToDateFastCheck")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)context), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)label)}))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertFalse(liquibase.isUpToDateFastCheck(context, label))", (int)511, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[223].call(callSiteArray[224].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=515, name="validateContextLabelEntryHasBeenAddedPreviously", ordinal=16, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_16() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[225].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[226].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[227].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[228].callConstructor(Liquibase.class, (Object)"liquibase/test-changelog-fast-check.xml", callSiteArray[229].callConstructor(ClassLoaderResourceAccessor.class), (Object)this.h2Connection), Liquibase.class);
            Contexts context = (Contexts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[230].callConstructor(Contexts.class, (Object)"testContext"), Contexts.class);
            LabelExpression label = (LabelExpression)ScriptBytecodeAdapter.castToType((Object)callSiteArray[231].callConstructor(LabelExpression.class, (Object)"testLabel"), LabelExpression.class);
            callSiteArray[232].call((Object)liquibase);
            try {
                SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"assertTrue(liquibase.isUpToDateFastCheck(context, label))", (int)525, (int)9, null, Assert.class, (String)"assertTrue", (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(6).intValue()), ScriptBytecodeAdapter.invokeMethodN(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)liquibase), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"isUpToDateFastCheck")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), (Object)context), $spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)label)}))}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(9).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE), (int)8);
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"assertTrue(liquibase.isUpToDateFastCheck(context, label))", (int)525, (int)9, null, (Throwable)throwable);
            }
            callSiteArray[233].call(callSiteArray[234].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    @FeatureMetadata(line=529, name="validate checksums from ran changesets have all been reset", ordinal=17, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_17() {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[235].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[236].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[237].callCurrent((GroovyObject)this);
                this.h2Connection = (JdbcConnection)ScriptBytecodeAdapter.castToType((Object)object, JdbcConnection.class);
            } else {
                JdbcConnection jdbcConnection;
                this.h2Connection = jdbcConnection = this.getInMemoryH2DatabaseConnection();
            }
            Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[238].callConstructor(Liquibase.class, (Object)"liquibase/test-changelog-fast-check.xml", callSiteArray[239].callConstructor(ClassLoaderResourceAccessor.class), (Object)this.h2Connection), Liquibase.class);
            callSiteArray[240].call((Object)liquibase);
            callSiteArray[241].call((Object)liquibase);
            List ranChangeSets = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[242].call(callSiteArray[243].call(callSiteArray[244].call(ChangeLogHistoryServiceFactory.class), callSiteArray[245].call((Object)liquibase))), List.class);
            try {
                SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"ranChangeSets.get(0).getLastCheckSum() == null", (int)539, (int)16, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(9).intValue()), (Object)ScriptBytecodeAdapter.compareEqual((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(7).intValue()), ScriptBytecodeAdapter.invokeMethod0(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), ScriptBytecodeAdapter.invokeMethodN(LiquibaseTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)ranChangeSets), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"get")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)0)})), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(5).intValue()), (Object)"getLastCheckSum")))), (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(8).intValue()), null))));
            }
            catch (Throwable throwable) {
                SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"ranChangeSets.get(0).getLastCheckSum() == null", (int)539, (int)16, null, (Throwable)throwable);
            }
            callSiteArray[246].call(callSiteArray[247].call((Object)this.getSpecificationContext()));
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = LiquibaseTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(LiquibaseTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LiquibaseTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public JdbcConnection getH2Connection() {
        return this.h2Connection;
    }

    public void setH2Connection(JdbcConnection jdbcConnection) {
        this.h2Connection = jdbcConnection;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "setInstance";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "enter";
        stringArray[4] = "plus";
        stringArray[5] = "name";
        stringArray[6] = "getService";
        stringArray[7] = "getSingleton";
        stringArray[8] = "currentScope";
        stringArray[9] = "reset";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "toString";
        stringArray[12] = "randomUUID";
        stringArray[13] = "addChangeSet";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "register";
        stringArray[16] = "getInstance";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "reset";
        stringArray[19] = "reset";
        stringArray[20] = "reset";
        stringArray[21] = "exit";
        stringArray[22] = "reset";
        stringArray[23] = "close";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "getConnection";
        stringArray[26] = "format";
        stringArray[27] = "toString";
        stringArray[28] = "randomUUID";
        stringArray[29] = "prepareStatement";
        stringArray[30] = "getUnderlyingConnection";
        stringArray[31] = "execute";
        stringArray[32] = "close";
        stringArray[33] = "close";
        stringArray[34] = "<$constructor$>";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "<$constructor$>";
        stringArray[37] = "<$constructor$>";
        stringArray[38] = "update";
        stringArray[39] = "hasDatabaseChangeLogTable";
        stringArray[40] = "getInstance";
        stringArray[41] = "database";
        stringArray[42] = "iterator";
        stringArray[43] = "getRanChangeSetList";
        stringArray[44] = "database";
        stringArray[45] = "getTag";
        stringArray[46] = "add";
        stringArray[47] = "getTag";
        stringArray[48] = "assertEquals";
        stringArray[49] = "asList";
        stringArray[50] = "iterator";
        stringArray[51] = "add";
        stringArray[52] = "compile";
        stringArray[53] = "format";
        stringArray[54] = "<$constructor$>";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "readLine";
        stringArray[57] = "size";
        stringArray[58] = "matcher";
        stringArray[59] = "get";
        stringArray[60] = "matches";
        stringArray[61] = "next";
        stringArray[62] = "assertTrue";
        stringArray[63] = "size";
        stringArray[64] = "assertTrue";
        stringArray[65] = "size";
        stringArray[66] = "close";
        stringArray[67] = "close";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "<$constructor$>";
        stringArray[70] = "<$constructor$>";
        stringArray[71] = "leaveScope";
        stringArray[72] = "getMockController";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "<$constructor$>";
        stringArray[75] = "<$constructor$>";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "<$constructor$>";
        stringArray[78] = "leaveScope";
        stringArray[79] = "getMockController";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "<$constructor$>";
        stringArray[82] = "<$constructor$>";
        stringArray[83] = "leaveScope";
        stringArray[84] = "getMockController";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "<$constructor$>";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "<$constructor$>";
        stringArray[89] = "put";
        stringArray[90] = "name";
        stringArray[91] = "ui";
        stringArray[92] = "enter";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "child";
        stringArray[95] = "getKey";
        stringArray[96] = "LIQUIBASE_HUB_API_KEY";
        stringArray[97] = "exit";
        stringArray[98] = "sentObjects";
        stringArray[99] = "randomUUID";
        stringArray[100] = "randomUUID";
        stringArray[101] = "operationCreateDate";
        stringArray[102] = "leaveScope";
        stringArray[103] = "getMockController";
        stringArray[104] = "<$constructor$>";
        stringArray[105] = "<$constructor$>";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "<$constructor$>";
        stringArray[108] = "put";
        stringArray[109] = "name";
        stringArray[110] = "ui";
        stringArray[111] = "enter";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "child";
        stringArray[114] = "getKey";
        stringArray[115] = "LIQUIBASE_HUB_API_KEY";
        stringArray[116] = "exit";
        stringArray[117] = "sentObjects";
        stringArray[118] = "randomUUID";
        stringArray[119] = "randomUUID";
        stringArray[120] = "operationCreateDate";
        stringArray[121] = "leaveScope";
        stringArray[122] = "getMockController";
        stringArray[123] = "<$constructor$>";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "<$constructor$>";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "put";
        stringArray[128] = "name";
        stringArray[129] = "ui";
        stringArray[130] = "enter";
        stringArray[131] = "<$constructor$>";
        stringArray[132] = "toString";
        stringArray[133] = "randomUUID";
        stringArray[134] = "child";
        stringArray[135] = "getKey";
        stringArray[136] = "LIQUIBASE_HUB_API_KEY";
        stringArray[137] = "exit";
        stringArray[138] = "leaveScope";
        stringArray[139] = "getMockController";
        stringArray[140] = "<$constructor$>";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "<$constructor$>";
        stringArray[143] = "<$constructor$>";
        stringArray[144] = "put";
        stringArray[145] = "name";
        stringArray[146] = "ui";
        stringArray[147] = "enter";
        stringArray[148] = "<$constructor$>";
        stringArray[149] = "child";
        stringArray[150] = "getKey";
        stringArray[151] = "LIQUIBASE_HUB_API_KEY";
        stringArray[152] = "exit";
        stringArray[153] = "leaveScope";
        stringArray[154] = "getMockController";
        stringArray[155] = "<$constructor$>";
        stringArray[156] = "<$constructor$>";
        stringArray[157] = "getInMemoryH2DatabaseConnection";
        stringArray[158] = "createUnmanagedDatabase";
        stringArray[159] = "assertFalse";
        stringArray[160] = "hasDatabaseChangeLogTable";
        stringArray[161] = "changeLogSync";
        stringArray[162] = "leaveScope";
        stringArray[163] = "getMockController";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "getInMemoryH2DatabaseConnection";
        stringArray[167] = "createUnmanagedDatabase";
        stringArray[168] = "changeLogSync";
        stringArray[169] = "leaveScope";
        stringArray[170] = "getMockController";
        stringArray[171] = "<$constructor$>";
        stringArray[172] = "<$constructor$>";
        stringArray[173] = "getInMemoryH2DatabaseConnection";
        stringArray[174] = "createDatabaseAtTag";
        stringArray[175] = "changeLogSync";
        stringArray[176] = "leaveScope";
        stringArray[177] = "getMockController";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "<$constructor$>";
        stringArray[180] = "getInMemoryH2DatabaseConnection";
        stringArray[181] = "createDatabaseAtTag";
        stringArray[182] = "changeLogSync";
        stringArray[183] = "leaveScope";
        stringArray[184] = "getMockController";
        stringArray[185] = "<$constructor$>";
        stringArray[186] = "<$constructor$>";
        stringArray[187] = "getInMemoryH2DatabaseConnection";
        stringArray[188] = "<$constructor$>";
        stringArray[189] = "createUnmanagedDatabase";
        stringArray[190] = "changeLogSync";
        stringArray[191] = "leaveScope";
        stringArray[192] = "getMockController";
        stringArray[193] = "<$constructor$>";
        stringArray[194] = "<$constructor$>";
        stringArray[195] = "getInMemoryH2DatabaseConnection";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "createUnmanagedDatabase";
        stringArray[198] = "changeLogSync";
        stringArray[199] = "leaveScope";
        stringArray[200] = "getMockController";
        stringArray[201] = "<$constructor$>";
        stringArray[202] = "<$constructor$>";
        stringArray[203] = "getInMemoryH2DatabaseConnection";
        stringArray[204] = "<$constructor$>";
        stringArray[205] = "createDatabaseAtTag";
        stringArray[206] = "changeLogSync";
        stringArray[207] = "leaveScope";
        stringArray[208] = "getMockController";
        stringArray[209] = "<$constructor$>";
        stringArray[210] = "<$constructor$>";
        stringArray[211] = "getInMemoryH2DatabaseConnection";
        stringArray[212] = "<$constructor$>";
        stringArray[213] = "createDatabaseAtTag";
        stringArray[214] = "changeLogSync";
        stringArray[215] = "leaveScope";
        stringArray[216] = "getMockController";
        stringArray[217] = "<$constructor$>";
        stringArray[218] = "<$constructor$>";
        stringArray[219] = "getInMemoryH2DatabaseConnection";
        stringArray[220] = "createDatabaseAtTag";
        stringArray[221] = "<$constructor$>";
        stringArray[222] = "<$constructor$>";
        stringArray[223] = "leaveScope";
        stringArray[224] = "getMockController";
        stringArray[225] = "<$constructor$>";
        stringArray[226] = "<$constructor$>";
        stringArray[227] = "getInMemoryH2DatabaseConnection";
        stringArray[228] = "<$constructor$>";
        stringArray[229] = "<$constructor$>";
        stringArray[230] = "<$constructor$>";
        stringArray[231] = "<$constructor$>";
        stringArray[232] = "update";
        stringArray[233] = "leaveScope";
        stringArray[234] = "getMockController";
        stringArray[235] = "<$constructor$>";
        stringArray[236] = "<$constructor$>";
        stringArray[237] = "getInMemoryH2DatabaseConnection";
        stringArray[238] = "<$constructor$>";
        stringArray[239] = "<$constructor$>";
        stringArray[240] = "update";
        stringArray[241] = "clearCheckSums";
        stringArray[242] = "getRanChangeSets";
        stringArray[243] = "getChangeLogService";
        stringArray[244] = "getInstance";
        stringArray[245] = "getDatabase";
        stringArray[246] = "leaveScope";
        stringArray[247] = "getMockController";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[248];
        LiquibaseTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LiquibaseTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LiquibaseTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class TestConsoleUIService
    extends ConsoleUIService
    implements GroovyObject {
        private List<String> messages;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public TestConsoleUIService() {
            MetaClass metaClass;
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            Object object = callSiteArray[0].callConstructor(ArrayList.class);
            this.messages = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void sendMessage(String message) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            callSiteArray[1].call(this.messages, (Object)message);
        }

        public List<String> getMessages() {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            return this.messages;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(TestConsoleUIService.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(TestConsoleUIService.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(TestConsoleUIService.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = TestConsoleUIService.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(TestConsoleUIService.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != TestConsoleUIService.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public /* synthetic */ void super$3$sendMessage(String string) {
            super.sendMessage(string);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "add";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[2];
            TestConsoleUIService.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(TestConsoleUIService.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = TestConsoleUIService.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class LiquibaseDelegate
    extends Liquibase
    implements GroovyObject {
        protected final Map<String, Object> objectsToVerify;
        protected Object objectToVerify;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LiquibaseDelegate() throws LiquibaseException {
            MetaClass metaClass;
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            Object[] objectArray = new Object[]{"com/example/changelog.mock", callSiteArray[0].callConstructor(MockResourceAccessor.class), callSiteArray[1].callGroovyObjectGetProperty((Object)this)};
            LiquibaseDelegate liquibaseDelegate = this;
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Liquibase.class)) {
                case -1619983928: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (ResourceAccessor)ScriptBytecodeAdapter.castToType((Object)objectArray[1], ResourceAccessor.class), (DatabaseConnection)ScriptBytecodeAdapter.castToType((Object)objectArray[2], DatabaseConnection.class));
                    break;
                }
                case 153417323: {
                    Object[] objectArray2 = objectArray;
                    super((DatabaseChangeLog)ScriptBytecodeAdapter.castToType((Object)objectArray[0], DatabaseChangeLog.class), (ResourceAccessor)ScriptBytecodeAdapter.castToType((Object)objectArray[1], ResourceAccessor.class), (Database)ScriptBytecodeAdapter.castToType((Object)objectArray[2], Database.class));
                    break;
                }
                case 2006768390: {
                    Object[] objectArray2 = objectArray;
                    super(ShortTypeHandling.castToString((Object)objectArray[0]), (ResourceAccessor)ScriptBytecodeAdapter.castToType((Object)objectArray[1], ResourceAccessor.class), (Database)ScriptBytecodeAdapter.castToType((Object)objectArray[2], Database.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            Object object = callSiteArray[2].callConstructor(HashMap.class);
            this.objectsToVerify = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void reset() {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            Object var2_2 = null;
            this.objectToVerify = var2_2;
            callSiteArray[3].call(this.objectsToVerify);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LiquibaseDelegate.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(LiquibaseDelegate.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LiquibaseDelegate.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = LiquibaseDelegate.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(LiquibaseDelegate.class, LiquibaseTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != LiquibaseDelegate.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "mockDatabase";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "clear";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[4];
            LiquibaseDelegate.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(LiquibaseDelegate.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LiquibaseDelegate.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

