/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.ThreadLocalScopeManager;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.Assert;
import org.spockframework.runtime.ErrorCollector;
import org.spockframework.runtime.SpockRuntime;
import org.spockframework.runtime.ValueRecorder;
import org.spockframework.runtime.model.BlockKind;
import org.spockframework.runtime.model.BlockMetadata;
import org.spockframework.runtime.model.FeatureMetadata;
import org.spockframework.runtime.model.FieldMetadata;
import org.spockframework.runtime.model.SpecMetadata;
import spock.lang.Specification;

@SpecMetadata(filename="ThreadLocalScopeManagerTest.groovy", line=15)
public class ThreadLocalScopeManagerTest
extends Specification
implements GroovyObject {
    private static final String DATABASE_NAME_PREFIX = "DB_MT_";
    @FieldMetadata(line=18, name="executor", ordinal=0, initializer=true)
    private final ExecutorService executor;
    @FieldMetadata(line=19, name="liveConnections", ordinal=1, initializer=true)
    private final Map<String, MemoryDatabase> liveConnections;
    @FieldMetadata(line=21, name="originalScopeManager", ordinal=2, initializer=false)
    private ScopeManager originalScopeManager;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ThreadLocalScopeManagerTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private Object setup() {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        callSiteArray[0].call(Scope.class);
        Object object = callSiteArray[1].callGetProperty(Scope.class);
        this.originalScopeManager = (ScopeManager)ScriptBytecodeAdapter.castToType((Object)object, ScopeManager.class);
        return callSiteArray[2].call(Scope.class, callSiteArray[3].callConstructor(ThreadLocalScopeManager.class));
    }

    private Object cleanup() {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[4].callCurrent((GroovyObject)this);
        } else {
            this.teardownLiveConnections();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[5].callCurrent((GroovyObject)this);
        } else {
            this.shutdownExecutorService();
        }
        return callSiteArray[6].call(Scope.class, (Object)this.originalScopeManager);
    }

    private void maintainDatabase(String dbName) {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        ErrorCollector $spock_errorCollector = (ErrorCollector)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callConstructor(ErrorCollector.class, (Object)false), ErrorCollector.class);
        ValueRecorder $spock_valueRecorder = (ValueRecorder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[8].callConstructor(ValueRecorder.class), ValueRecorder.class);
        try {
            MemoryDatabase db = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[9].callCurrent((GroovyObject)this, (Object)dbName);
                db = (MemoryDatabase)ScriptBytecodeAdapter.castToType((Object)object, MemoryDatabase.class);
            } else {
                MemoryDatabase memoryDatabase;
                db = memoryDatabase = this.getDatabase(dbName);
            }
            Connection con = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[10].call((Object)db), Connection.class);
            try {
                Liquibase liquibase = (Liquibase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].callConstructor(Liquibase.class, (Object)"com/example/changelog.xml", callSiteArray[12].callConstructor(ClassLoaderResourceAccessor.class), callSiteArray[13].callConstructor(JdbcConnection.class, (Object)con)), Liquibase.class);
                List pending = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[14].call((Object)liquibase, callSiteArray[15].callConstructor(Contexts.class), callSiteArray[16].callConstructor(LabelExpression.class)), List.class);
                try {
                    SpockRuntime.verifyCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"!pending.isEmpty()", (int)83, (int)20, (Object)"Expected pending database changesets", (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(4).intValue()), (Object)(!DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(3).intValue()), ScriptBytecodeAdapter.invokeMethod0(ThreadLocalScopeManagerTest.class, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)pending), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"isEmpty"))))) ? 1 : 0)));
                }
                catch (Throwable throwable) {
                    SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"!pending.isEmpty()", (int)83, (int)20, (Object)"Expected pending database changesets", (Throwable)throwable);
                }
                callSiteArray[17].call((Object)liquibase, callSiteArray[18].callConstructor(Contexts.class), callSiteArray[19].callConstructor(LabelExpression.class));
                List tableNames = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].call((Object)db), List.class);
                try {
                    SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"tableNames.contains(\"table1\")", (int)89, (int)20, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)tableNames), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"contains")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"table1")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(5).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)4);
                }
                catch (Throwable throwable) {
                    SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"tableNames.contains(\"table1\")", (int)89, (int)20, null, (Throwable)throwable);
                }
                try {
                    SpockRuntime.verifyMethodCondition((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder.reset(), (String)"tableNames.contains(\"table2\")", (int)90, (int)20, null, (Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(0).intValue()), (Object)tableNames), (String)ShortTypeHandling.castToString((Object)$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(1).intValue()), (Object)"contains")), (Object[])new Object[]{$spock_valueRecorder.record($spock_valueRecorder.startRecordingValue(Integer.valueOf(2).intValue()), (Object)"table2")}, (boolean)DefaultTypeTransformation.booleanUnbox((Object)$spock_valueRecorder.realizeNas(Integer.valueOf(5).intValue(), (Object)Boolean.FALSE)), (boolean)DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE), (int)4);
                }
                catch (Throwable throwable) {
                    SpockRuntime.conditionFailedWithException((ErrorCollector)$spock_errorCollector, (ValueRecorder)$spock_valueRecorder, (String)"tableNames.contains(\"table2\")", (int)90, (int)20, null, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[21].callConstructor(IllegalStateException.class, callSiteArray[22].call((Object)e), (Object)e);
            }
            catch (LiquibaseException e) {
                throw (Throwable)callSiteArray[23].callConstructor(IllegalStateException.class, callSiteArray[24].call((Object)e), (Object)e);
            }
        }
        finally {
            $spock_errorCollector.validateCollectedErrors();
        }
    }

    private MemoryDatabase getDatabase(String dbName) {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        MemoryDatabase db = (MemoryDatabase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call(this.liveConnections, (Object)dbName), MemoryDatabase.class);
        callSiteArray[26].callStatic(Assert.class, callSiteArray[27].call((Object)"Memory database not created for ", (Object)dbName), (Object)db);
        return db;
    }

    private void shutdownExecutorService() {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        callSiteArray[28].call((Object)this.executor);
        try {
            callSiteArray[29].call((Object)this.executor, (Object)5, callSiteArray[30].callGetProperty(TimeUnit.class));
        }
        catch (InterruptedException e) {
            callSiteArray[31].call(callSiteArray[32].call(Thread.class));
            throw (Throwable)callSiteArray[33].callConstructor(IllegalStateException.class, (Object)"Failed to terminate all threads in a timely fashion");
        }
    }

    private void teardownLiveConnections() {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        MemoryDatabase db = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call(callSiteArray[35].call(this.liveConnections)), Iterator.class);
        while (iterator.hasNext()) {
            db = (MemoryDatabase)ScriptBytecodeAdapter.castToType(iterator.next(), MemoryDatabase.class);
            callSiteArray[36].call((Object)db);
        }
    }

    private /* synthetic */ Object $spock_initializeFields() {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        Object object = callSiteArray[37].call(Executors.class);
        this.executor = (ExecutorService)ScriptBytecodeAdapter.castToType((Object)object, ExecutorService.class);
        Object object2 = callSiteArray[38].callConstructor(ConcurrentHashMap.class);
        this.liveConnections = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
        return object2;
    }

    @FeatureMetadata(line=37, name="maintain databases in parallel", ordinal=0, blocks={@BlockMetadata(kind=BlockKind.WHEN, texts={}), @BlockMetadata(kind=BlockKind.THEN, texts={})}, parameterNames={})
    public void $spock_feature_0_0() {
        public class __spock_feature_0_0_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference threadAligner;
            private /* synthetic */ Reference dbName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public __spock_feature_0_0_closure1(Object _outerInstance, Object _thisObject, Reference threadAligner, Reference dbName) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = __spock_feature_0_0_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.threadAligner = reference2 = threadAligner;
                this.dbName = reference = dbName;
            }

            public Object doCall() {
                CallSite[] callSiteArray = __spock_feature_0_0_closure1.$getCallSiteArray();
                callSiteArray[0].call(this.threadAligner.get());
                return callSiteArray[1].callCurrent((GroovyObject)this, this.dbName.get());
            }

            public ThreadAligner getThreadAligner() {
                CallSite[] callSiteArray = __spock_feature_0_0_closure1.$getCallSiteArray();
                return (ThreadAligner)ScriptBytecodeAdapter.castToType((Object)this.threadAligner.get(), ThreadAligner.class);
            }

            public String getDbName() {
                CallSite[] callSiteArray = __spock_feature_0_0_closure1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.dbName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __spock_feature_0_0_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "awaitAllReady";
                stringArray[1] = "maintainDatabase";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                __spock_feature_0_0_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(__spock_feature_0_0_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = __spock_feature_0_0_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        int threadCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[39].call(Math.class, (Object)16, callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(Runtime.class)), (Object)2)));
        callSiteArray[43].call(callSiteArray[44].callGetProperty(System.class), callSiteArray[45].call(callSiteArray[46].call((Object)"Liquibase threading test will use ", (Object)threadCount), (Object)" threads."));
        List maintainTasks = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[47].callConstructor(ArrayList.class), List.class);
        Reference threadAligner = new Reference((Object)((ThreadAligner)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callConstructor(ThreadAligner.class, (Object)threadCount), ThreadAligner.class)));
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < threadCount) {
                Reference dbName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[49].call((Object)DATABASE_NAME_PREFIX, (Object)i)));
                callSiteArray[50].call(this.liveConnections, (Object)((String)dbName.get()), callSiteArray[51].call(MemoryDatabase.class, (Object)((String)dbName.get())));
                callSiteArray[52].call((Object)maintainTasks, callSiteArray[53].call((Object)this.executor, (Object)new __spock_feature_0_0_closure1((Object)this, (Object)this, threadAligner, dbName)));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[54].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < threadCount) {
                Reference dbName = new Reference((Object)ShortTypeHandling.castToString((Object)callSiteArray[55].call((Object)DATABASE_NAME_PREFIX, (Object)i)));
                callSiteArray[56].call(this.liveConnections, (Object)((String)dbName.get()), callSiteArray[57].call(MemoryDatabase.class, (Object)((String)dbName.get())));
                callSiteArray[58].call((Object)maintainTasks, callSiteArray[59].call((Object)this.executor, (Object)new __spock_feature_0_0_closure1((Object)this, (Object)this, threadAligner, dbName)));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        Object task = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].call((Object)maintainTasks), Iterator.class);
        while (iterator.hasNext()) {
            task = iterator.next();
            callSiteArray[61].call(task, (Object)30, callSiteArray[62].callGetProperty(TimeUnit.class));
        }
        callSiteArray[63].call(callSiteArray[64].call((Object)this.getSpecificationContext()));
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ThreadLocalScopeManagerTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ThreadLocalScopeManagerTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = ThreadLocalScopeManagerTest.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ThreadLocalScopeManagerTest.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ThreadLocalScopeManagerTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getCurrentScope";
        stringArray[1] = "scopeManager";
        stringArray[2] = "setScopeManager";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "teardownLiveConnections";
        stringArray[5] = "shutdownExecutorService";
        stringArray[6] = "setScopeManager";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "getDatabase";
        stringArray[10] = "getConnection";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "listUnrunChangeSets";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "update";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "queryTables";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "getMessage";
        stringArray[23] = "<$constructor$>";
        stringArray[24] = "getMessage";
        stringArray[25] = "get";
        stringArray[26] = "assertNotNull";
        stringArray[27] = "plus";
        stringArray[28] = "shutdownNow";
        stringArray[29] = "awaitTermination";
        stringArray[30] = "SECONDS";
        stringArray[31] = "interrupt";
        stringArray[32] = "currentThread";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "iterator";
        stringArray[35] = "values";
        stringArray[36] = "close";
        stringArray[37] = "newCachedThreadPool";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "min";
        stringArray[40] = "multiply";
        stringArray[41] = "availableProcessors";
        stringArray[42] = "getRuntime";
        stringArray[43] = "println";
        stringArray[44] = "out";
        stringArray[45] = "plus";
        stringArray[46] = "plus";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "plus";
        stringArray[50] = "put";
        stringArray[51] = "create";
        stringArray[52] = "add";
        stringArray[53] = "submit";
        stringArray[54] = "next";
        stringArray[55] = "plus";
        stringArray[56] = "put";
        stringArray[57] = "create";
        stringArray[58] = "add";
        stringArray[59] = "submit";
        stringArray[60] = "iterator";
        stringArray[61] = "get";
        stringArray[62] = "SECONDS";
        stringArray[63] = "leaveScope";
        stringArray[64] = "getMockController";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[65];
        ThreadLocalScopeManagerTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ThreadLocalScopeManagerTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ThreadLocalScopeManagerTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static class ThreadAligner
    implements GroovyObject {
        private final CyclicBarrier barrier;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ThreadAligner(int threads) {
            MetaClass metaClass;
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Object object = callSiteArray[0].callConstructor(CyclicBarrier.class, (Object)threads);
            this.barrier = (CyclicBarrier)ScriptBytecodeAdapter.castToType((Object)object, CyclicBarrier.class);
        }

        public void awaitAllReady() {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            try {
                callSiteArray[1].call((Object)this.barrier);
            }
            catch (InterruptedException e) {
                callSiteArray[2].call(callSiteArray[3].call(Thread.class));
                throw (Throwable)callSiteArray[4].callConstructor(IllegalStateException.class, (Object)e);
            }
            catch (BrokenBarrierException e) {
                throw (Throwable)callSiteArray[5].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ThreadAligner.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ThreadAligner.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ThreadAligner.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ThreadAligner.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ThreadAligner.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ThreadAligner.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "await";
            stringArray[2] = "interrupt";
            stringArray[3] = "currentThread";
            stringArray[4] = "<$constructor$>";
            stringArray[5] = "<$constructor$>";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            ThreadAligner.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ThreadAligner.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ThreadAligner.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class MemoryDatabase
    implements AutoCloseable,
    GroovyObject {
        private static final String SENSING_TABLE = "_fake_lock";
        private final String connectionUrl;
        private final Connection mainConnection;
        private boolean closed;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        private MemoryDatabase(String connectionUrl, Connection mainConnection) {
            MetaClass metaClass;
            boolean bl;
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            this.closed = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            String string = connectionUrl;
            this.connectionUrl = ShortTypeHandling.castToString((Object)string);
            Connection connection = mainConnection;
            this.mainConnection = (Connection)ScriptBytecodeAdapter.castToType((Object)connection, Connection.class);
        }

        public static synchronized MemoryDatabase create(String dbName) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            MemoryDatabase db = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[0].callStatic(MemoryDatabase.class, (Object)dbName);
                db = (MemoryDatabase)ScriptBytecodeAdapter.castToType((Object)object, MemoryDatabase.class);
            } else {
                MemoryDatabase memoryDatabase;
                db = memoryDatabase = MemoryDatabase.createUnvalidated(dbName);
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call((Object)db))) {
                callSiteArray[2].call((Object)db);
                throw (Throwable)callSiteArray[3].callConstructor(IllegalStateException.class, callSiteArray[4].call((Object)"Database already exists: ", (Object)dbName));
            }
            callSiteArray[5].call((Object)db);
            return db;
        }

        @Override
        public synchronized void close() {
            boolean bl;
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            this.closed = bl = true;
            try {
                callSiteArray[6].call((Object)this.mainConnection);
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[7].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        public synchronized Connection getConnection() {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            if (this.closed) {
                throw (Throwable)callSiteArray[8].callConstructor(IllegalStateException.class, (Object)"Fake connection factory is closed!");
            }
            Connection connection = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callStatic(MemoryDatabase.class, (Object)this.connectionUrl), Connection.class);
            try {
                return connection;
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[10].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        public List<String> queryTables() {
            public class _queryTables_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _queryTables_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _queryTables_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object rec) {
                    CallSite[] callSiteArray = _queryTables_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].call(rec, (Object)"table_name"));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _queryTables_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "toLowerCase";
                    stringArray[1] = "get";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _queryTables_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_queryTables_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _queryTables_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call(callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callCurrent((GroovyObject)this, (Object)"SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA <> 'INFORMATION_SCHEMA'")), (Object)new _queryTables_closure1(this, this)), callSiteArray[15].call(Collectors.class)), List.class);
            }
            return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call(this.query("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA <> 'INFORMATION_SCHEMA'")), (Object)new _queryTables_closure1(this, this)), callSiteArray[19].call(Collectors.class)), List.class);
        }

        public List<Map<String, String>> query(String sql) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            List l = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(ArrayList.class), List.class);
            Statement stat = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call((Object)this.mainConnection), Statement.class);
            ResultSet rc = (ResultSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call((Object)stat, (Object)sql), ResultSet.class);
            try {
                ResultSetMetaData m = (ResultSetMetaData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call((Object)rc), ResultSetMetaData.class);
                while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)rc))) {
                    Map record = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(LinkedHashMap.class), Map.class);
                    int i = 1;
                    while (ScriptBytecodeAdapter.compareLessThanEqual((Object)i, (Object)callSiteArray[26].call((Object)m))) {
                        callSiteArray[27].call((Object)record, callSiteArray[28].call(callSiteArray[29].call((Object)m, (Object)i)), callSiteArray[30].call((Object)rc, (Object)i));
                        int n = i;
                        i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[31].call((Object)n));
                    }
                    callSiteArray[32].call((Object)l, (Object)record);
                }
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[33].callConstructor(IllegalStateException.class, (Object)e);
            }
            return l;
        }

        public int update(String sql) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            Statement stat = (Statement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)this.mainConnection), Statement.class);
            int n = DefaultTypeTransformation.intUnbox((Object)callSiteArray[35].call((Object)stat, (Object)sql));
            try {
                return n;
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[36].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        private static MemoryDatabase createUnvalidated(String dbName) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            String connectionUrl = ShortTypeHandling.castToString((Object)callSiteArray[37].call((Object)"jdbc:h2:mem:", (Object)dbName));
            Connection con = null;
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                Object object = callSiteArray[38].callStatic(MemoryDatabase.class, (Object)connectionUrl);
                con = (Connection)ScriptBytecodeAdapter.castToType((Object)object, Connection.class);
            } else {
                Connection connection;
                con = connection = MemoryDatabase.createConnection(connectionUrl);
            }
            MemoryDatabase memoryDatabase = (MemoryDatabase)ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].callConstructor(MemoryDatabase.class, (Object)connectionUrl, (Object)con), MemoryDatabase.class);
            try {
                return memoryDatabase;
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[40].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        private boolean hasSensingTable() {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].callCurrent((GroovyObject)this)), (Object)ScriptBytecodeAdapter.getMethodPointer((Object)SENSING_TABLE, (String)"equals")));
            }
            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].call(callSiteArray[45].call(this.queryTables()), (Object)ScriptBytecodeAdapter.getMethodPointer((Object)SENSING_TABLE, (String)"equals")));
        }

        private void createSensingTable() {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            String sql = ShortTypeHandling.castToString((Object)callSiteArray[46].call(callSiteArray[47].call((Object)"CREATE TABLE ", (Object)SENSING_TABLE), (Object)" ( DUMMY VARCHAR(100), PRIMARY KEY (DUMMY))"));
            PreparedStatement stat = (PreparedStatement)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].call((Object)this.mainConnection, (Object)sql), PreparedStatement.class);
            try {
                callSiteArray[49].call((Object)stat);
            }
            catch (SQLException e) {
                throw (Throwable)callSiteArray[50].callConstructor(IllegalStateException.class, (Object)e);
            }
        }

        private static Connection createConnection(String connectionUrl) throws SQLException {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call(DriverManager.class, (Object)connectionUrl, (Object)"sa", (Object)""), Connection.class);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(MemoryDatabase.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(MemoryDatabase.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MemoryDatabase.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = MemoryDatabase.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MemoryDatabase.class, ThreadLocalScopeManagerTest.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MemoryDatabase.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "createUnvalidated";
            stringArray[1] = "hasSensingTable";
            stringArray[2] = "close";
            stringArray[3] = "<$constructor$>";
            stringArray[4] = "plus";
            stringArray[5] = "createSensingTable";
            stringArray[6] = "close";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "createConnection";
            stringArray[10] = "<$constructor$>";
            stringArray[11] = "collect";
            stringArray[12] = "map";
            stringArray[13] = "stream";
            stringArray[14] = "query";
            stringArray[15] = "toList";
            stringArray[16] = "collect";
            stringArray[17] = "map";
            stringArray[18] = "stream";
            stringArray[19] = "toList";
            stringArray[20] = "<$constructor$>";
            stringArray[21] = "createStatement";
            stringArray[22] = "executeQuery";
            stringArray[23] = "getMetaData";
            stringArray[24] = "next";
            stringArray[25] = "<$constructor$>";
            stringArray[26] = "getColumnCount";
            stringArray[27] = "put";
            stringArray[28] = "toLowerCase";
            stringArray[29] = "getColumnName";
            stringArray[30] = "getString";
            stringArray[31] = "next";
            stringArray[32] = "add";
            stringArray[33] = "<$constructor$>";
            stringArray[34] = "createStatement";
            stringArray[35] = "executeUpdate";
            stringArray[36] = "<$constructor$>";
            stringArray[37] = "plus";
            stringArray[38] = "createConnection";
            stringArray[39] = "<$constructor$>";
            stringArray[40] = "<$constructor$>";
            stringArray[41] = "anyMatch";
            stringArray[42] = "stream";
            stringArray[43] = "queryTables";
            stringArray[44] = "anyMatch";
            stringArray[45] = "stream";
            stringArray[46] = "plus";
            stringArray[47] = "plus";
            stringArray[48] = "prepareStatement";
            stringArray[49] = "executeUpdate";
            stringArray[50] = "<$constructor$>";
            stringArray[51] = "getConnection";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[52];
            MemoryDatabase.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(MemoryDatabase.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = MemoryDatabase.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

