/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import liquibase.change.AbstractSQLChange;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StreamUtil;
import org.junit.Assert;
import org.junit.Test;

public class AbstractSQLChangeTest {
    @Test
    public void constructor() {
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange();
        Assert.assertFalse((boolean)change.isStripComments());
        Assert.assertTrue((boolean)change.isSplitStatements());
        Assert.assertNull((Object)change.getEndDelimiter());
    }

    @Test
    public void setStrippingComments() {
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange();
        change.setStripComments(true);
        Assert.assertTrue((boolean)change.isStripComments());
        change.setStripComments(false);
        Assert.assertFalse((boolean)change.isStripComments());
        change.setStripComments(null);
        Assert.assertFalse((boolean)change.isStripComments());
    }

    @Test
    public void setSplittingStatements() {
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange();
        change.setSplitStatements(true);
        Assert.assertTrue((boolean)change.isSplitStatements());
        change.setSplitStatements(false);
        Assert.assertFalse((boolean)change.isSplitStatements());
        change.setSplitStatements(null);
        Assert.assertTrue((boolean)change.isSplitStatements());
    }

    @Test
    public void setSql() {
        ExampleAbstractSQLChange sql = new ExampleAbstractSQLChange();
        sql.setSql("SOME SQL");
        Assert.assertEquals((Object)"SOME SQL", (Object)sql.getSql());
        sql.setSql("   SOME SQL   ");
        Assert.assertEquals((String)"setSql should trim", (Object)"SOME SQL", (Object)sql.getSql());
        sql.setSql("   ");
        Assert.assertNull((String)"setSql should set empty strings to null", (Object)sql.getSql());
    }

    @Test
    public void setEndDelimiter() {
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange();
        change.setEndDelimiter("GO");
        Assert.assertEquals((Object)"GO", (Object)change.getEndDelimiter());
        change.setEndDelimiter(";");
        Assert.assertEquals((Object)";", (Object)change.getEndDelimiter());
    }

    @Test
    public void generateCheckSum_lineEndingIndependent() {
        CheckSum sql = new ExampleAbstractSQLChange("LINE 1;\nLINE 2;\nLINE3;").generateCheckSum();
        CheckSum sqlCRLF = new ExampleAbstractSQLChange("LINE 1;\r\nLINE 2;\r\nLINE3;").generateCheckSum();
        CheckSum sqlLF = new ExampleAbstractSQLChange("LINE 1;\rLINE 2;\rLINE3;").generateCheckSum();
        CheckSum sqlDifferent = new ExampleAbstractSQLChange("Something Completely Different").generateCheckSum();
        Assert.assertEquals((Object)sql.toString(), (Object)sqlCRLF.toString());
        Assert.assertEquals((Object)sql.toString(), (Object)sqlLF.toString());
        Assert.assertNotEquals((Object)sql.toString(), (Object)sqlDifferent.toString());
    }

    @Test
    public void generateCheckSum_nullSql() {
        Assert.assertNotNull((Object)new ExampleAbstractSQLChange().generateCheckSum());
    }

    @Test
    public void generateCheckSum_changesBasedOnParams() {
        CheckSum baseCheckSum = new ExampleAbstractSQLChange("SOME SQL").generateCheckSum();
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange("SOME SQL");
        change.setSplitStatements(false);
        Assert.assertEquals((Object)baseCheckSum.toString(), (Object)change.generateCheckSum().toString());
        change = new ExampleAbstractSQLChange("SOME SQL");
        change.setEndDelimiter("X");
        Assert.assertEquals((Object)baseCheckSum.toString(), (Object)change.generateCheckSum().toString());
        change = new ExampleAbstractSQLChange("SOME SQL");
        change.setStripComments(true);
        Assert.assertEquals((Object)baseCheckSum.toString(), (Object)change.generateCheckSum().toString());
    }

    @Test
    public void generateStatements_convertsEndingsOnSqlServer() {
        ExampleAbstractSQLChange change = new ExampleAbstractSQLChange("LINE 1;\n--a comment\nLINE 2;\nLINE 3;");
        change.setSplitStatements(false);
        change.setStripComments(true);
        SqlStatement[] statements = change.generateStatements((Database)new MSSQLDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertEquals((Object)"LINE 1;\r\n\r\nLINE 2;\r\nLINE 3;", (Object)((RawSqlStatement)statements[0]).getSql());
    }

    @Test
    public void normalizeSql() throws IOException {
        this.assertNormalizingStreamCorrect("singlelineString", "single line String");
        this.assertNormalizingStreamCorrect("singlelinestringwithwhitespace", "single line string with      whitespace");
        this.assertNormalizingStreamCorrect("multiplelinestring", "\r\nmultiple\r\nline\r\nstring\r\n");
        this.assertNormalizingStreamCorrect("multiplelinestring", "\rmultiple\rline\rstring\r");
        this.assertNormalizingStreamCorrect("multiplelinestring", "\nmultiple\nline\nstring\n");
        this.assertNormalizingStreamCorrect("alinewithdoublenewlines", "\n\na\nline \n with \r\n \r\n double \n \n \n \n newlines");
        this.assertNormalizingStreamCorrect("", "    ");
        this.assertNormalizingStreamCorrect("", " \n \n \n   \n  ");
        String longSpaceString = "a line with a lot of: wait for it....                                                                                                                                                                                                                                                                                         spaces";
        this.assertNormalizingStreamCorrect("alinewithalotof:waitforit....spaces", longSpaceString);
        String versionNormalized = "INSERTINTOrecommendation_list(instanceId,name,publicId)SELECTDISTINCTinstanceId,\"default\"asname,\"default\"aspublicIdFROMrecommendation;";
        String version1 = "INSERT INTO recommendation_list(instanceId, name, publicId)\nSELECT DISTINCT instanceId, \"default\" as name, \"default\" as publicId\nFROM recommendation;";
        this.assertNormalizingStreamCorrect(versionNormalized, version1);
        String version2 = "INSERT INTO \n    recommendation_list(instanceId, name, publicId)\nSELECT \n    DISTINCT \n        instanceId, \n          \"default\" as name, \n          \"default\" as publicId\n   FROM \n       recommendation;";
        this.assertNormalizingStreamCorrect(versionNormalized, version2);
    }

    private void assertNormalizingStreamCorrect(String expected, String toCorrect) throws IOException {
        AbstractSQLChange.NormalizingStream normalizingStream = new AbstractSQLChange.NormalizingStream((InputStream)new ByteArrayInputStream(toCorrect.getBytes()));
        Assert.assertEquals((Object)expected, (Object)StreamUtil.readStreamAsString((InputStream)normalizingStream));
    }

    @DatabaseChange(name="exampleAbstractSQLChange", description="Used for the AbstractSQLChangeTest unit test", priority=1)
    private static class ExampleAbstractSQLChange
    extends AbstractSQLChange {
        private ExampleAbstractSQLChange() {
        }

        private ExampleAbstractSQLChange(String sql) {
            this.setSql(sql);
        }

        public String getConfirmationMessage() {
            return "Example SQL Change Message";
        }

        public String getSerializedObjectNamespace() {
            return "http://www.liquibase.org/xml/ns/dbchangelog";
        }
    }
}

