/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import liquibase.change.AddColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MockDatabase;
import liquibase.exception.RollbackImpossibleException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.statement.core.DropColumnStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import org.junit.Assert;
import org.junit.Test;

public class AddColumnChangeTest {
    @Test
    public void generateStatements_multipleColumns() {
        AddColumnChange change = new AddColumnChange();
        AddColumnConfig column1 = new AddColumnConfig();
        column1.setName("column1");
        column1.setType("INT");
        change.addColumn(column1);
        AddColumnConfig column2 = new AddColumnConfig();
        column2.setName("column2");
        column2.setType("INT");
        change.addColumn(column2);
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof AddColumnStatement));
        AddColumnStatement stmt = (AddColumnStatement)statements[0];
        Assert.assertTrue((boolean)stmt.isMultiple());
        Assert.assertEquals((long)2L, (long)stmt.getColumns().size());
    }

    @Test
    public void generateStatements_DB2_multipleColumns_single_reorg() {
        AddColumnChange change = new AddColumnChange();
        AddColumnConfig column1 = new AddColumnConfig();
        column1.setName("column1");
        column1.setType("INT");
        change.addColumn(column1);
        AddColumnConfig column2 = new AddColumnConfig();
        column2.setName("column2");
        column2.setType("INT");
        change.addColumn(column2);
        SqlStatement[] statements = change.generateStatements((Database)new DB2Database());
        Assert.assertEquals((long)2L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof AddColumnStatement));
        AddColumnStatement stmt = (AddColumnStatement)statements[0];
        Assert.assertTrue((boolean)stmt.isMultiple());
        Assert.assertEquals((long)2L, (long)stmt.getColumns().size());
        Assert.assertTrue((boolean)(statements[1] instanceof ReorganizeTableStatement));
    }

    @Test
    public void generateStatements_singleColumn_uniqueConstraintName() {
        String myUniqueConstraintName = "my_unique_constraint";
        AddColumnChange change = new AddColumnChange();
        change.setTableName("my_table");
        AddColumnConfig column = new AddColumnConfig();
        column.setName("column1");
        column.setType("integer");
        ConstraintsConfig constraintsConfig = new ConstraintsConfig();
        constraintsConfig.setUnique(Boolean.valueOf(true));
        constraintsConfig.setUniqueConstraintName(myUniqueConstraintName);
        column.setConstraints(constraintsConfig);
        change.addColumn(column);
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof AddColumnStatement));
        AddColumnStatement stmt = (AddColumnStatement)statements[0];
        Assert.assertEquals((Object)myUniqueConstraintName, (Object)stmt.getUniqueStatementName());
    }

    @Test
    public void generateStatements_singleColumn_null_uniqueConstraintName() {
        AddColumnChange change = new AddColumnChange();
        change.setTableName("my_table");
        AddColumnConfig column = new AddColumnConfig();
        column.setName("column1");
        column.setType("integer");
        ConstraintsConfig constraintsConfig = new ConstraintsConfig();
        constraintsConfig.setUnique(Boolean.valueOf(true));
        column.setConstraints(constraintsConfig);
        change.addColumn(column);
        SqlStatement[] statements = change.generateStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof AddColumnStatement));
        AddColumnStatement stmt = (AddColumnStatement)statements[0];
        Assert.assertNull((Object)stmt.getUniqueStatementName());
    }

    @Test
    public void generateRollbackStatements_catalog_schema_table() throws RollbackImpossibleException {
        AddColumnChange change = new AddColumnChange();
        change.setCatalogName("catalog1");
        change.setSchemaName("schema1");
        change.setTableName("table1");
        SqlStatement[] statements = change.generateRollbackStatements((Database)new MockDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof DropColumnStatement));
        DropColumnStatement dropStmt = (DropColumnStatement)statements[0];
        Assert.assertEquals((Object)"catalog1", (Object)dropStmt.getCatalogName());
        Assert.assertEquals((Object)"schema1", (Object)dropStmt.getSchemaName());
        Assert.assertEquals((Object)"table1", (Object)dropStmt.getTableName());
    }
}

