/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeMetaData;
import liquibase.change.core.CreateTableChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateSequenceStatement;
import org.junit.Assert;
import org.junit.Test;

public class ChangeFactoryTest {
    @Test
    public void supportStatement() {
        CreateSequenceStatement statement = new CreateSequenceStatement(null, null, "seq_my_table");
        MSSQLDatabase database10 = new MSSQLDatabase(){

            public int getDatabaseMajorVersion() {
                return 10;
            }
        };
        MSSQLDatabase database11 = new MSSQLDatabase(){

            public int getDatabaseMajorVersion() {
                return 11;
            }
        };
        Scope.getCurrentScope().getSingleton(ChangeFactory.class);
        Assert.assertFalse((String)"unsupported create sequence", (boolean)SqlGeneratorFactory.getInstance().supports((SqlStatement)statement, (Database)database10));
        Assert.assertTrue((String)"supported create sequence", (boolean)SqlGeneratorFactory.getInstance().supports((SqlStatement)statement, (Database)database11));
    }

    @Test
    public void create_exists() {
        Change change = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).create("createTable");
        Assert.assertNotNull((Object)change);
        Assert.assertTrue((boolean)(change instanceof CreateTableChange));
        Assert.assertNotSame((Object)change, (Object)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).create("createTable"));
    }

    @Test
    public void create_notExists() {
        Change change = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).create("badChangeName");
        Assert.assertNull((Object)change);
    }

    @LiquibaseService(skip=true)
    public static class ExceptionThrowingChange
    extends CreateTableChange {
        public ExceptionThrowingChange() {
            throw new RuntimeException("I throw exceptions");
        }

        public ChangeMetaData createChangeMetaData() {
            return new ChangeMetaData("createTable", null, 15, null, null, null);
        }
    }

    @LiquibaseService(skip=true)
    public static class AnotherPriority5Change
    extends CreateTableChange {
        public ChangeMetaData createChangeMetaData() {
            return new ChangeMetaData("createTable", null, 5, null, null, null);
        }
    }

    @LiquibaseService(skip=true)
    public static class Priority10Change
    extends CreateTableChange {
        public ChangeMetaData createChangeMetaData() {
            return new ChangeMetaData("createTable", null, 10, null, null, null);
        }
    }

    @LiquibaseService(skip=true)
    public static class Priority5Change
    extends CreateTableChange {
        public ChangeMetaData createChangeMetaData() {
            return new ChangeMetaData("createTable", null, 5, null, null, null);
        }
    }
}

