/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.HashMap;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.ExampleAbstractChange;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.CreateViewChange;
import liquibase.change.core.DropAllForeignKeyConstraintsChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.LiquibaseSerializable;
import org.junit.Assert;
import org.junit.Test;

public class ChangeParameterMetaDataTest {
    @Test
    public void constructor() {
        HashMap<String, String> examples = new HashMap<String, String>();
        examples.put("all", "examp");
        ChangeParameterMetaData metaData = new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", "desc", examples, "2.1", Integer.class, new String[]{"mysql", "mssql"}, new String[]{"h2", "mysql", "mssql"}, "column", LiquibaseSerializable.SerializationType.NESTED_OBJECT);
        Assert.assertEquals((Object)"x", (Object)metaData.getParameterName());
        Assert.assertEquals((Object)"y", (Object)metaData.getDisplayName());
        Assert.assertEquals((Object)"integer", (Object)metaData.getDataType());
        Assert.assertEquals((long)2L, (long)metaData.getRequiredForDatabase().size());
        Assert.assertTrue((boolean)metaData.getRequiredForDatabase().contains("mysql"));
        Assert.assertTrue((boolean)metaData.getRequiredForDatabase().contains("mssql"));
        Assert.assertEquals((Object)"column", (Object)metaData.getMustEqualExisting());
        Assert.assertEquals((Object)LiquibaseSerializable.SerializationType.NESTED_OBJECT, (Object)metaData.getSerializationType());
        Assert.assertEquals((Object)"desc", (Object)metaData.getDescription());
        Assert.assertEquals((Object)"examp", (Object)metaData.getExampleValue((Database)new MockDatabase()));
        Assert.assertEquals((Object)"2.1", (Object)metaData.getSince());
        Assert.assertEquals((long)3L, (long)metaData.getSupportedDatabases().size());
        Assert.assertTrue((boolean)metaData.getSupportedDatabases().contains("mysql"));
        Assert.assertTrue((boolean)metaData.getSupportedDatabases().contains("mssql"));
        Assert.assertTrue((boolean)metaData.getSupportedDatabases().contains("h2"));
    }

    @Test
    public void constructor_badValues() {
        try {
            new ChangeParameterMetaData((Change)new ExampleAbstractChange(), null, "y", null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
            Assert.fail((String)"Did not throw exception");
        }
        catch (UnexpectedLiquibaseException e) {
            Assert.assertEquals((Object)"Unexpected null parameterName", (Object)e.getMessage());
        }
        try {
            new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x tag", "y", null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
            Assert.fail((String)"Did not throw exception");
        }
        catch (UnexpectedLiquibaseException e) {
            Assert.assertEquals((Object)"Unexpected space in parameterName", (Object)e.getMessage());
        }
        try {
            new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", null, null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
            Assert.fail((String)"Did not throw exception");
        }
        catch (UnexpectedLiquibaseException e) {
            Assert.assertEquals((Object)"Unexpected null displayName", (Object)e.getMessage());
        }
        try {
            new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, null, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
            Assert.fail((String)"Did not throw exception");
        }
        catch (UnexpectedLiquibaseException e) {
            Assert.assertEquals((Object)"Unexpected null dataType", (Object)e.getMessage());
        }
    }

    @Test
    public void getRequiredForDatabase_nullPassedInReturnsEmptySet() {
        Assert.assertEquals((long)0L, (long)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).getRequiredForDatabase().size());
    }

    @Test
    public void getRequiredForDatabase_nonePassedReturnsEmptySet() {
        Assert.assertEquals((long)0L, (long)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"none"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).getRequiredForDatabase().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void getRequiredForDatabase_immutable() {
        new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).getRequiredForDatabase().add("mssql");
    }

    @Test
    public void isRequiredFor() {
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MySQLDatabase()));
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MySQLDatabase(){}));
        Assert.assertFalse((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MSSQLDatabase()));
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql", "mssql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MySQLDatabase()));
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql", "mssql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MSSQLDatabase()));
        Assert.assertFalse((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"mysql", "mssql"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new OracleDatabase()));
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"all"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new OracleDatabase()));
        Assert.assertTrue((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[]{"all"}, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MySQLDatabase()));
        Assert.assertFalse((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[0], null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new OracleDatabase()));
        Assert.assertFalse((boolean)new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "x", "y", null, null, null, Integer.class, new String[0], null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD).isRequiredFor((Database)new MySQLDatabase()));
    }

    @Test
    public void getCurrentValue() {
        CreateTableChange change = new CreateTableChange();
        change.setTableName("newTable");
        change.setCatalogName("newCatalog");
        ChangeParameterMetaData tableNameMetaData = new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "tableName", "New Table", null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
        ChangeParameterMetaData catalogNameMetaData = new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "catalogName", "New Catalog", null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
        ChangeParameterMetaData remarksMetaData = new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "remarks", "Remarks", null, null, null, String.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
        Assert.assertEquals((Object)"newTable", (Object)tableNameMetaData.getCurrentValue((Change)change));
        Assert.assertEquals((Object)"newCatalog", (Object)catalogNameMetaData.getCurrentValue((Change)change));
        Assert.assertNull((Object)remarksMetaData.getCurrentValue((Change)change));
        change.setTableName("changedTableName");
        Assert.assertEquals((Object)"changedTableName", (Object)tableNameMetaData.getCurrentValue((Change)change));
    }

    @Test(expected=UnexpectedLiquibaseException.class)
    public void getCurrentValue_badParam() {
        CreateTableChange change = new CreateTableChange();
        ChangeParameterMetaData badParamMetaData = new ChangeParameterMetaData((Change)new ExampleAbstractChange(), "badParameter", "Doesn't really exist", null, null, null, Integer.class, null, null, null, LiquibaseSerializable.SerializationType.NAMED_FIELD);
        badParamMetaData.getCurrentValue((Change)change);
    }

    @Test
    public void computedDatabasesCorrect() {
        ChangeParameterMetaData catalogName = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddNotNullConstraintChange()).getParameters().get("catalogName");
        liquibase.test.Assert.assertSetsEqual(new String[0], catalogName.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, catalogName.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData tableName = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddNotNullConstraintChange()).getParameters().get("tableName");
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, tableName.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, tableName.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData columnDataType = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddNotNullConstraintChange()).getParameters().get("columnDataType");
        liquibase.test.Assert.assertSetsEqual(new String[]{"informix", "mssql", "mysql", "mariadb"}, columnDataType.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, columnDataType.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData column = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddColumnChange()).getParameters().get("columns");
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, column.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, column.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        tableName = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddColumnChange()).getParameters().get("tableName");
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, tableName.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, tableName.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        catalogName = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new DropPrimaryKeyChange()).getParameters().get("catalogName");
        liquibase.test.Assert.assertSetsEqual(new String[0], catalogName.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, catalogName.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData columns = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new AddColumnChange()).getParameters().get("columns");
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, columns.analyzeRequiredDatabases(new String[]{"all"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, columns.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData baseTableCatalogName = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new DropAllForeignKeyConstraintsChange()).getParameters().get("baseTableCatalogName");
        liquibase.test.Assert.assertSetsEqual(new String[0], baseTableCatalogName.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"all"}, baseTableCatalogName.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
        ChangeParameterMetaData replaceIfExists = (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData((Change)new CreateViewChange()).getParameters().get("replaceIfExists");
        liquibase.test.Assert.assertSetsEqual(new String[0], replaceIfExists.analyzeRequiredDatabases(new String[]{"COMPUTE"}));
        liquibase.test.Assert.assertSetsEqual(new String[]{"sybase", "mssql", "postgresql", "cockroachdb", "firebird", "oracle", "sqlite", "mysql", "mariadb", "h2", "hsqldb", "db2", "ingres", "edb"}, replaceIfExists.analyzeSupportedDatabases(new String[]{"COMPUTE"}));
    }
}

