/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import liquibase.change.CheckSum;
import org.junit.Assert;
import org.junit.Test;

public class CheckSumTest {
    @Test
    public void parse() {
        String checksumString = "3:asdf";
        CheckSum checkSum = CheckSum.parse((String)checksumString);
        Assert.assertEquals((long)3L, (long)checkSum.getVersion());
        Assert.assertEquals((Object)checksumString, (Object)checkSum.toString());
    }

    @Test
    public void parse_null() {
        Assert.assertNull((Object)CheckSum.parse(null));
    }

    @Test
    public void parse_v1() {
        String checksumString = "asdf";
        CheckSum checkSum = CheckSum.parse((String)checksumString);
        Assert.assertEquals((long)1L, (long)checkSum.getVersion());
        Assert.assertEquals((Object)"1:asdf", (Object)checkSum.toString());
    }

    @Test
    public void getCurrentVersion() {
        Assert.assertEquals((long)9L, (long)CheckSum.getCurrentVersion());
    }

    @Test
    public void compute_String() {
        String valueToHash = "asdf";
        CheckSum checkSum = CheckSum.compute((String)valueToHash);
        Assert.assertEquals((long)CheckSum.getCurrentVersion(), (long)checkSum.getVersion());
        Assert.assertNotEquals((Object)checkSum.toString(), (Object)valueToHash);
    }

    @Test
    public void compute_String_shouldIgnoreUnknownUnicodeChar() {
        CheckSum checkSum1 = CheckSum.compute((String)"asdfa");
        CheckSum checkSum2 = CheckSum.compute((String)"as\ufffddf\ufffda");
        Assert.assertEquals((Object)checkSum2, (Object)checkSum1);
    }

    @Test
    public void compute_Stream() {
        String valueToHash = "asdf";
        CheckSum checkSum = CheckSum.compute((InputStream)new ByteArrayInputStream(valueToHash.getBytes()), (boolean)false);
        Assert.assertEquals((long)CheckSum.getCurrentVersion(), (long)checkSum.getVersion());
        Assert.assertNotEquals((Object)checkSum.toString(), (Object)valueToHash);
        Assert.assertEquals((Object)CheckSum.compute((String)valueToHash).toString(), (Object)checkSum.toString());
    }

    @Test
    public void toString_test() {
        Assert.assertTrue((boolean)CheckSum.parse((String)"9:asdf").toString().startsWith("9:"));
    }

    @Test
    public void equals() {
        Assert.assertEquals((Object)CheckSum.parse((String)"9:asdf"), (Object)CheckSum.parse((String)"9:asdf"));
        Assert.assertNotEquals((Object)CheckSum.parse((String)"9:asdf"), (Object)CheckSum.parse((String)"8:asdf"));
        Assert.assertNotEquals((Object)CheckSum.parse((String)"9:asdf"), (Object)CheckSum.parse((String)"9:qwert"));
        Assert.assertNotEquals((Object)12, (Object)CheckSum.parse((String)"9:asdf"));
        Assert.assertNotEquals(null, (Object)CheckSum.parse((String)"9:asdf"));
    }

    @Test
    public void compute_lineEndingsDontMatter() {
        String checkSum = CheckSum.compute((String)"a string\nwith\nlines").toString();
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\rwith\rlines").toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\r\nwith\r\nlines").toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\rwith\nlines").toString());
        Assert.assertNotEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\n\nwith\n\nlines").toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\nwith\nlines".getBytes()), (boolean)true).toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\rwith\rlines".getBytes()), (boolean)true).toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\r\nwith\r\nlines".getBytes()), (boolean)true).toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\rwith\r\nlines".getBytes()), (boolean)true).toString());
    }

    @Test
    public void compute_lineEndingsDontMatter_multiline() {
        String checkSum = CheckSum.compute((String)"a string\n\nwith\n\nlines").toString();
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\r\rwith\r\rlines").toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((String)"a string\r\n\r\nwith\r\n\r\nlines").toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\n\nwith\n\nlines".getBytes()), (boolean)true).toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\r\rwith\r\rlines".getBytes()), (boolean)true).toString());
        Assert.assertEquals((Object)checkSum, (Object)CheckSum.compute((InputStream)new ByteArrayInputStream("a string\r\n\r\nwith\r\n\r\nlines".getBytes()), (boolean)true).toString());
    }
}

