/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import liquibase.change.core.LoadDataChange;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.test.JUnitResourceAccessor;
import org.junit.Assert;
import org.junit.Test;

public class LoadDataOtherTest {
    LoadDataChange loadDataChange = new LoadDataChange();

    @Test
    public void testOtherColumnLoadData() throws Exception {
        this.loadDataChange.setResourceAccessor((ResourceAccessor)new JUnitResourceAccessor());
        ArrayList<LoadDataColumnConfig> columnConfigs = new ArrayList<LoadDataColumnConfig>();
        LoadDataColumnConfig col1 = new LoadDataColumnConfig();
        col1.setHeader("int_col");
        col1.setName("int_col");
        col1.setType("NUMERIC");
        columnConfigs.add(col1);
        LoadDataColumnConfig col2 = new LoadDataColumnConfig();
        col2.setHeader("str_col");
        col2.setName("str_col");
        col2.setType("STRING");
        columnConfigs.add(col2);
        LoadDataColumnConfig col3 = new LoadDataColumnConfig();
        col3.setHeader("enum_col");
        col3.setName("enum_col");
        col3.setType("OTHER");
        columnConfigs.add(col3);
        this.loadDataChange.setColumns(columnConfigs);
        this.loadDataChange.setFile("liquibase/change/core/enum-data.csv");
        SqlStatement[] statements = this.loadDataChange.generateStatements((Database)new PostgresDatabase());
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertNotNull((Object)statements[0]);
        Assert.assertEquals((long)3L, (long)((InsertSetStatement)statements[0]).getStatementsArray().length);
        Assert.assertEquals((Object)"EnumValOne", ((InsertSetStatement)statements[0]).getStatementsArray()[0].getColumnValues().get("enum_col"));
        Assert.assertEquals((Object)"EnumValTwo", ((InsertSetStatement)statements[0]).getStatementsArray()[1].getColumnValues().get("enum_col"));
        Assert.assertEquals((Object)"NULL", ((InsertSetStatement)statements[0]).getStatementsArray()[2].getColumnValues().get("enum_col"));
    }
}

