/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.database.Database;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class ExampleCustomSqlChange
implements CustomSqlChange,
CustomSqlRollback {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String newValue;
    private ResourceAccessor resourceAccessor;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new RawSqlStatement("UPDATE " + database.escapeObjectName(null, this.schemaName, this.tableName, Table.class) + " SET " + database.escapeObjectName(this.columnName, Column.class) + " = " + this.newValue)};
    }

    public SqlStatement[] generateRollbackStatements(Database database) throws RollbackImpossibleException {
        return new SqlStatement[]{new RawSqlStatement("UPDATE " + database.escapeObjectName(null, this.schemaName, this.tableName, Table.class) + " SET " + database.escapeObjectName(this.columnName, Column.class) + " = NULL")};
    }

    public String getConfirmationMessage() {
        return "Custom class updated " + this.tableName + "." + this.columnName;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }
}

