/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.Contexts;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.LiquibaseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogIteratorTest {
    private DatabaseChangeLog changeLog;

    @Before
    public void setUp() {
        this.changeLog = new DatabaseChangeLog();
        this.changeLog.addChangeSet(new ChangeSet("1", "nvoxland", false, false, "/path/to/changelog", "test1", "mysql", null));
        this.changeLog.addChangeSet(new ChangeSet("2", "nvoxland", false, false, "/path/to/changelog", "test1", "oracle", null));
        this.changeLog.addChangeSet(new ChangeSet("3", "nvoxland", false, false, "/path/to/changelog", "test2", "mysql", null));
        this.changeLog.addChangeSet(new ChangeSet("4", "nvoxland", false, false, "/path/to/changelog", null, null, null));
        this.changeLog.addChangeSet(new ChangeSet("5", "nvoxland", false, false, "/path/to/changelog", null, "mysql", null));
        this.changeLog.addChangeSet(new ChangeSet("6", "nvoxland", false, false, "/path/to/changelog", "test2", null, null));
        this.changeLog.addChangeSet(new ChangeSet("7", "nvoxland", false, false, "/path/to/changelog", "test2", null, "jdbc", null, true, ObjectQuotingStrategy.LEGACY, null));
    }

    @Test
    public void runChangeSet_emptyFiltersIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[0]);
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
        Assert.assertEquals((long)7L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_withBogusExecutor() throws Exception {
        this.changeLog.addChangeSet(new ChangeSet("8", "nvoxland", false, false, "/path/to/changelog", "test2", null, "foo", null, true, ObjectQuotingStrategy.LEGACY, null));
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[0]);
        try {
            iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
            Assert.fail((String)"No exception thrown.  Expected LiquibaseException for invalid Executor");
        }
        catch (LiquibaseException e) {
            boolean b = e.getMessage().contains("Unable to locate Executor");
            Assert.assertTrue((boolean)b);
        }
        Assert.assertEquals((long)7L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_withExecutors() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[0]);
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
        Assert.assertEquals((long)7L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_singleFilterIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new Contexts("test1"))});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
        Assert.assertEquals((long)4L, (long)testChangeLogVisitor.visitedChangeSets.size());
    }

    @Test
    public void runChangeSet_doubleFilterIterator() throws Exception {
        TestChangeSetVisitor testChangeLogVisitor = new TestChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new Contexts("test1")), new DbmsChangeSetFilter((Database)new MySQLDatabase())});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
        Assert.assertEquals((long)3L, (long)testChangeLogVisitor.visitedChangeSets.size());
        Assert.assertEquals((Object)"1", (Object)testChangeLogVisitor.visitedChangeSets.get(0).getId());
        Assert.assertEquals((Object)"4", (Object)testChangeLogVisitor.visitedChangeSets.get(1).getId());
        Assert.assertEquals((Object)"5", (Object)testChangeLogVisitor.visitedChangeSets.get(2).getId());
    }

    @Test
    public void runChangeSet_reverseVisitor() throws Exception {
        ReverseChangeSetVisitor testChangeLogVisitor = new ReverseChangeSetVisitor();
        ChangeLogIterator iterator = new ChangeLogIterator(this.changeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(new Contexts("test1")), new DbmsChangeSetFilter((Database)new MySQLDatabase())});
        iterator.run((ChangeSetVisitor)testChangeLogVisitor, new RuntimeEnvironment(null, null, null));
        Assert.assertEquals((long)3L, (long)testChangeLogVisitor.visitedChangeSets.size());
        Assert.assertEquals((Object)"5", (Object)testChangeLogVisitor.visitedChangeSets.get(0).getId());
        Assert.assertEquals((Object)"4", (Object)testChangeLogVisitor.visitedChangeSets.get(1).getId());
        Assert.assertEquals((Object)"1", (Object)testChangeLogVisitor.visitedChangeSets.get(2).getId());
    }

    private static class ReverseChangeSetVisitor
    extends TestChangeSetVisitor {
        private ReverseChangeSetVisitor() {
        }

        @Override
        public ChangeSetVisitor.Direction getDirection() {
            return ChangeSetVisitor.Direction.REVERSE;
        }
    }

    private static class TestChangeSetVisitor
    extends ValidatingVisitor {
        public List<ChangeSet> visitedChangeSets = new ArrayList<ChangeSet>();

        private TestChangeSetVisitor() {
        }

        public ChangeSetVisitor.Direction getDirection() {
            return ChangeSetVisitor.Direction.FORWARD;
        }

        public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
            this.visitedChangeSets.add(changeSet);
        }
    }
}

