/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.List;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.MockChangeLogParser;
import liquibase.parser.core.sql.SqlChangeLogParser;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ChangeLogParserFactoryTest {
    @After
    public void teardown() {
        ChangeLogParserFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogParserFactory.getInstance());
        Assert.assertSame((Object)ChangeLogParserFactory.getInstance(), (Object)ChangeLogParserFactory.getInstance());
    }

    @Test
    public void register() {
        ChangeLogParserFactory.getInstance().unregisterAllParsers();
        Assume.assumeThat((Object)ChangeLogParserFactory.getInstance().getParsers(), (Matcher)IsEmptyCollection.empty());
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new MockChangeLogParser(".test"));
        Assert.assertEquals((long)1L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        factory.unregisterAllParsers();
        Assume.assumeThat((Object)ChangeLogParserFactory.getInstance().getParsers(), (Matcher)IsEmptyCollection.empty());
        MockChangeLogParser mockChangeLogParser = new MockChangeLogParser(".test");
        factory.register((ChangeLogParser)new XMLChangeLogSAXParser());
        factory.register((ChangeLogParser)mockChangeLogParser);
        factory.register((ChangeLogParser)new SqlChangeLogParser());
        Assert.assertEquals((long)3L, (long)factory.getParsers().size());
        factory.unregister((ChangeLogParser)mockChangeLogParser);
        Assert.assertEquals((long)2L, (long)factory.getParsers().size());
    }

    @Test
    public void unregisterAllParsers_ShouldRemoveAllParsers() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        factory.register((ChangeLogParser)new MockChangeLogParser());
        Assume.assumeThat((Object)factory.getParsers(), (Matcher)IsNot.not((Matcher)IsEmptyCollection.empty()));
        factory.unregisterAllParsers();
        Assert.assertThat((Object)factory.getParsers(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void getParser_byExtension() throws Exception {
        ChangeLogParserFactory.getInstance().unregisterAllParsers();
        Assume.assumeThat((Object)ChangeLogParserFactory.getInstance().getParsers(), (Matcher)IsEmptyCollection.empty());
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertSame((Object)xmlChangeLogParser, (Object)parser);
    }

    @Test
    public void getParser_byFile() throws Exception {
        ChangeLogParserFactory.getInstance().unregisterAllParsers();
        Assume.assumeThat((Object)ChangeLogParserFactory.getInstance().getParsers(), (Matcher)IsEmptyCollection.empty());
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("path/to/a/file.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertSame((Object)xmlChangeLogParser, (Object)parser);
    }

    @Test
    public void getParser_shouldAssumePriority() throws Exception {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        MockChangeLogParser higherPriorityParser = new MockChangeLogParser(new String[]{"banana"}){

            @Override
            public int getPriority() {
                return Integer.MAX_VALUE;
            }
        };
        factory.register((ChangeLogParser)new MockChangeLogParser("banana"));
        factory.register((ChangeLogParser)higherPriorityParser);
        Assert.assertEquals((Object)higherPriorityParser, (Object)factory.getParser("banana", (ResourceAccessor)new JUnitResourceAccessor()));
    }

    @Test
    public void getParser_shouldNotGiveAbilityToChangeParsers() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        MockChangeLogParser mockChangeLogParser = new MockChangeLogParser();
        factory.getParsers().add(mockChangeLogParser);
        Assert.assertThat((Object)factory.getParsers(), (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)mockChangeLogParser)));
    }

    @Test(expected=UnknownChangelogFormatException.class)
    public void getParser_noneMatching() throws Exception {
        ChangeLogParserFactory.getInstance().unregisterAllParsers();
        XMLChangeLogSAXParser xmlChangeLogParser = new XMLChangeLogSAXParser();
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)xmlChangeLogParser);
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new SqlChangeLogParser());
        ChangeLogParserFactory.getInstance().getParser("badextension", (ResourceAccessor)new JUnitResourceAccessor());
    }

    @Test
    public void reset() {
        ChangeLogParserFactory instance1 = ChangeLogParserFactory.getInstance();
        ChangeLogParserFactory.reset();
        Assert.assertNotSame((Object)instance1, (Object)ChangeLogParserFactory.getInstance());
    }

    @Test
    public void builtInGeneratorsAreFound() {
        List parsers = ChangeLogParserFactory.getInstance().getParsers();
        Assert.assertThat((Object)parsers, (Matcher)IsNot.not((Matcher)IsEmptyCollection.empty()));
    }
}

