/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.OfflineChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.core.HsqlDatabase;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class OfflineChangeLogHistoryServiceTest {
    private static final String CHANGE_LOG_CSV = "changeLog.csv";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    private File getResourceAsFile(String resourceName) {
        URL resourceUrl = this.getClass().getResource(resourceName);
        if (resourceUrl == null) {
            throw new IllegalArgumentException("Resource " + resourceName + " not found for class " + this.getClass().getName());
        }
        try {
            return new File(resourceUrl.toURI());
        }
        catch (URISyntaxException e) {
            return new File(resourceUrl.getPath());
        }
    }

    @Test
    public void testInitOfflineWithOutputLiquibaseSql() throws Exception {
        StringWriter writer = new StringWriter();
        OfflineChangeLogHistoryService service = this.createService(writer, "true");
        ChangeSet changeSet = this.createChangeSet();
        service.init();
        service.setExecType(changeSet, ChangeSet.ExecType.EXECUTED);
        writer.close();
        Assert.assertTrue((boolean)writer.toString().contains("CREATE TABLE PUBLIC.DATABASECHANGELOG"));
        Assert.assertTrue((boolean)writer.toString().contains("INSERT INTO PUBLIC.DATABASECHANGELOG"));
    }

    @Test
    public void testNewCsvFileDeletion() throws Exception {
        StringWriter writer = new StringWriter();
        OfflineChangeLogHistoryService service = this.createService(writer, "true");
        ChangeSet changeSet = this.createChangeSet();
        service.init();
        service.setExecType(changeSet, ChangeSet.ExecType.EXECUTED);
        writer.close();
        Assert.assertTrue((boolean)new File(this.temporaryFolder.getRoot(), CHANGE_LOG_CSV).exists());
        Assert.assertFalse((boolean)new File(this.temporaryFolder.getRoot(), "changeLog.csv.new").exists());
    }

    @Test
    public void testInitOfflineWithOutputLiquibaseSqlAndNoDdl() throws Exception {
        StringWriter writer = new StringWriter();
        OfflineChangeLogHistoryService service = this.createService(writer, "data_only");
        ChangeSet changeSet = this.createChangeSet();
        service.init();
        service.setExecType(changeSet, ChangeSet.ExecType.EXECUTED);
        writer.close();
        Assert.assertFalse((boolean)writer.toString().contains("CREATE TABLE PUBLIC.DATABASECHANGELOG"));
        Assert.assertTrue((boolean)writer.toString().contains("INSERT INTO PUBLIC.DATABASECHANGELOG"));
    }

    private OfflineChangeLogHistoryService createService(Writer writer, String outputLiquibaseSql) {
        HsqlDatabase database = new HsqlDatabase();
        File changeLogCsvFile = new File(this.temporaryFolder.getRoot(), CHANGE_LOG_CSV);
        OfflineConnection connection = new OfflineConnection("offline:hsqldb?changeLogFile=" + changeLogCsvFile.getAbsolutePath() + "&outputLiquibaseSql=" + outputLiquibaseSql, (ResourceAccessor)new ClassLoaderResourceAccessor());
        database.setConnection((DatabaseConnection)connection);
        connection.attached((Database)database);
        OfflineChangeLogHistoryService changeLogHistoryService = (OfflineChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService((Database)database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)database), writer, (Database)database);
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", (Database)database, (Executor)loggingExecutor);
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)loggingExecutor);
        return changeLogHistoryService;
    }

    private ChangeSet createChangeSet() {
        DatabaseChangeLog databaseChangeLog = new DatabaseChangeLog("/patch/changeLog.xml");
        ChangeSet changeSet = new ChangeSet("id", "author", false, false, "/path/changeSet.xml", "", "", databaseChangeLog);
        databaseChangeLog.addChangeSet(changeSet);
        return changeSet;
    }
}

