/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import liquibase.CatalogAndSchema;
import liquibase.changelog.visitor.DBDocVisitor;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.PathResource;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DBDocVisitorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Database database;
    private long expectedNumberOfColumnHtmlFiles;

    public DBDocVisitorTest(Database database, long expectedNumberOfColumnHtmlFiles) {
        this.database = database;
        this.expectedNumberOfColumnHtmlFiles = expectedNumberOfColumnHtmlFiles;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({new PostgresDatabase(), 1}, {new OracleDatabase(), 1});
    }

    @Test
    public void testWriteHTMLWhenOracleDatabaseWithComputedColumn() throws Exception {
        Column normalColumn = new Column("normal_column");
        Column computedColumn = new Column("computed_column");
        computedColumn.setComputed(Boolean.valueOf(true));
        HashSet<Column> columns = new HashSet<Column>(Arrays.asList(normalColumn, computedColumn));
        DatabaseSnapshot mockSnapshot = (DatabaseSnapshot)Mockito.mock(DatabaseSnapshot.class);
        Mockito.when((Object)mockSnapshot.get(Table.class)).thenReturn(Collections.emptySet());
        Mockito.when((Object)mockSnapshot.get(Column.class)).thenReturn(columns);
        SnapshotGeneratorFactory mockSnapshotGeneratorFactory = (SnapshotGeneratorFactory)Mockito.mock(SnapshotGeneratorFactory.class);
        Mockito.when((Object)mockSnapshotGeneratorFactory.createSnapshot((CatalogAndSchema[])Mockito.any(CatalogAndSchema[].class), (Database)Mockito.any(Database.class), (SnapshotControl)Mockito.any(SnapshotControl.class))).thenReturn((Object)mockSnapshot);
        Path tempOutputDirPath = this.temporaryFolder.newFolder().toPath();
        PathResource rootOutputDir = new PathResource(tempOutputDirPath.toString(), tempOutputDirPath);
        DirectoryResourceAccessor resourceAccessor = new DirectoryResourceAccessor(tempOutputDirPath);
        DBDocVisitor dbDocVisitor = new DBDocVisitor(this.database);
        try (MockedStatic staticMockSnapshotGeneratorFactory = Mockito.mockStatic(SnapshotGeneratorFactory.class);){
            staticMockSnapshotGeneratorFactory.when(SnapshotGeneratorFactory::getInstance).thenReturn((Object)mockSnapshotGeneratorFactory);
            dbDocVisitor.writeHTML((Resource)rootOutputDir, (ResourceAccessor)resourceAccessor, new CatalogAndSchema[0]);
        }
        Path columnsOutputDirPath = tempOutputDirPath.resolve("columns");
        Assert.assertTrue((boolean)Files.isDirectory(columnsOutputDirPath, new LinkOption[0]));
        Assert.assertEquals((long)this.expectedNumberOfColumnHtmlFiles, (long)Files.list(columnsOutputDirPath).count());
    }
}

