/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.precondition.Precondition;
import liquibase.precondition.core.DBMSPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValidatingVisitorPreConditionsTest {
    private DatabaseChangeLog changeLog;
    private ChangeSet changeSet1;

    @Before
    public void setUp() {
        this.changeLog = new DatabaseChangeLog();
        this.changeSet1 = new ChangeSet("1", "testAuthor", false, false, "path/changelog", null, null, null);
        this.changeLog.addChangeSet(this.changeSet1);
        CreateTableChange change1 = new CreateTableChange();
        change1.setTableName("valid_test");
        change1.addColumn(new ColumnConfig().setName("id").setType("int"));
        this.changeSet1.addChange((Change)change1);
    }

    @Test
    public void testPreconditionForOracleOnOracleWithChangeLog() {
        PreconditionContainer preCondition = new PreconditionContainer();
        preCondition.setOnFail(PreconditionContainer.FailOption.MARK_RAN.toString());
        DBMSPrecondition dbmsPrecondition = new DBMSPrecondition();
        dbmsPrecondition.setType("oracle");
        preCondition.addNestedPrecondition((Precondition)dbmsPrecondition);
        this.changeSet1.setPreconditions(preCondition);
        OracleDatabase oracleDb = new OracleDatabase(){

            public List<RanChangeSet> getRanChangeSetList() throws DatabaseException {
                return new ArrayList<RanChangeSet>();
            }

            public void rollback() throws DatabaseException {
            }
        };
        String[] empty = new String[]{};
        boolean exceptionThrown = false;
        try {
            this.changeLog.validate((Database)oracleDb, empty);
        }
        catch (LiquibaseException ex) {
            exceptionThrown = true;
        }
        Assert.assertFalse((boolean)exceptionThrown);
    }

    @Test
    public void testPreConditionsForOracleOnMSSQLWithPreconditionTag() {
        PreconditionContainer preCondition = new PreconditionContainer();
        preCondition.setOnFail(PreconditionContainer.FailOption.MARK_RAN.toString());
        DBMSPrecondition dbmsPrecondition = new DBMSPrecondition();
        dbmsPrecondition.setType("oracle");
        preCondition.addNestedPrecondition((Precondition)dbmsPrecondition);
        this.changeSet1.setPreconditions(preCondition);
        MSSQLDatabase mssqlDb = new MSSQLDatabase(){

            public List<RanChangeSet> getRanChangeSetList() throws DatabaseException {
                return new ArrayList<RanChangeSet>();
            }

            public void rollback() throws DatabaseException {
            }
        };
        boolean failedExceptionThrown = false;
        boolean errorExceptionThrown = false;
        try {
            preCondition.check((Database)mssqlDb, this.changeLog, this.changeSet1, null);
        }
        catch (PreconditionFailedException ex) {
            failedExceptionThrown = true;
        }
        catch (PreconditionErrorException ex) {
            errorExceptionThrown = true;
        }
        Assert.assertTrue((boolean)failedExceptionThrown);
        Assert.assertFalse((boolean)errorExceptionThrown);
    }

    @Test
    public void testPreConditionsForOracleOnMSSQLWithChangeLog() {
        PreconditionContainer preCondition = new PreconditionContainer();
        preCondition.setOnFail(PreconditionContainer.FailOption.MARK_RAN.toString());
        DBMSPrecondition dbmsPrecondition = new DBMSPrecondition();
        dbmsPrecondition.setType("oracle");
        preCondition.addNestedPrecondition((Precondition)dbmsPrecondition);
        this.changeSet1.setPreconditions(preCondition);
        MSSQLDatabase mssqlDb = new MSSQLDatabase(){

            public List<RanChangeSet> getRanChangeSetList() throws DatabaseException {
                return new ArrayList<RanChangeSet>();
            }

            public void rollback() throws DatabaseException {
            }
        };
        String[] empty = new String[]{};
        boolean exceptionThrown = false;
        try {
            this.changeLog.validate((Database)mssqlDb, empty);
        }
        catch (LiquibaseException ex) {
            System.out.println(ex.getMessage());
            exceptionThrown = true;
        }
        Assert.assertFalse((boolean)exceptionThrown);
    }
}

