/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.util.ArrayList;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.sdk.executor.MockExecutor;
import liquibase.sql.visitor.AppendSqlVisitor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.structure.core.Table;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractJdbcDatabaseTest {
    protected AbstractJdbcDatabase database;

    protected AbstractJdbcDatabaseTest(AbstractJdbcDatabase database) throws Exception {
        this.database = database;
    }

    public AbstractJdbcDatabase getDatabase() {
        return this.database;
    }

    protected abstract String getProductNameString();

    public abstract void supportsInitiallyDeferrableColumns();

    public abstract void getCurrentDateTimeFunction();

    @Test
    public void defaultsWorkWithoutAConnection() {
        this.database.getDatabaseProductName();
        this.database.getDefaultCatalogName();
        this.database.getDefaultSchemaName();
        this.database.getDefaultPort();
    }

    @Test
    public void escapeTableName_noSchema() throws DatabaseException {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Test
    public void escapeTableName_withSchema() throws DatabaseException {
        AbstractJdbcDatabase database = this.getDatabase();
        if (database.supportsCatalogInObjectName(Table.class)) {
            Assert.assertEquals((Object)"catalogName.schemaName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
        } else {
            Assert.assertEquals((Object)"schemaName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
        }
    }

    @Test
    public void executeRollbackStatements_WithStatementsOverload_ShouldNotIncludeAppendTextFromApplyToRollbackFalseVisitor() throws Exception {
        AbstractJdbcDatabase database = this.getDatabase();
        MockExecutor mockExecutor = new MockExecutor();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)mockExecutor);
        ArrayList<AppendSqlVisitor> sqlVisitors = new ArrayList<AppendSqlVisitor>();
        DropTableStatement dropTableStatement = new DropTableStatement(null, null, "test_table", false);
        AppendSqlVisitor appendSqlVisitor = new AppendSqlVisitor();
        appendSqlVisitor.setApplyToRollback(false);
        appendSqlVisitor.setValue(" SHOULD NOT BE APPENDED");
        sqlVisitors.add(appendSqlVisitor);
        database.executeRollbackStatements(new SqlStatement[]{dropTableStatement}, sqlVisitors);
        Assert.assertEquals((Object)"DROP TABLE test_table;", (Object)mockExecutor.getRanSql().trim());
    }

    @Test
    public void executeRollbackStatements_WithStatementsOverload_ShouldIncludeAppendTextFromApplyToRollbackTrueVisitor() throws Exception {
        AbstractJdbcDatabase database = this.getDatabase();
        MockExecutor mockExecutor = new MockExecutor();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)mockExecutor);
        ArrayList<AppendSqlVisitor> sqlVisitors = new ArrayList<AppendSqlVisitor>();
        DropTableStatement dropTableStatement = new DropTableStatement(null, null, "test_table", false);
        AppendSqlVisitor appendSqlVisitor = new AppendSqlVisitor();
        appendSqlVisitor.setApplyToRollback(true);
        appendSqlVisitor.setValue(" SHOULD BE APPENDED");
        sqlVisitors.add(appendSqlVisitor);
        database.executeRollbackStatements(new SqlStatement[]{dropTableStatement}, sqlVisitors);
        Assert.assertEquals((Object)"DROP TABLE test_table SHOULD BE APPENDED;", (Object)mockExecutor.getRanSql().trim());
    }

    @Test
    public void executeRollbackStatements_WithChangeOverload_ShouldNotIncludeAppendTextFromApplyToRollbackFalseVisitor() throws Exception {
        AbstractJdbcDatabase database = this.getDatabase();
        MockExecutor mockExecutor = new MockExecutor();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)mockExecutor);
        ArrayList<AppendSqlVisitor> sqlVisitors = new ArrayList<AppendSqlVisitor>();
        CreateTableChange change = new CreateTableChange();
        change.setTableName("test_table");
        AppendSqlVisitor appendSqlVisitor = new AppendSqlVisitor();
        appendSqlVisitor.setApplyToRollback(false);
        appendSqlVisitor.setValue(" SHOULD NOT BE APPENDED");
        sqlVisitors.add(appendSqlVisitor);
        database.executeRollbackStatements((Change)change, sqlVisitors);
        Assert.assertEquals((Object)"DROP TABLE test_table;", (Object)mockExecutor.getRanSql().trim());
    }

    @Test
    public void executeRollbackStatements_WithChangeOverload_ShouldIncludeAppendTextFromApplyToRollbackTrueVisitor() throws Exception {
        AbstractJdbcDatabase database = this.getDatabase();
        MockExecutor mockExecutor = new MockExecutor();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)mockExecutor);
        ArrayList<AppendSqlVisitor> sqlVisitors = new ArrayList<AppendSqlVisitor>();
        CreateTableChange change = new CreateTableChange();
        change.setTableName("test_table");
        AppendSqlVisitor appendSqlVisitor = new AppendSqlVisitor();
        appendSqlVisitor.setApplyToRollback(true);
        appendSqlVisitor.setValue(" SHOULD BE APPENDED");
        sqlVisitors.add(appendSqlVisitor);
        database.executeRollbackStatements((Change)change, sqlVisitors);
        Assert.assertEquals((Object)"DROP TABLE test_table SHOULD BE APPENDED;", (Object)mockExecutor.getRanSql().trim());
    }

    @Test
    public void test_isDateOnly() {
        Assert.assertTrue((boolean)this.database.isDateOnly("2018-01-01"));
        Assert.assertFalse((boolean)this.database.isDateOnly("18-01-01"));
        Assert.assertFalse((boolean)this.database.isDateOnly("2018-1-1"));
        Assert.assertTrue((boolean)this.database.isDateOnly("now"));
        Assert.assertTrue((boolean)this.database.isDateOnly("now+1year"));
        Assert.assertTrue((boolean)this.database.isDateOnly("now+1day"));
        Assert.assertTrue((boolean)this.database.isDateOnly("now-11hours"));
        Assert.assertTrue((boolean)this.database.isDateOnly("now+111minutes"));
        Assert.assertTrue((boolean)this.database.isDateOnly("today"));
        Assert.assertTrue((boolean)this.database.isDateOnly("today+2"));
        Assert.assertTrue((boolean)this.database.isDateOnly("today-1"));
        Assert.assertTrue((boolean)this.database.isDateOnly("TODAY"));
        Assert.assertFalse((boolean)this.database.isDateOnly("NO"));
        Assert.assertFalse((boolean)this.database.isDateOnly("TODA"));
    }

    @Test
    public void test_isDateTime() {
        Assert.assertTrue((boolean)this.database.isDateTime("2018-01-01 10:11:12"));
        Assert.assertTrue((boolean)this.database.isDateTime("2018-01-01 10:11:12.2"));
        Assert.assertTrue((boolean)this.database.isDateTime("2018-01-01T10:11:12"));
        Assert.assertTrue((boolean)this.database.isDateTime("2018-01-01T10:11:12.2"));
        Assert.assertFalse((boolean)this.database.isDateTime("18-01-01T10:11:12.2"));
        Assert.assertFalse((boolean)this.database.isDateTime("2018-01-01"));
        Assert.assertTrue((boolean)this.database.isDateTime("now"));
        Assert.assertTrue((boolean)this.database.isDateTime("now+1year"));
        Assert.assertTrue((boolean)this.database.isDateTime("now+1day"));
        Assert.assertTrue((boolean)this.database.isDateTime("now-11hours"));
        Assert.assertTrue((boolean)this.database.isDateTime("now+111minutes"));
        Assert.assertTrue((boolean)this.database.isDateTime("today"));
        Assert.assertTrue((boolean)this.database.isDateTime("today+2"));
        Assert.assertTrue((boolean)this.database.isDateTime("today-2"));
        Assert.assertTrue((boolean)this.database.isDateTime("TODAY"));
        Assert.assertFalse((boolean)this.database.isDateTime("NO"));
        Assert.assertFalse((boolean)this.database.isDateTime("TODA"));
    }

    @Test
    public void test_isTimestamp() {
        Assert.assertTrue((boolean)this.database.isTimestamp("2018-01-01T10:11:12.2"));
        Assert.assertFalse((boolean)this.database.isTimestamp("2018-01-01T10:11:12"));
        Assert.assertFalse((boolean)this.database.isTimestamp("2018-01-01 10:11:12.2"));
        Assert.assertFalse((boolean)this.database.isTimestamp("18-01-01T10:11:12.2"));
        Assert.assertFalse((boolean)this.database.isTimestamp("2018-01-01"));
        Assert.assertTrue((boolean)this.database.isTimestamp("now"));
        Assert.assertTrue((boolean)this.database.isTimestamp("now+1year"));
        Assert.assertTrue((boolean)this.database.isTimestamp("now+1day"));
        Assert.assertTrue((boolean)this.database.isTimestamp("now-11hours"));
        Assert.assertTrue((boolean)this.database.isTimestamp("now+111minutes"));
        Assert.assertTrue((boolean)this.database.isTimestamp("today"));
        Assert.assertTrue((boolean)this.database.isTimestamp("today+2"));
        Assert.assertTrue((boolean)this.database.isTimestamp("today-2"));
        Assert.assertTrue((boolean)this.database.isTimestamp("TODAY"));
        Assert.assertFalse((boolean)this.database.isTimestamp("NO"));
        Assert.assertFalse((boolean)this.database.isTimestamp("TODA"));
    }

    @Test
    public void test_isTimeOnly() {
        Assert.assertTrue((boolean)this.database.isTimeOnly("10:11:12"));
        Assert.assertFalse((boolean)this.database.isTimeOnly("2018-01-01 10:11:12"));
        Assert.assertFalse((boolean)this.database.isTimeOnly("2018-01-01T10:11:12"));
        Assert.assertFalse((boolean)this.database.isTimeOnly("10:11:12.2"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("now"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("now+1year"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("now+1day"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("now-11hours"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("now+111minutes"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("today"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("today+2"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("today-2"));
        Assert.assertTrue((boolean)this.database.isTimeOnly("TODAY"));
        Assert.assertFalse((boolean)this.database.isTimeOnly("NO"));
        Assert.assertFalse((boolean)this.database.isTimeOnly("TODA"));
    }

    @Test
    public void test_escapeObjectName() {
        String tableName = this.database.escapeObjectName("My Table  ", Table.class);
        Assert.assertTrue((boolean)tableName.matches("[\\[\\\"`]?My Table  [\\]\\\"`]?"));
        tableName = this.database.escapeObjectName("MyTable", Table.class);
        Assert.assertEquals((Object)"MyTable", (Object)tableName);
        tableName = this.database.escapeObjectName("My Table", Table.class);
        Assert.assertTrue((boolean)tableName.matches("[\\[\\\"`]?My Table[\\]\\\"`]?"));
    }
}

