/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import liquibase.database.ConnectionServiceFactory;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ConnectionServiceFactoryTest {
    private String mockUrl = "mock://url";
    private ConnectionServiceFactory connectionServiceFactory;

    @Before
    public void setUp() {
        ConnectionServiceFactory.reset();
        this.connectionServiceFactory = ConnectionServiceFactory.getInstance();
    }

    @Test
    public void testGetDatabaseConnection() {
        Assertions.assertThat((Object)this.connectionServiceFactory.getDatabaseConnection(this.mockUrl)).isInstanceOf(JdbcConnection.class);
        JdbcConnection100SupportsDriver jdbcConnection100SupportsDriver = new JdbcConnection100SupportsDriver();
        this.connectionServiceFactory.register((DatabaseConnection)jdbcConnection100SupportsDriver);
        Assertions.assertThat((Object)this.connectionServiceFactory.getDatabaseConnection(this.mockUrl)).isInstanceOf(JdbcConnection100SupportsDriver.class);
        JdbcConnection200DoesNotSupportDriver jdbcConnection200DoesNotSupportDriver = new JdbcConnection200DoesNotSupportDriver();
        this.connectionServiceFactory.register((DatabaseConnection)jdbcConnection200DoesNotSupportDriver);
        Assertions.assertThat((Object)this.connectionServiceFactory.getDatabaseConnection(this.mockUrl)).isInstanceOf(JdbcConnection100SupportsDriver.class);
        JdbcConnection50SupportsDriver jdbcConnection50SupportsDriver = new JdbcConnection50SupportsDriver();
        this.connectionServiceFactory.register((DatabaseConnection)jdbcConnection50SupportsDriver);
        Assertions.assertThat((Object)this.connectionServiceFactory.getDatabaseConnection(this.mockUrl)).isInstanceOf(JdbcConnection100SupportsDriver.class);
    }

    private static class JdbcConnection200DoesNotSupportDriver
    extends JdbcConnection {
        private JdbcConnection200DoesNotSupportDriver() {
        }

        public int getPriority() {
            return 200;
        }

        public boolean supports(String url) {
            return false;
        }
    }

    private static class JdbcConnection100SupportsDriver
    extends JdbcConnection {
        private JdbcConnection100SupportsDriver() {
        }

        public int getPriority() {
            return 100;
        }

        public boolean supports(String url) {
            return true;
        }
    }

    private static class JdbcConnection50SupportsDriver
    extends JdbcConnection {
        private JdbcConnection50SupportsDriver() {
        }

        public int getPriority() {
            return 50;
        }

        public boolean supports(String url) {
            return true;
        }
    }
}

