/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.File;
import java.io.FileWriter;
import java.util.Properties;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ResourceAccessor;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class DatabaseFactoryTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ResourceAccessor resourceAccessor;
    private DatabaseFactory databaseFactory;

    @Before
    public void setUp() {
        this.resourceAccessor = (ResourceAccessor)Mockito.mock(ResourceAccessor.class);
        DatabaseFactory.reset();
        this.databaseFactory = DatabaseFactory.getInstance();
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)DatabaseFactory.getInstance());
    }

    @Test
    public void openConnectionReturnsOfflineConnectionWhenUrlPrefixMatches() throws Exception {
        String username = "sa";
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("offline:h2?param1=value1&aparam2=value2", username, "", null, this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.instanceOf(OfflineConnection.class));
        Assert.assertThat((Object)dbConnection.getConnectionUserName(), (Matcher)Matchers.equalTo((Object)username));
    }

    @Test
    public void openConnectionUsesDriverArgument() throws Exception {
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", "org.h2.Driver", null, null, null, this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection.getDatabaseProductName(), (Matcher)Matchers.equalTo((Object)"H2"));
    }

    @Test
    public void openConnectionThrowsExceptionWhenDriverCannotBeFoundByUrl() throws Exception {
        this.expectedException.expect(Matchers.instanceOf(DatabaseException.class));
        this.expectedException.expectCause(Matchers.instanceOf(RuntimeException.class));
        this.expectedException.expectMessage(Matchers.containsString((String)"Driver class was not specified and could not be determined from the url"));
        this.databaseFactory.openConnection("not:a:driver", "", "", null, this.resourceAccessor);
    }

    @Test
    public void openConnectionLoadsGivenDatabaseClass() throws Exception {
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", null, "liquibase.database.core.H2Database", null, null, this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection.getDatabaseProductName(), (Matcher)Matchers.equalTo((Object)"H2"));
    }

    @Test
    public void openConnectionLoadsDriverPropertiesFromGivenFile() throws Exception {
        File propsFile = this.temporaryFolder.newFile("db-factory-test-connection-props.properties");
        Properties expectedProps = new Properties();
        expectedProps.setProperty("param1", "value1");
        expectedProps.setProperty("param2", "value2");
        try (FileWriter writer = new FileWriter(propsFile);){
            expectedProps.store(writer, "connection properties");
        }
        String propsFilePath = propsFile.getAbsolutePath();
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", null, null, propsFilePath, null, this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection.getDatabaseProductName(), (Matcher)Matchers.equalTo((Object)"H2"));
    }

    @Test
    public void openConnectionCreatesCustomPropertyProviderClassWhenGiven() throws Exception {
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", "liquibase.database.DatabaseFactoryTest$CustomProperties", this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection.getDatabaseProductName(), (Matcher)Matchers.equalTo((Object)"H2"));
    }

    @Test
    public void openConnectionThrowsRuntimeExceptionWhenDriverPropertiesFileNotFound() throws Exception {
        this.expectedException.expect(Matchers.instanceOf(DatabaseException.class));
        this.expectedException.expectCause(Matchers.instanceOf(RuntimeException.class));
        this.expectedException.expectMessage(Matchers.containsString((String)"Can't open JDBC Driver specific properties from the file"));
        this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", null, null, "unknown file", null, this.resourceAccessor);
    }

    @Test
    public void openConnectionReturnsAConnection() throws Exception {
        DatabaseConnection dbConnection = this.databaseFactory.openConnection("jdbc:h2:mem:DatabaseFactoryTest", "sa", "", null, this.resourceAccessor);
        Assert.assertThat((Object)dbConnection, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)dbConnection.getDatabaseProductName(), (Matcher)Matchers.equalTo((Object)"H2"));
    }

    private static class CustomProperties
    extends Properties {
    }
}

