/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.core.H2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseListTest {
    @Test
    public void databaseMatchesDbmsDefinition() {
        Assert.assertTrue((String)"'all' should match any database", (boolean)DatabaseList.definitionMatches((String)"all", (Database)new MySQLDatabase(), (boolean)false));
        Assert.assertTrue((String)"'all' should match any database, even when others are added", (boolean)DatabaseList.definitionMatches((String)"all, oracle", (Database)new MySQLDatabase(), (boolean)false));
        Assert.assertFalse((String)"'none' should not match any database", (boolean)DatabaseList.definitionMatches((String)"none", (Database)new MySQLDatabase(), (boolean)false));
        Assert.assertFalse((String)"'none' should not match any database, even when others are added", (boolean)DatabaseList.definitionMatches((String)"none, oracle", (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"", (Database)new OracleDatabase(), (boolean)true));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"", (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)null, (Database)new OracleDatabase(), (boolean)true));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)null, (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"   ", (Database)new OracleDatabase(), (boolean)true));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"   ", (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"oracle", (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"oracle,mysql,mssql", (Database)new OracleDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"oracle,mysql,mssql", (Database)new MySQLDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"oracle,mysql,mssql", (Database)new MSSQLDatabase(), (boolean)false));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"oracle,mysql,mssql", (Database)new H2Database(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"!h2", (Database)new MySQLDatabase(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"!h2", (Database)new MySQLDatabase(), (boolean)true));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"!h2", (Database)new H2Database(), (boolean)false));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"!h2", (Database)new H2Database(), (boolean)true));
        Assert.assertFalse((boolean)DatabaseList.definitionMatches((String)"!h2,mysql", (Database)new H2Database(), (boolean)false));
        Assert.assertTrue((boolean)DatabaseList.definitionMatches((String)"!h2,mysql", (Database)new MySQLDatabase(), (boolean)false));
    }
}

