/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import junit.framework.TestCase;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DerbyDatabaseTest
extends TestCase {
    public void testGetDefaultDriver() throws DatabaseException {
        try (DerbyDatabase database = new DerbyDatabase();){
            DerbyDatabaseTest.assertEquals((String)"org.apache.derby.jdbc.EmbeddedDriver", (String)database.getDefaultDriver("java:derby:liquibase;create=true"));
            DerbyDatabaseTest.assertNull((Object)database.getDefaultDriver("jdbc:oracle://localhost;databaseName=liquibase"));
        }
    }

    public void testGetDateLiteral() {
        DerbyDatabaseTest.assertEquals((String)"TIMESTAMP('2008-01-25 13:57:41')", (String)new DerbyDatabase().getDateLiteral("2008-01-25 13:57:41"));
        DerbyDatabaseTest.assertEquals((String)"TIMESTAMP('2008-01-25 13:57:41.300000')", (String)new DerbyDatabase().getDateLiteral("2008-01-25 13:57:41.3"));
        DerbyDatabaseTest.assertEquals((String)"TIMESTAMP('2008-01-25 13:57:41.340000')", (String)new DerbyDatabase().getDateLiteral("2008-01-25 13:57:41.34"));
        DerbyDatabaseTest.assertEquals((String)"TIMESTAMP('2008-01-25 13:57:41.347000')", (String)new DerbyDatabase().getDateLiteral("2008-01-25 13:57:41.347"));
    }

    public void testCloseShutsEmbeddedDerbyDown() throws Exception {
        Connection con = DerbyDatabaseTest.mockConnection();
        DerbyDatabase database = DerbyDatabaseTest.spyDatabase(con);
        database.close();
        ((DerbyDatabase)Mockito.verify((Object)database)).shutdownDerby(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((Connection)Mockito.verify((Object)con)).close();
    }

    public void testCloseDoesNotShutEmbeddedDerbyDown() throws Exception {
        Connection con = DerbyDatabaseTest.mockConnection();
        DerbyDatabase database = DerbyDatabaseTest.spyDatabase(con);
        database.setShutdownEmbeddedDerby(false);
        database.close();
        ((DerbyDatabase)Mockito.verify((Object)database, (VerificationMode)Mockito.never())).shutdownDerby(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((Connection)Mockito.verify((Object)con)).close();
    }

    private static DerbyDatabase spyDatabase(Connection con) throws DatabaseException {
        DerbyDatabase database = (DerbyDatabase)Mockito.spy((Object)new DerbyDatabase());
        ((DerbyDatabase)Mockito.doNothing().when((Object)database)).shutdownDerby(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        database.setConnection((DatabaseConnection)new JdbcConnection(con));
        return database;
    }

    private static Connection mockConnection() throws SQLException {
        Connection con = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        Mockito.when((Object)metaData.getURL()).thenReturn((Object)"jdbc:derby:memory:foo");
        Mockito.when((Object)metaData.getDriverName()).thenReturn((Object)"org.apache.derby.jdbc.EmbeddedDriver");
        Mockito.when((Object)con.getMetaData()).thenReturn((Object)metaData);
        return con;
    }
}

