/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.core.H2Database;
import org.junit.Assert;
import org.junit.Test;

public class H2DatabaseTest
extends AbstractJdbcDatabaseTest {
    public H2DatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new H2Database());
    }

    @Override
    protected String getProductNameString() {
        return "H2";
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void testGetDefaultDriver() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"org.h2.Driver", (Object)database.getDefaultDriver("jdbc:h2:mem:liquibase"));
        Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }

    @Override
    @Test
    public void escapeTableName_noSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Override
    @Test
    public void escapeTableName_withSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"schemaName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
    }
}

