/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import org.junit.Assert;
import org.junit.Test;

public class MSSQLDatabaseTest
extends AbstractJdbcDatabaseTest {
    public MSSQLDatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new MSSQLDatabase());
    }

    @Override
    protected String getProductNameString() {
        return "Microsoft SQL Server";
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"GETDATE()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void getDefaultDriver() throws DatabaseException {
        try (MSSQLDatabase database = new MSSQLDatabase();){
            Assert.assertEquals((Object)"com.microsoft.sqlserver.jdbc.SQLServerDriver", (Object)database.getDefaultDriver("jdbc:sqlserver://localhost;databaseName=liquibase"));
            Assert.assertNull((Object)database.getDefaultDriver("jdbc:oracle:thin://localhost;databaseName=liquibase"));
        }
    }

    @Override
    @Test
    public void escapeTableName_noSchema() throws DatabaseException {
        try (MSSQLDatabase database = new MSSQLDatabase();){
            Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
            Assert.assertEquals((Object)"[tableName\u20ac]", (Object)database.escapeTableName(null, null, "tableName\u20ac"));
        }
    }

    @Override
    @Test
    public void escapeTableName_withSchema() throws DatabaseException {
        try (MSSQLDatabase database = new MSSQLDatabase();){
            Assert.assertEquals((Object)"catalogName.schemaName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
            Assert.assertEquals((Object)"[catalogName\u20ac].[schemaName\u20ac].[tableName\u20ac]", (Object)database.escapeTableName("catalogName\u20ac", "schemaName\u20ac", "tableName\u20ac"));
        }
    }

    private Database createOfflineDatabase(String url) throws Exception {
        return DatabaseFactory.getInstance().openDatabase(url, null, null, null, null);
    }

    @Test
    public void setDefaultSchemaName() throws Exception {
        Database database = this.createOfflineDatabase("offline:mssql");
        database.setDefaultSchemaName("MySchema");
    }

    @Test
    public void isUnmodifiable() throws Exception {
        Database database = this.createOfflineDatabase("offline:mssql");
        Assert.assertTrue((boolean)(database instanceof MSSQLDatabase));
        MSSQLDatabase mssqlDatabase = (MSSQLDatabase)database;
        Assert.assertTrue((boolean)mssqlDatabase.dataTypeIsNotModifiable("datetime"));
    }

    @Test
    public void testEscapeDataTypeName() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"MySchema.MyUDT", (Object)database.escapeDataTypeName("MySchema.MyUDT"));
        Assert.assertEquals((Object)"[MySchema\u20ac].[MyUDT\u20ac]", (Object)database.escapeDataTypeName("MySchema\u20ac.MyUDT\u20ac"));
        Assert.assertEquals((Object)"MySchema.[MyUDT]", (Object)database.escapeDataTypeName("MySchema.[MyUDT]"));
        Assert.assertEquals((Object)"[MySchema].MyUDT", (Object)database.escapeDataTypeName("[MySchema].MyUDT"));
        Assert.assertEquals((Object)"[MySchema].[MyUDT]", (Object)database.escapeDataTypeName("[MySchema].[MyUDT]"));
    }

    @Test
    public void testUnescapeDataTypeName() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"MySchema.MyUDT", (Object)database.unescapeDataTypeName("MySchema.MyUDT"));
        Assert.assertEquals((Object)"MySchema.MyUDT", (Object)database.unescapeDataTypeName("MySchema.[MyUDT]"));
        Assert.assertEquals((Object)"MySchema.MyUDT", (Object)database.unescapeDataTypeName("[MySchema].MyUDT"));
        Assert.assertEquals((Object)"MySchema.MyUDT", (Object)database.unescapeDataTypeName("[MySchema].[MyUDT]"));
    }

    @Test
    public void testUnescapeDataTypeString() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"int", (Object)database.unescapeDataTypeString("int"));
        Assert.assertEquals((Object)"int", (Object)database.unescapeDataTypeString("[int]"));
        Assert.assertEquals((Object)"decimal(19, 2)", (Object)database.unescapeDataTypeString("decimal(19, 2)"));
        Assert.assertEquals((Object)"decimal(19, 2)", (Object)database.unescapeDataTypeString("[decimal](19, 2)"));
    }
}

