/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.core.MariaDBDatabase;
import org.junit.Assert;
import org.junit.Test;

public class MariaDBDatabaseTest
extends AbstractJdbcDatabaseTest {
    public MariaDBDatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new MariaDBDatabase());
    }

    @Override
    protected String getProductNameString() {
        return "MariaDB";
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void testGetDefaultDriver() {
        Assert.assertEquals((Object)"org.mariadb.jdbc.Driver", (Object)this.database.getDefaultDriver("jdbc:mariadb://localhost/liquibase"));
        Assert.assertNull((Object)this.database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
    }

    @Override
    @Test
    public void escapeTableName_noSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Override
    @Test
    public void escapeTableName_withSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"catalogName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
    }

    @Test
    public void escapeStringForDatabase_withBackslashes() {
        Assert.assertEquals((Object)"\\\\0", (Object)this.database.escapeStringForDatabase("\\0"));
    }
}

