/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;
import org.junit.Assert;
import org.junit.Test;

public class MySQLDatabaseTest
extends AbstractJdbcDatabaseTest {
    public MySQLDatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new MySQLDatabase());
    }

    @Override
    protected String getProductNameString() {
        return "MySQL";
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertFalse((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void getCurrentDateTimeFunctionWithPrecision() {
        MySQLDatabase mySQLDatabase = (MySQLDatabase)this.getDatabase();
        Assert.assertEquals((Object)"NOW(1)", (Object)mySQLDatabase.getCurrentDateTimeFunction(1));
        Assert.assertEquals((Object)"NOW(2)", (Object)mySQLDatabase.getCurrentDateTimeFunction(2));
        Assert.assertEquals((Object)"NOW(5)", (Object)mySQLDatabase.getCurrentDateTimeFunction(5));
    }

    @Test
    public void generateDatabaseFunctionValue() {
        MySQLDatabase mySQLDatabase = (MySQLDatabase)this.getDatabase();
        Assert.assertEquals((Object)"NOW()", (Object)mySQLDatabase.generateDatabaseFunctionValue(new DatabaseFunction("CURRENT_TIMESTAMP()")));
        Assert.assertNull((Object)mySQLDatabase.generateDatabaseFunctionValue(new DatabaseFunction(null)));
    }

    @Test
    public void generateDatabaseFunctionValueWithPrecision() {
        MySQLDatabase mySQLDatabase = (MySQLDatabase)this.getDatabase();
        Assert.assertEquals((Object)"NOW(2)", (Object)mySQLDatabase.generateDatabaseFunctionValue(new DatabaseFunction("CURRENT_TIMESTAMP(2)")));
        Assert.assertEquals((Object)"NOW(3)", (Object)mySQLDatabase.generateDatabaseFunctionValue(new DatabaseFunction("CURRENT_TIMESTAMP(3)")));
    }

    @Test
    public void generateDatabaseFunctionValueWithIncorrectPrecision() {
        MySQLDatabase mySQLDatabase = (MySQLDatabase)this.getDatabase();
        Assert.assertEquals((Object)"NOW()", (Object)mySQLDatabase.generateDatabaseFunctionValue(new DatabaseFunction("CURRENT_TIMESTAMP(string)")));
    }

    public void testGetDefaultDriver() throws DatabaseException {
        try (MySQLDatabase database = new MySQLDatabase();){
            Assert.assertEquals((Object)"com.mysql.cj.jdbc.Driver", (Object)database.getDefaultDriver("jdbc:mysql://localhost/liquibase"));
            Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
        }
    }

    @Override
    @Test
    public void escapeTableName_noSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Override
    @Test
    public void escapeTableName_withSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"catalogName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
    }

    @Test
    public void escapeStringForDatabase_withBackslashes() {
        Assert.assertEquals((Object)"\\\\0", (Object)this.database.escapeStringForDatabase("\\0"));
    }
}

