/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.change.AddColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.OfflineConnection;
import liquibase.exception.DatabaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddColumnStatement;
import liquibase.test.JUnitResourceAccessor;
import org.junit.Assert;
import org.junit.Test;

public class OfflineDatabaseTest {
    private Database createOfflineDatabase(String url) throws Exception {
        OfflineConnection databaseConnection = new OfflineConnection(url, (ResourceAccessor)new JUnitResourceAccessor());
        return DatabaseFactory.getInstance().openDatabase(url, null, null, null, null);
    }

    @Test
    public void canOutputSQLFromOfflineOracleDB() throws Exception {
        AddColumnChange change = new AddColumnChange();
        AddColumnConfig column1 = new AddColumnConfig();
        column1.setName("column1");
        column1.setType("INT");
        change.addColumn(column1);
        AddColumnConfig column2 = new AddColumnConfig();
        column2.setName("column2");
        column2.setType("INT");
        change.addColumn(column2);
        SqlStatement[] statements = new SqlStatement[]{};
        try {
            statements = change.generateStatements(this.createOfflineDatabase("offline:oracle"));
        }
        catch (DatabaseException e) {
            Assert.fail((String)"Can't generate statements from an Offline Oracle database.");
        }
        Assert.assertEquals((long)1L, (long)statements.length);
        Assert.assertTrue((boolean)(statements[0] instanceof AddColumnStatement));
        AddColumnStatement stmt = (AddColumnStatement)statements[0];
        Assert.assertTrue((boolean)stmt.isMultiple());
        Assert.assertEquals((long)2L, (long)stmt.getColumns().size());
    }
}

