/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.ArrayList;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.OfflineConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.TimestampType;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.resource.ResourceAccessor;
import liquibase.sdk.executor.MockExecutor;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.test.JUnitResourceAccessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OracleDatabaseTest
extends AbstractJdbcDatabaseTest {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");

    public OracleDatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new OracleDatabase());
    }

    @Override
    protected String getProductNameString() {
        return "Oracle";
    }

    @Override
    @Test
    public void escapeTableName_noSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((String)"table name without schema is correctly escaped as simply tableName", (Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Test
    public void saveNlsEnvironment() throws Exception {
        AbstractJdbcDatabase database = this.getDatabase();
        JUnitResourceAccessor junitResourceAccessor = new JUnitResourceAccessor();
        OfflineConnection offlineConnection = new OfflineConnection("offline:oracle", (ResourceAccessor)junitResourceAccessor);
        database.setConnection((DatabaseConnection)offlineConnection);
    }

    @Override
    @Test
    public void escapeTableName_withSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((String)"table name without schema but with catalog is correctly escaped as catalogName.tableName", (Object)"catalogName.tableName", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertTrue((String)"Oracle Database is correctly reported as being able to do INITIALLY DEFERRED column constraints.", (boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((String)"Oracle Database's 'give me the current timestamp' function is correctly reported.", (Object)"SYSTIMESTAMP", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void verifyTimestampDataTypeWhenWithoutClauseIsPresent() {
        TimestampType ts = new TimestampType();
        ts.setAdditionalInformation("WITHOUT TIME ZONE");
        DatabaseDataType oracleDataType = ts.toDatabaseDataType((Database)this.getDatabase());
        Assert.assertThat((Object)oracleDataType.getType(), (Matcher)CoreMatchers.is((Object)"TIMESTAMP"));
    }

    public void testGetDefaultDriver() throws DatabaseException {
        try (OracleDatabase database = new OracleDatabase();){
            Assert.assertEquals((String)"The correct JDBC driver class name is reported if the URL is a Oracle JDBC URL", (Object)"oracle.jdbc.OracleDriver", (Object)database.getDefaultDriver("jdbc:oracle:thin:@localhost/XE"));
            Assert.assertNull((String)"No JDBC driver class is returned if the URL is NOT an Oracle Database JDBC URL.", (Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
        }
    }

    @Test
    public void validateCore2953WrongSqlOnValueSequenceNext() throws LiquibaseException {
        AbstractJdbcDatabase database = this.getDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
        database.setDefaultSchemaName("sampleschema");
        MockExecutor mockExecutor = new MockExecutor();
        mockExecutor.setDatabase((Database)database);
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", (Database)database, (Executor)mockExecutor);
        UpdateStatement updateStatement = new UpdateStatement(null, null, "test_table");
        updateStatement.addNewColumnValue("id", (Object)new SequenceNextValueFunction("test_table_id_seq"));
        database.execute(new SqlStatement[]{updateStatement}, new ArrayList());
        Assert.assertEquals((Object)"UPDATE \"SAMPLESCHEMA\".\"test_table\" SET \"id\" = \"SAMPLESCHEMA\".\"test_table_id_seq\".nextval;", (Object)mockExecutor.getRanSql().trim());
    }

    @Test
    public void getDateLiteral_date() {
        Assert.assertEquals((Object)"TO_DATE('2017-08-16 16:32:55', 'YYYY-MM-DD HH24:MI:SS')", (Object)this.database.getDateLiteral("2017-08-16T16:32:55"));
    }

    @Test
    public void getDateLiteral_dateOnly() {
        Assert.assertEquals((Object)"TO_DATE('2017-08-16', 'YYYY-MM-DD')", (Object)this.database.getDateLiteral("2017-08-16"));
    }

    @Test
    public void getDateLiteral_timeOnly() {
        Assert.assertEquals((Object)"TO_DATE('16:32:55', 'HH24:MI:SS')", (Object)this.database.getDateLiteral("16:32:55"));
    }

    @Test
    public void getDateLiteral_timestamp() {
        Assert.assertEquals((Object)"TO_TIMESTAMP('2017-08-16 16:32:55.125', 'YYYY-MM-DD HH24:MI:SS.FF')", (Object)this.database.getDateLiteral("2017-08-16T16:32:55.125"));
    }

    @Test
    public void getDateLiteral_datetime() {
        Assert.assertEquals((Object)"TO_TIMESTAMP('2017-08-16 16:32:55.3', 'YYYY-MM-DD HH24:MI:SS.FF')", (Object)this.database.getDateLiteral("2017-08-16T16:32:55.3"));
    }

    @Test
    public void getDateLiteral_datetime_invalid() {
        Assert.assertEquals((Object)"UNSUPPORTED:2017-08-16T16:32:55_3", (Object)this.database.getDateLiteral("2017-08-16T16:32:55_3"));
    }

    @Test
    public void getDateLiteral_unsupported() {
        Assert.assertEquals((Object)"UNSUPPORTED:123", (Object)this.database.getDateLiteral("123"));
    }
}

