/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.nio.charset.Charset;
import liquibase.GlobalConfiguration;
import liquibase.changelog.column.LiquibaseColumn;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.AbstractJdbcDatabaseTest;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class PostgresDatabaseTest
extends AbstractJdbcDatabaseTest {
    public PostgresDatabaseTest() throws Exception {
        super((AbstractJdbcDatabase)new PostgresDatabase());
    }

    @Override
    protected String getProductNameString() {
        return "PostgreSQL";
    }

    @Override
    @Test
    public void supportsInitiallyDeferrableColumns() {
        Assert.assertTrue((boolean)this.getDatabase().supportsInitiallyDeferrableColumns());
    }

    @Override
    @Test
    public void getCurrentDateTimeFunction() {
        Assert.assertEquals((Object)"NOW()", (Object)this.getDatabase().getCurrentDateTimeFunction());
    }

    @Test
    public void testDropDatabaseObjects() throws Exception {
    }

    @Test
    public void testCheckDatabaseChangeLogTable() throws Exception {
    }

    public void testGetDefaultDriver() throws DatabaseException {
        try (PostgresDatabase database = new PostgresDatabase();){
            Assert.assertEquals((Object)"org.postgresql.Driver", (Object)database.getDefaultDriver("jdbc:postgresql://localhost/liquibase"));
            Assert.assertNull((Object)database.getDefaultDriver("jdbc:db2://localhost;databaseName=liquibase"));
        }
    }

    @Override
    @Test
    public void escapeTableName_noSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"tableName\"", (Object)database.escapeTableName(null, null, "tableName"));
        Assert.assertEquals((Object)"tbl", (Object)database.escapeTableName(null, null, "tbl"));
    }

    @Test
    public void escapeTableName_reservedWord() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"user\"", (Object)database.escapeTableName(null, null, "user"));
    }

    @Override
    @Test
    public void escapeTableName_withSchema() {
        AbstractJdbcDatabase database = this.getDatabase();
        Assert.assertEquals((Object)"\"schemaName\".\"tableName\"", (Object)database.escapeTableName("catalogName", "schemaName", "tableName"));
    }

    @Test
    public void escapeTableName_reservedWordOnly() {
        AbstractJdbcDatabase database = this.getDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ONLY_RESERVED_WORDS);
        Assert.assertEquals((Object)"\"user\"", (Object)database.escapeTableName(null, null, "user"));
        Assert.assertEquals((Object)"tableName", (Object)database.escapeTableName(null, null, "tableName"));
    }

    @Test
    public void escapeTableName_all() {
        AbstractJdbcDatabase database = this.getDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
        Assert.assertEquals((Object)"\"tbl\"", (Object)database.escapeTableName(null, null, "tbl"));
        Assert.assertEquals((Object)"\"user\"", (Object)database.escapeTableName(null, null, "user"));
    }

    @Test
    public void testIfEscapeLogicNotImpactOnChangeLog() {
        PostgresDatabase database = (PostgresDatabase)this.getDatabase();
        database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
        String COLUMN_AUTHOR = "AUTHOR";
        String result = database.escapeObjectName("AUTHOR", LiquibaseColumn.class);
        Assert.assertEquals((Object)"AUTHOR", (Object)result);
    }

    @Override
    @Test
    public void test_escapeObjectName() {
        String tableName = this.database.escapeObjectName("My Table  ", Table.class);
        Assert.assertTrue((boolean)tableName.matches("[\\[\\\"`]?My Table  [\\]\\\"`]?"));
        tableName = this.database.escapeObjectName("MyTable", Table.class);
        Assert.assertEquals((Object)"\"MyTable\"", (Object)tableName);
        tableName = this.database.escapeObjectName("My Table", Table.class);
        Assert.assertTrue((boolean)tableName.matches("[\\[\\\"`]?My Table[\\]\\\"`]?"));
    }

    @Test
    public void test_getConcatSql() {
        Assert.assertEquals((Object)"", (Object)this.database.getConcatSql(new String[0]));
        Assert.assertEquals((Object)"foo", (Object)this.database.getConcatSql(new String[]{"foo"}));
        Assert.assertEquals((Object)"foo || bar", (Object)this.database.getConcatSql(new String[]{"foo", "bar"}));
        Assert.assertEquals((Object)"one || two || | three", (Object)this.database.getConcatSql(new String[]{"one", "two", "| three"}));
    }

    @Test
    public void generatePrimaryKeyName_tableSizeNameLessThan63Bytes_nameIsBuiltCorrectly() {
        String tableName = "name";
        String expectedPrimaryKeyName = "name_pkey";
        this.assertPrimaryKeyName("name_pkey", this.database.generatePrimaryKeyName("name"));
    }

    @Test
    public void generatePrimaryKeyName_tableSizeNameMoreThan63Bytes_nameIsBuiltCorrectly() {
        String tableName = "name_" + StringUtil.repeat((String)"_", (int)100);
        String expectedPrimaryKeyName = "name______________________________________________________pkey";
        this.assertPrimaryKeyName("name______________________________________________________pkey", this.database.generatePrimaryKeyName(tableName));
    }

    @Test
    public void generatePrimaryKeyName_tableSizeNameLessThan63BytesAndNonASCIISymbols_nameIsBuiltCorrectly() {
        String nameWith15NonAsciiSymbols = "name_" + StringUtil.repeat((String)"\u03a9", (int)15);
        String expectedPrimaryKeyName = "name_" + StringUtil.repeat((String)"\u03a9", (int)15) + "_pkey";
        this.assertPrimaryKeyName(expectedPrimaryKeyName, this.database.generatePrimaryKeyName(nameWith15NonAsciiSymbols));
    }

    private void assertPrimaryKeyName(String expected, String actual) {
        Assert.assertTrue((expected.getBytes((Charset)GlobalConfiguration.FILE_ENCODING.getCurrentValue()).length <= 63 ? 1 : 0) != 0);
        assert (expected.equals(actual)) : "Invalid " + actual + " vs expected " + expected;
    }
}

