/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype;

import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.core.BooleanType;
import liquibase.exception.UnexpectedLiquibaseException;
import org.junit.Assert;
import org.junit.Test;

public class BooleanTypeTest {
    @Test
    public void postgresqlBitString() {
        BooleanType bt = new BooleanType();
        bt.finishInitialization("bit(12)");
        String expected = "b'111111111111'::\"bit\"";
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"'111111111111'", (Database)new PostgresDatabase()));
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"b'111111111111'", (Database)new PostgresDatabase()));
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"'111111111111'::bit", (Database)new PostgresDatabase()));
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"b'111111111111'::bit", (Database)new PostgresDatabase()));
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"'111111111111'::\"bit\"", (Database)new PostgresDatabase()));
        Assert.assertEquals((Object)expected, (Object)bt.objectToSql((Object)"b'111111111111'::\"bit\"", (Database)new PostgresDatabase()));
    }

    @Test(expected=UnexpectedLiquibaseException.class)
    public void postgresqlBitStringError() {
        BooleanType bt = new BooleanType();
        bt.finishInitialization("bit(12)");
        Assert.assertNotEquals((Object)"b'1'", (Object)bt.objectToSql((Object)"'12'", (Database)new PostgresDatabase()));
    }
}

