/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype;

import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.ClobType;
import org.junit.Assert;
import org.junit.Test;

public class ClobTypeTest {
    @Test
    public void mssqlTextToVarcharTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("Text");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"varchar (max)", (Object)dbType.getType());
        });
    }

    @Test
    public void mssqlEscapedTextToVarcharTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("[Text]");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"varchar (max)", (Object)dbType.getType());
        });
    }

    @Test
    public void mssqlTextToVarcharNoConvertTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)false, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("Text");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"varchar (max)", (Object)dbType.getType());
        });
    }

    @Test
    public void mssqlNTextToNVarcharNoConvertTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)false, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("NText");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"nvarchar (max)", (Object)dbType.getType());
        });
    }

    @Test
    public void mssqlEscapedTextToVarcharNoConvertTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)false, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("[Text]");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"varchar (max)", (Object)dbType.getType());
        });
    }

    @Test
    public void mssqlEscapedNTextToNVarcharNoConvertTest() throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)false, () -> {
            ClobType ct = new ClobType();
            ct.finishInitialization("[NText]");
            DatabaseDataType dbType = ct.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)"nvarchar (max)", (Object)dbType.getType());
        });
    }
}

