/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.BlobType;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class BlobTypeTest {
    @ParameterizedTest
    @CsvSource(value={"varbinary,VARBINARY,", "varbinary(50),VARBINARY(50),50", "binary(50),BINARY(50),50", "java.sql.Types.VARBINARY,VARBINARY,", "blob, BLOB,"})
    public void toDatabaseDataType_should_succeed_for_DB2Database(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new DB2Database());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"varbinary,VARBINARY,", "varbinary(50),VARBINARY(50),50", "binary(50),BINARY(50),50", "java.sql.Types.VARBINARY,VARBINARY,", "blob, BLOB,"})
    public void toDatabaseDataType_should_succeed_for_Db2zDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new Db2zDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"large object,BINARY LARGE OBJECT", "varbinary,VARBINARY", "java.sql.Types.VARBINARY,VARBINARY", "longvarbinary,LONGVARBINARY", "java.sql.Types.LONGVARBINARY,LONGVARBINARY", "binary,BINARY", "blob,BLOB"})
    public void toDatabaseDataType_should_succeed_for_H2Database(String liquibaseType, String expectedDatabaseType) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new H2Database());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"large object,BINARY LARGE OBJECT,", "varbinary,VARBINARY,", "varbinary(40),VARBINARY(40),40", "java.sql.Types.VARBINARY,VARBINARY,", "longvarbinary,LONGVARBINARY,", "java.sql.Types.LONGVARBINARY,LONGVARBINARY,", "binary,BINARY,", "blob,BLOB,"})
    public void toDatabaseDataType_should_succeed_for_HsqlDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new HsqlDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"varbinary,varbinary(1),", "[varbinary],varbinary(1),", "varbinary(8000),varbinary(8000),8000", "[varbinary](8000),varbinary(8000),8000", "image,image,", "blob,varbinary(MAX),"})
    public void toDatabaseDataType_should_succeed_for_MSSQLDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new MSSQLDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"varbinary,VARBINARY,", "varbinary(8000),VARBINARY(8000),8000", "tinyblob,TINYBLOB,", "mediumblob,MEDIUMBLOB,", "binary,BINARY,", "binary(50),BINARY(50),50", "java.sql.Types.BLOB,BLOB,", "blob,BLOB,", "longblob,LONGBLOB,"})
    public void toDatabaseDataType_should_succeed_for_MySQLDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new MySQLDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"java.sql.Types.BLOB,OID,", "blob,OID,", "bytea,BYTEA,"})
    public void toDatabaseDataType_should_succeed_for_PostgresDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new PostgresDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"blob,LONG BINARY"})
    public void toDatabaseDataType_should_succeed_for_SybaseASADatabase(String liquibaseType, String expectedDatabaseType) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new SybaseASADatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"blob,IMAGE"})
    public void toDatabaseDataType_should_succeed_SybaseDatabase(String liquibaseType, String expectedDatabaseType) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new SybaseDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"blob,BLOB"})
    public void toDatabaseDataType_should_succeed_for_FirebirdDatabase(String liquibaseType, String expectedDatabaseType) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new FirebirdDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }

    @ParameterizedTest
    @CsvSource(value={"bfile,BFILE,", "raw,RAW,", "raw(300),RAW(300),300", "binary,RAW,", "varbinary,RAW,", "binary(300),RAW(300),300", "varbinary(300),RAW(300),300", "blob,BLOB,"})
    public void toDatabaseDataType_should_succeed_for_OracleDatabase(String liquibaseType, String expectedDatabaseType, Integer max) throws Exception {
        Scope.child((String)GlobalConfiguration.CONVERT_DATA_TYPES.getKey(), (Object)true, () -> {
            BlobType blobType = new BlobType();
            if (max != null) {
                blobType.addParameter((Object)max);
            }
            blobType.finishInitialization(liquibaseType);
            DatabaseDataType dbType = blobType.toDatabaseDataType((Database)new OracleDatabase());
            Assert.assertEquals((Object)expectedDatabaseType, (Object)dbType.getType());
        });
    }
}

