/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.output.changelog;

import java.util.List;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DiffToChangeLogTest {
    @Test
    public void getOrderedOutputTypes_isConsistent() throws Exception {
        MySQLDatabase database = new MySQLDatabase();
        DiffToChangeLog obj = new DiffToChangeLog(new DiffResult((DatabaseSnapshot)new EmptyDatabaseSnapshot((Database)database), (DatabaseSnapshot)new EmptyDatabaseSnapshot((Database)database), new CompareControl()), null);
        for (Class type : new Class[]{UnexpectedObjectChangeGenerator.class, MissingObjectChangeGenerator.class, ChangedObjectChangeGenerator.class}) {
            List orderedOutputTypes = obj.getOrderedOutputTypes(type);
            for (int i = 0; i < 50; ++i) {
                Assert.assertThat((String)("Error checking " + type.getName()), (Object)orderedOutputTypes, (Matcher)Matchers.contains((Object[])obj.getOrderedOutputTypes(type).toArray()));
            }
        }
    }

    @Test
    public void getOrderedOutputTypes_hasDependencies() throws Exception {
        MySQLDatabase database = new MySQLDatabase();
        Class[] typesArray = new Class[]{Schema.class, View.class, Catalog.class, Table.class, Column.class};
        SnapshotControl control = new SnapshotControl((Database)database, typesArray);
        EmptyDatabaseSnapshot emptyDatabaseSnapshot = new EmptyDatabaseSnapshot((Database)database, control);
        DiffToChangeLog obj = new DiffToChangeLog(new DiffResult((DatabaseSnapshot)emptyDatabaseSnapshot, (DatabaseSnapshot)emptyDatabaseSnapshot, new CompareControl()), null);
        for (Class type : new Class[]{UnexpectedObjectChangeGenerator.class, MissingObjectChangeGenerator.class, ChangedObjectChangeGenerator.class}) {
            List orderedOutputTypes = obj.getOrderedOutputTypes(type);
            Assert.assertThat((String)"There should be some types", (Object)orderedOutputTypes, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5))));
        }
        List unexpectedOrderedOutputTypes = obj.getOrderedOutputTypes(UnexpectedObjectChangeGenerator.class);
        Assert.assertThat((String)"There should be some types", (Object)unexpectedOrderedOutputTypes, (Matcher)Matchers.hasSize((int)7));
        List missingOrderedOutputTypes = obj.getOrderedOutputTypes(MissingObjectChangeGenerator.class);
        Assert.assertThat((String)"There should be some types", (Object)missingOrderedOutputTypes, (Matcher)Matchers.hasSize((int)6));
        List changedOrderedOutputTypes = obj.getOrderedOutputTypes(ChangedObjectChangeGenerator.class);
        Assert.assertThat((String)"There should be some types", (Object)changedOrderedOutputTypes, (Matcher)Matchers.hasSize((int)6));
    }
}

