/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RollbackContainer;
import liquibase.exception.DatabaseException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class ExampleExecutor
extends JdbcExecutor {
    public ExampleExecutor() {
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Constructed an ExampleExecutor");
    }

    public String getName() {
        return "example";
    }

    public int getPriority() {
        return 101;
    }

    public ValidationErrors validate(ChangeSet changeSet) {
        if (changeSet.getRunWith() == null || changeSet.getRunWith().isEmpty()) {
            return new ValidationErrors();
        }
        ValidationErrors validationErrors = new ValidationErrors();
        List changes = changeSet.getChanges();
        for (Change change : changes) {
            this.validateChange(changeSet, validationErrors, change, "");
        }
        if (changeSet.getRollback() != null) {
            RollbackContainer container = changeSet.getRollback();
            List rollbackChanges = container.getChanges();
            for (Change change : rollbackChanges) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Validating rollback change " + change.getDescription());
                this.validateChange(changeSet, validationErrors, change, "rollback");
            }
        }
        return validationErrors;
    }

    private void validateChange(ChangeSet changeSet, ValidationErrors validationErrors, Change change, String type) {
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Validating " + type + " change " + change.getDescription());
    }

    public void execute(SqlStatement action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing with the '" + this.getName() + "' executor");
        Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(action, this.database);
        try {
            for (Sql sql : sqls) {
                String actualSqlString = sql.toSql();
                for (SqlVisitor visitor : sqlVisitors) {
                    visitor.modifySql(actualSqlString, this.database);
                }
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Generated SQL for change is " + actualSqlString);
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }
}

