/*
 * Decompiled with CFR 0.152.
 */
package liquibase.hub.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.hub.LiquibaseHubException;
import liquibase.hub.core.HttpClient;

public class MockHttpClient
extends HttpClient {
    protected Map<String, ?> responses = new HashMap();
    protected Map<String, Object> requests = new HashMap<String, Object>();

    public MockHttpClient() {
    }

    public MockHttpClient(Map<String, ?> responses) {
        this.responses = responses;
    }

    protected <T> T doRequest(String method, String url, Object requestBodyObject, Class<T> returnType, Class contentReturnType) throws LiquibaseHubException {
        String requestKey = method.toUpperCase() + " " + url;
        this.requests.put(requestKey, requestBodyObject);
        if (!this.responses.containsKey(requestKey)) {
            throw new RuntimeException("Unknown mock request for " + requestKey);
        }
        Object response = this.responses.get(requestKey);
        if (response instanceof LiquibaseHubException) {
            throw (LiquibaseHubException)response;
        }
        return (T)response;
    }

    public static Map<String, ?> createListResponse(Map<String, ?> ... objects) {
        LinkedHashMap returnMap = new LinkedHashMap();
        ArrayList content = new ArrayList();
        for (Map<String, ?> object : objects) {
            content.add(object);
        }
        returnMap.put("content", content);
        return returnMap;
    }

    public Object getRequestBody(String requestKey) {
        return this.requests.get(requestKey);
    }
}

