/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.ScopeManager;
import liquibase.TestScopeManager;
import liquibase.integration.ant.BaseLiquibaseTask;
import org.junit.BeforeClass;

public abstract class AbstractAntTaskTest {
    @BeforeClass
    public static void setup() {
        Scope.setScopeManager((ScopeManager)new TestScopeManager());
    }

    protected static void setProperties() {
        String name = BaseLiquibaseTask.class.getName();
        String resourceName = "/" + name.replace('.', '/') + ".class";
        String absoluteFilePath = BaseLiquibaseTask.class.getResource(resourceName).getFile();
        try {
            absoluteFilePath = URLDecoder.decode(absoluteFilePath, (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding in JVM.", e);
        }
        String classesDir = absoluteFilePath.substring(0, absoluteFilePath.length() - resourceName.length());
        System.setProperty("liquibase.test.classes.root", classesDir);
        String testClassName = AbstractAntTaskTest.class.getName();
        String testSimpleName = AbstractAntTaskTest.class.getSimpleName() + ".class";
        String testResourceName = "/" + testClassName.replace('.', '/') + ".class";
        String testAbsoluteFilePath = AbstractAntTaskTest.class.getResource(testResourceName).getFile();
        try {
            testAbsoluteFilePath = URLDecoder.decode(testAbsoluteFilePath, (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Missing UTF-8 encoding in JVM.", e);
        }
        String testClassesDir = testAbsoluteFilePath.substring(0, testAbsoluteFilePath.length() - testResourceName.length());
        String testAntBaseDir = testAbsoluteFilePath.substring(0, testAbsoluteFilePath.length() - testSimpleName.length());
        System.setProperty("liquibase.test.testclasses.root", testClassesDir);
        System.setProperty("liquibase.test.ant.basedir", testAntBaseDir);
    }
}

