/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import liquibase.Scope;
import liquibase.exception.CommandLineParsingException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.integration.commandline.Main;
import liquibase.util.StringUtil;
import org.junit.Assert;
import org.junit.Test;

public class MainTest {
    @Test
    public void testCodePointCheck() {
        char badChar = '\u2000';
        char anotherBadChar = '\u00a0';
        Main.CodePointCheck codePointCheck = Main.checkArg((String)"test");
        Assert.assertNull((String)"This should be a valid string", (Object)codePointCheck);
        StringBuilder builder = new StringBuilder();
        builder.append(badChar);
        codePointCheck = Main.checkArg((String)builder.toString());
        Assert.assertEquals((String)"The first character should be invalid", (long)0L, (long)codePointCheck.position);
        builder = new StringBuilder();
        builder.append("A");
        builder.append(badChar);
        codePointCheck = Main.checkArg((String)builder.toString());
        Assert.assertEquals((String)"The last character should be invalid", (long)codePointCheck.position, (long)(builder.length() - 1));
        builder = new StringBuilder();
        builder.append("ABC");
        builder.append(anotherBadChar);
        builder.append("DEF");
        int pos = builder.toString().indexOf(anotherBadChar);
        codePointCheck = Main.checkArg((String)builder.toString());
        Assert.assertEquals((String)("The character in position " + pos + " should be invalid"), (long)codePointCheck.position, (long)pos);
    }

    @Test
    public void checkSetup2() {
        Main main = new Main();
        main.command = "snapshot";
        main.url = "jdbc:oracle://localhost:1521/ORCL";
        main.commandParams.add("--outputSchemasAs");
        List messages = main.checkSetup();
        Assert.assertEquals((String)"There should be no messages from Main.checkSetup", (long)0L, (long)messages.size());
        main.command = "update";
        main.changeLogFile = "changelog.xml";
        messages = main.checkSetup();
        Assert.assertEquals((String)"There should be one message from Main.checkSetup", (long)1L, (long)messages.size());
    }

    @Test
    public void testLocalProperties() throws Exception {
        String[] args = new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=offline:mock?version=1.20&productName=SuperDuperDatabase&catalog=startCatalog&caseSensitive=true&changeLogFile=liquibase/database/simpleChangeLog.xml&sendsStringParametersAsUnicode=true", "--changeLogFile=dummy.log", "--changeExecListenerClass=MockChangeExecListener", "--defaultsFile=target/test-classes/liquibase.properties", "snapshot"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertTrue((String)"Read context from liquibase.properties", (cli.logFile != null && "target/logfile_set_from_liquibase_properties.log".equals(cli.logFile) ? 1 : 0) != 0);
    }

    @Test
    public void startWithoutParameters() throws Exception {
        Main.run((String[])new String[0]);
        Assert.assertTrue((String)"We just want to survive until this point", (boolean)true);
    }

    @Test
    public void globalConfigurationSaysDoNotRun() throws Exception {
        Scope.child(Collections.singletonMap(LiquibaseCommandLineConfiguration.SHOULD_RUN.getKey(), false), () -> {
            int errorLevel = Main.run((String[])new String[0]);
            Assert.assertEquals((long)errorLevel, (long)0L);
        });
    }

    @Test
    public void migrateWithAllParameters() throws Exception {
        String[] args = new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "--promptForNonLocalDatabase=true", "--changeExecListenerClass=MockChangeExecListener", "--changeExecListenerPropertiesFile=PROPS", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Option --driver was parsed correctly", (Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((String)"Option --username was parsed correctly", (Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((String)"Option --password was parsed correctly", (Object)"PASSWORD", (Object)cli.password);
        Assert.assertEquals((String)"Option --url was parsed correctly", (Object)"URL", (Object)cli.url);
        Assert.assertEquals((String)"Option --changeLogFile was parsed correctly", (Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((String)"Option --classpath was parsed correctly", (Object)"CLASSPATH;CLASSPATH2", (Object)cli.classpath);
        Assert.assertEquals((String)"Option --contexts was parsed correctly", (Object)"CONTEXT1,CONTEXT2", (Object)cli.contexts);
        Assert.assertEquals((String)"Option --promptForNonLocalDatabase was parsed correctly", (Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((String)"Main command 'update' was parsed correctly", (Object)"update", (Object)cli.command);
        Assert.assertEquals((String)"Option --changeExecListenerClass was parsed correctly", (Object)"MockChangeExecListener", (Object)cli.changeExecListenerClass);
        Assert.assertEquals((String)"Option --changeExecListenerPropertiesFile was parsed correctly", (Object)"PROPS", (Object)cli.changeExecListenerPropertiesFile);
    }

    @Test
    public void falseBooleanParameters() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=false", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Option --promptForNonLocalDatabase=false was parsed correctly", (Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((String)"Main command 'update' was parsed correctly", (Object)"update", (Object)cli.command);
    }

    @Test
    public void convertMigrateToUpdate() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=false", "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Option --promptForNonLocalDatabase was parsed correctly", (Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((String)"Main command 'migrate' was parsed correctly as 'update'", (Object)"update", (Object)cli.command);
    }

    @Test
    public void trueBooleanParameters() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=true", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Option --promptForNonLocalDatabase=true was parsed correctly", (Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        Assert.assertEquals((String)"Main command 'update' was parsed correctly", (Object)"update", (Object)cli.command);
    }

    @Test(expected=CommandLineParsingException.class)
    public void parameterWithoutDash() throws Exception {
        String[] args = new String[]{"promptForNonLocalDatabase=true", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
    }

    @Test
    public void emptyUrlParameter() throws Exception {
        String[] args = new String[]{"--changeLogFile=FILE", "--url=", "update"};
        Main cli = new Main();
        cli.parseOptions(args);
        List errMsgs = cli.checkSetup();
        Assert.assertEquals((String)"specifying an empty URL should return 1 error message.", (long)1L, (long)errMsgs.size());
    }

    @Test
    public void misplacedDiffTypesDataOption() throws Exception {
        String[] args = new String[]{"--changeLogFile=FILE", "--url=TESTFILE", "diffChangeLog", "--diffTypes=data"};
        Main cli = new Main();
        cli.parseOptions(args);
        List errMsgs = cli.checkSetup();
        Assert.assertEquals((String)"the combination of --diffTypes=data and diffChangeLog must not be accepted.", (long)1L, (long)errMsgs.size());
    }

    @Test(expected=CommandLineParsingException.class)
    public void unknownParameter() throws Exception {
        String[] args = new String[]{"--promptForNonLocalDatabase=true", "--badParam=here", "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
    }

    @Test
    public void statusVerbose() throws Exception {
        String[] args = new String[]{"--url=URL", "--changeLogFile=FILE", "status", "--verbose"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Main command 'status' was not correctly parsed", (Object)"status", (Object)cli.command);
        List errMsgs = cli.checkSetup();
        Assert.assertEquals((long)0L, (long)errMsgs.size());
    }

    @Test
    public void statusVerboseWithValue() throws Exception {
        String[] args = new String[]{"--url=URL", "--changeLogFile=FILE", "status", "--verbose=true"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Main command 'status' was not correctly parsed", (Object)"status", (Object)cli.command);
        List errMsgs = cli.checkSetup();
        Assert.assertEquals((long)1L, (long)errMsgs.size());
    }

    @Test
    public void statusWithoutVerbose() throws Exception {
        String[] args = new String[]{"--url=URL", "--changeLogFile=FILE", "status"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Main command 'status' was not correctly parsed", (Object)"status", (Object)cli.command);
        List errMsgs = cli.checkSetup();
        Assert.assertEquals((long)0L, (long)errMsgs.size());
    }

    @Test(expected=CommandLineParsingException.class)
    public void configureNonExistantClassloaderLocation() throws Exception {
        Main cli = new Main();
        cli.classpath = "badClasspathLocation";
        cli.configureClassLoader();
    }

    @Test
    public void windowsConfigureClassLoaderLocation() throws Exception {
        Main cli = new Main();
        if (cli.isWindows()) {
            System.setProperty("os.name", "Windows XP");
            cli.classpath = "c:\\;c:\\windows\\";
            cli.applyDefaults();
            cli.configureClassLoader();
            URL[] classloaderURLs = ((URLClassLoader)cli.classLoader).getURLs();
            Assert.assertEquals((String)"Parsing example Windows classpath returns 2 entries", (long)2L, (long)classloaderURLs.length);
            Assert.assertEquals((String)"Windows path C:\\ is correctly parsed", (Object)"file:/c:/", (Object)classloaderURLs[0].toExternalForm());
            Assert.assertEquals((String)"Windows path C:\\windows\\ is correctly parsed", (Object)"file:/c:/windows/", (Object)classloaderURLs[1].toExternalForm());
        }
    }

    @Test
    public void unixConfigureClassLoaderLocation() throws Exception {
        Main cli = new Main();
        if (!cli.isWindows()) {
            System.setProperty("os.name", "Linux");
            cli.classpath = "/tmp:/";
            cli.applyDefaults();
            cli.configureClassLoader();
            URL[] classloaderURLs = ((URLClassLoader)cli.classLoader).getURLs();
            Assert.assertEquals((long)2L, (long)classloaderURLs.length);
            Assert.assertEquals((Object)"file:/tmp/", (Object)classloaderURLs[0].toExternalForm());
            Assert.assertEquals((Object)"file:/", (Object)classloaderURLs[1].toExternalForm());
        }
    }

    @Test
    public void propertiesFileWithNoOtherArgs() throws Exception {
        Main cli = new Main();
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("username", "USERNAME");
        props.setProperty("password", "PASSWD");
        props.setProperty("url", "URL");
        props.setProperty("changeLogFile", "FILE");
        props.setProperty("classpath", "CLASSPAHT");
        props.setProperty("contexts", "CONTEXTS");
        props.setProperty("promptForNonLocalDatabase", "TRUE");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSWD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPAHT", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXTS", (Object)cli.contexts);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test
    public void propertiesFileWithOtherArgs() throws Exception {
        Main cli = new Main();
        cli.username = "PASSED USERNAME";
        cli.password = "PASSED PASSWD";
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("username", "USERNAME");
        props.setProperty("password", "PASSWD");
        props.setProperty("url", "URL");
        props.setProperty("changeLogFile", "FILE");
        props.setProperty("classpath", "CLASSPAHT");
        props.setProperty("contexts", "CONTEXTS");
        props.setProperty("promptForNonLocalDatabase", "TRUE");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((Object)"PASSED USERNAME", (Object)cli.username);
        Assert.assertEquals((Object)"PASSED PASSWD", (Object)cli.password);
        Assert.assertEquals((Object)"URL", (Object)cli.url);
        Assert.assertEquals((Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((Object)"CLASSPAHT", (Object)cli.classpath);
        Assert.assertEquals((Object)"CONTEXTS", (Object)cli.contexts);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test
    public void propertiesFileChangeLogParameters() throws Exception {
        Main cli = new Main();
        Properties props = new Properties();
        props.setProperty("driver", "DRIVER");
        props.setProperty("parameter.some_changelog_parameter", "parameterValue");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        cli.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((String)"Changelog parameter in properties file is recognized", (Object)"parameterValue", cli.changeLogParameters.get("some_changelog_parameter"));
    }

    @Test
    public void applyDefaults() {
        Main cli = new Main();
        cli.promptForNonLocalDatabase = Boolean.TRUE;
        cli.applyDefaults();
        Assert.assertEquals((String)"Correct default value for --promptForNonLocalDatabase", (Object)Boolean.TRUE, (Object)cli.promptForNonLocalDatabase);
        cli.promptForNonLocalDatabase = Boolean.FALSE;
        cli.applyDefaults();
        Assert.assertEquals((String)"Correct default value for --promptForNonLocalDatabase", (Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
        cli.promptForNonLocalDatabase = null;
        cli.applyDefaults();
        Assert.assertEquals((String)"Correct default value for --promptForNonLocalDatabase", (Object)Boolean.FALSE, (Object)cli.promptForNonLocalDatabase);
    }

    @Test
    public void checkSetup() {
        String[] cmdParms;
        int i;
        int i2;
        Main cli = new Main();
        Assert.assertFalse((boolean)cli.checkSetup().isEmpty());
        cli.driver = "driver";
        cli.username = "username";
        cli.password = "pwd";
        cli.url = "url";
        cli.changeLogFile = "file";
        cli.classpath = "classpath";
        Assert.assertFalse((boolean)cli.checkSetup().isEmpty());
        cli.command = "BadCommand";
        Assert.assertFalse((boolean)cli.checkSetup().isEmpty());
        cli.command = "migrate";
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        String[] noArgCommand = new String[]{"migrate", "migrateSQL", "update", "updateSQL", "updateTestingRollback", "listLocks", "releaseLocks", "validate", "help", "clearCheckSums", "changelogSync", "changelogSyncSQL"};
        cli.commandParams.clear();
        cli.commandParams.add("--logLevel=debug");
        for (i2 = 0; i2 < noArgCommand.length; ++i2) {
            cli.command = noArgCommand[i2];
            Assert.assertEquals((String)("Command " + cli.command), (long)1L, (long)cli.checkSetup().size());
        }
        cli.command = "update";
        cli.commandParams.clear();
        cli.changeLogParameters.clear();
        cli.changeLogParameters.put("engine", "myisam");
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.clear();
        for (i2 = 0; i2 < noArgCommand.length; ++i2) {
            cli.command = noArgCommand[i2];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        String[] singleArgCommand = new String[]{"updateCount", "updateCountSQL", "tag", "dbDoc"};
        cli.commandParams.add("--logLevel=debug");
        for (i = 0; i < singleArgCommand.length; ++i) {
            cli.command = singleArgCommand[i];
            Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
        }
        cli.commandParams.clear();
        cli.commandParams.add("someCommandValue");
        for (i = 0; i < singleArgCommand.length; ++i) {
            cli.command = singleArgCommand[i];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        cli.command = "status";
        cli.commandParams.clear();
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.add("--verbose");
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.clear();
        cli.commandParams.add("--logLevel=debug");
        Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
        String[] multiArgCommand = new String[]{"diff", "diffChangeLog"};
        cli.commandParams.clear();
        for (int i3 = 0; i3 < multiArgCommand.length; ++i3) {
            cli.command = multiArgCommand[i3];
            Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        }
        for (String param : cmdParms = new String[]{"--referenceUsername=USERNAME", "--referencePassword=PASSWORD", "--referenceUrl=URL", "--referenceDriver=DRIVER"}) {
            cli.commandParams.add(param);
        }
        Assert.assertEquals((long)0L, (long)cli.checkSetup().size());
        cli.commandParams.add("--logLevel=debug");
        Assert.assertEquals((long)1L, (long)cli.checkSetup().size());
    }

    @Test
    public void tag() throws Exception {
        String[] args = new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "--databaseChangeLogTablespaceName=MYTABLES", "tag", "TagHere"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((String)"Command line option --driver is parsed correctly", (Object)"DRIVER", (Object)cli.driver);
        Assert.assertEquals((String)"Command line option --username is parsed correctly", (Object)"USERNAME", (Object)cli.username);
        Assert.assertEquals((String)"Command line option --password is parsed correctly", (Object)"PASSWORD", (Object)cli.password);
        Assert.assertEquals((String)"Command line option --url is parsed correctly", (Object)"URL", (Object)cli.url);
        Assert.assertEquals((String)"Command line option --changeLogFile is parsed correctly", (Object)"FILE", (Object)cli.changeLogFile);
        Assert.assertEquals((String)"Command line option --classpath is parsed correctly", (Object)"CLASSPATH;CLASSPATH2", (Object)cli.classpath);
        Assert.assertEquals((String)"Command line option --contexts is parsed correctly", (Object)"CONTEXT1,CONTEXT2", (Object)cli.contexts);
        Assert.assertEquals((String)"Command line option --databaseChangeLogTablespaceName is parsed correctly", (Object)"MYTABLES", (Object)cli.databaseChangeLogTablespaceName);
        Assert.assertEquals((String)"Main command 'tag' is parsed correctly", (Object)"tag", (Object)cli.command);
        Assert.assertEquals((String)"Command parameter 'TagHere' is parsed correctly", (Object)"TagHere", cli.commandParams.iterator().next());
    }

    @Test
    public void migrateWithEqualsInParams() throws Exception {
        String url = "dbc:sqlserver://127.0.0.1;DatabaseName=dev_nn;user=ffdatabase;password=p!88worD";
        String[] args = new String[]{"--url=" + url, "migrate"};
        Main cli = new Main();
        cli.parseOptions(args);
        Assert.assertEquals((Object)url, (Object)cli.url);
    }

    @Test
    public void fixArgs() {
        Main liquibase = new Main();
        String[] fixedArgs = liquibase.fixupArgs(new String[]{"--defaultsFile", "liquibase.properties", "migrate"});
        Assert.assertEquals((Object)"--defaultsFile=liquibase.properties migrate", (Object)StringUtil.join(Arrays.asList(fixedArgs), (String)" "));
        fixedArgs = liquibase.fixupArgs(new String[]{"--defaultsFile=liquibase.properties", "migrate"});
        Assert.assertEquals((Object)"--defaultsFile=liquibase.properties migrate", (Object)StringUtil.join(Arrays.asList(fixedArgs), (String)" "));
        fixedArgs = liquibase.fixupArgs(new String[]{"--driver=DRIVER", "--username=USERNAME", "--password=PASSWORD", "--url=URL", "--changeLogFile=FILE", "--classpath=CLASSPATH;CLASSPATH2", "--contexts=CONTEXT1,CONTEXT2", "--promptForNonLocalDatabase=true", "migrate"});
        Assert.assertEquals((Object)"--driver=DRIVER --username=USERNAME --password=PASSWORD --url=URL --changeLogFile=FILE --classpath=CLASSPATH;CLASSPATH2 --contexts=CONTEXT1,CONTEXT2 --promptForNonLocalDatabase=true migrate", (Object)StringUtil.join(Arrays.asList(fixedArgs), (String)" "));
    }

    @Test
    public void testVersionArg() throws Exception {
        Main.run((String[])new String[]{"--version"});
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testSplitArgWithValueEndingByEqualSing() throws CommandLineParsingException {
        String argName = "password";
        String argValue = "s3-cr3t=";
        Main tested = new Main();
        tested.parseOptions(new String[]{"--password=s3-cr3t="});
        Assert.assertEquals((String)"Password containing an equal sign (=) is parsed correctly", (Object)"s3-cr3t=", (Object)tested.password);
    }

    @Test
    public void testDatabaseChangeLogTableName_Properties() throws IOException, CommandLineParsingException {
        Main main = new Main();
        Properties props = new Properties();
        props.setProperty("databaseChangeLogTableName", "PROPSCHANGELOG");
        props.setProperty("databaseChangeLogLockTableName", "PROPSCHANGELOGLOCK");
        ByteArrayOutputStream propFile = new ByteArrayOutputStream();
        props.store(propFile, "");
        main.parsePropertiesFile((InputStream)new ByteArrayInputStream(propFile.toByteArray()));
        Assert.assertEquals((String)"Custom database change log table gets parsed correctly (as a property)", (Object)"PROPSCHANGELOG", (Object)main.databaseChangeLogTableName);
        Assert.assertEquals((String)"Custom database change log LOCK table gets parsed correctly (as a property)", (Object)"PROPSCHANGELOGLOCK", (Object)main.databaseChangeLogLockTableName);
    }

    @Test
    public void testDatabaseChangeLogTableName_Options() throws CommandLineParsingException {
        Main main = new Main();
        String[] opts = new String[]{"--databaseChangeLogTableName=OPTSCHANGELOG", "--databaseChangeLogLockTableName=OPTSCHANGELOGLOCK"};
        main.parseOptions(opts);
        Assert.assertEquals((String)"Custom database change log table gets parsed correctly (as an option argument)", (Object)"OPTSCHANGELOG", (Object)main.databaseChangeLogTableName);
        Assert.assertEquals((String)"Custom database change log LOCK table gets parsed correctly (as an option argument)", (Object)"OPTSCHANGELOGLOCK", (Object)main.databaseChangeLogLockTableName);
    }
}

