/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.servlet;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import liquibase.integration.servlet.GenericServletWrapper;
import liquibase.integration.servlet.LiquibaseServletListener;
import liquibase.integration.servlet.TestInitialContextFactory;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;
import org.mockito.Mockito;

public class LiquibaseServletListenerTest
extends TestCase {
    private static final String LIQUIBASE_CHANGELOG = "liquibase.changelog";
    private static final String LIQUIBASE_DATASOURCE = "liquibase.datasource";
    static DataSource dataSource;
    private LiquibaseServletListener servletListener;
    private GenericServletWrapper.ServletContext servletContext;
    private Context namingContext;

    public static Test suite() {
        return new TestSetup((Test)new TestSuite(LiquibaseServletListenerTest.class)){

            protected void setUp() {
                TestInitialContextFactory.install();
                BasicEmbeddedDataSource40 ds = new BasicEmbeddedDataSource40();
                ds.setDatabaseName("memory:foo");
                ds.setCreateDatabase("create");
                dataSource = ds;
            }

            protected void tearDown() {
                dataSource = null;
                TestInitialContextFactory.uninstall();
            }
        };
    }

    public void setUp() throws Exception {
        this.servletListener = new LiquibaseServletListener();
        this.servletContext = (GenericServletWrapper.ServletContext)Mockito.mock(GenericServletWrapper.ServletContext.class);
        Mockito.when((Object)this.servletContext.getInitParameter(LIQUIBASE_DATASOURCE)).thenReturn((Object)"myDS");
        Mockito.when((Object)this.servletContext.getInitParameter(LIQUIBASE_CHANGELOG)).thenReturn((Object)"liquibase/integration/servlet/simple-changelog.xml");
        Mockito.when((Object)this.servletContext.getInitParameterNames()).then(invocation -> Collections.enumeration(Arrays.asList(LIQUIBASE_DATASOURCE, LIQUIBASE_CHANGELOG)));
        Context env = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)env.lookup(Mockito.anyString())).thenThrow(NamingException.class);
        this.namingContext = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)this.namingContext.lookup("java:comp/env")).thenReturn((Object)env);
        Mockito.when((Object)this.namingContext.lookup("myDS")).thenReturn((Object)dataSource);
        TestInitialContextFactory.setInitialContext(this.namingContext);
    }

    public void testShouldNotShutEmbeddedDerbyDown() throws Exception {
        if (dataSource == null) {
            return;
        }
        try (Connection pooled = dataSource.getConnection();){
            this.servletListener.contextInitialized(this.servletContext);
            LiquibaseServletListenerTest.assertFalse((String)"connection.closed", (boolean)pooled.isClosed());
        }
    }
}

