/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.servlet;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.spi.InitialContextFactory;

public class TestInitialContextFactory
implements InitialContextFactory {
    private static String originalFactory;
    private static Context initialContext;

    public static void install() {
        originalFactory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", TestInitialContextFactory.class.getName());
    }

    public static void uninstall() {
        if (originalFactory == null) {
            System.getProperties().remove("java.naming.factory.initial");
        } else {
            System.setProperty("java.naming.factory.initial", originalFactory);
        }
    }

    public static void setInitialContext(Context context) {
        initialContext = context;
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) {
        return initialContext;
    }
}

