/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.spring;

import java.io.File;
import java.io.IOException;
import liquibase.integration.spring.SpringResourceAccessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@RunWith(value=MockitoJUnitRunner.class)
public class SpringResourceAccessorLoaderTest {
    @Mock
    ResourceLoader resourceLoader;
    @Mock
    Resource resource;
    SpringResourceAccessor springResourceAccessor;

    @Before
    public void setUp() {
        this.springResourceAccessor = new SpringResourceAccessor(this.resourceLoader);
    }

    @Test
    public void resourceIsFile_should_be_true_for_native_file() throws IOException {
        Mockito.when((Object)this.resource.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.isFile()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.getFile()).thenThrow(UnsupportedOperationException.class);
        Assert.assertTrue((boolean)this.springResourceAccessor.resourceIsFile(this.resource));
    }

    @Test
    public void resourceIsFile_should_be_true_for_normal_file() throws IOException {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)this.resource.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.isFile()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.getFile()).thenReturn((Object)file);
        Mockito.when((Object)file.isFile()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.springResourceAccessor.resourceIsFile(this.resource));
    }

    @Test
    public void resourceIsFile_should_be_true_by_filename() throws IOException {
        Mockito.when((Object)this.resource.exists()).thenReturn((Object)true);
        Mockito.when((Object)this.resource.isFile()).thenReturn((Object)false);
        Mockito.when((Object)this.resource.getFilename()).thenReturn((Object)"changelog.sql");
        Assert.assertTrue((boolean)this.springResourceAccessor.resourceIsFile(this.resource));
    }

    @Test
    public void resourceIsFile_should_be_false_by_filename() throws IOException {
        Mockito.when((Object)this.resource.exists()).thenReturn((Object)false);
        Mockito.when((Object)this.resource.getFilename()).thenReturn((Object)"changelog");
        Assert.assertFalse((boolean)this.springResourceAccessor.resourceIsFile(this.resource));
    }
}

