/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.MockDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.lockservice.LockServiceFactory;
import liquibase.lockservice.MockLockService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LockServiceFactoryTest {
    @Before
    public void before() {
        LockServiceFactory.getInstance().resetAll();
    }

    @After
    public void after() {
        LockServiceFactory.getInstance().resetAll();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)LockServiceFactory.getInstance());
        Assert.assertSame((Object)LockServiceFactory.getInstance(), (Object)LockServiceFactory.getInstance());
    }

    @Test
    public void getLockService() {
        OracleDatabase oracle1 = new OracleDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        OracleDatabase oracle2 = new OracleDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        MySQLDatabase mysql = new MySQLDatabase(){

            public boolean equals(Object o) {
                return o == this;
            }
        };
        DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
        databaseFactory.register((Database)oracle1);
        databaseFactory.register((Database)oracle2);
        databaseFactory.register((Database)mysql);
        LockServiceFactory lockServiceFactory = LockServiceFactory.getInstance();
        Assert.assertNotNull((Object)lockServiceFactory.getLockService((Database)oracle1));
        Assert.assertNotNull((Object)lockServiceFactory.getLockService((Database)oracle2));
        Assert.assertNotNull((Object)lockServiceFactory.getLockService((Database)mysql));
        Assert.assertSame((Object)lockServiceFactory.getLockService((Database)oracle1), (Object)lockServiceFactory.getLockService((Database)oracle1));
        Assert.assertSame((Object)lockServiceFactory.getLockService((Database)oracle2), (Object)lockServiceFactory.getLockService((Database)oracle2));
        Assert.assertSame((Object)lockServiceFactory.getLockService((Database)mysql), (Object)lockServiceFactory.getLockService((Database)mysql));
        Assert.assertNotSame((Object)lockServiceFactory.getLockService((Database)oracle1), (Object)lockServiceFactory.getLockService((Database)oracle2));
        Assert.assertNotSame((Object)lockServiceFactory.getLockService((Database)oracle1), (Object)lockServiceFactory.getLockService((Database)mysql));
        Assert.assertTrue((boolean)(lockServiceFactory.getLockService((Database)this.getMockDatabase()) instanceof MockLockService));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void resetAll_isThreadSafe() throws InterruptedException {
        int threadCount = 12;
        ExecutorService executor = Executors.newCachedThreadPool();
        AtomicLong errors = new AtomicLong();
        AtomicLong npeErrors = new AtomicLong();
        CyclicBarrier startBarrier = new CyclicBarrier(12);
        CountDownLatch endLatch = new CountDownLatch(12);
        try {
            for (int i = 0; i < 12; ++i) {
                executor.execute(() -> {
                    try {
                        startBarrier.await();
                        for (int j = 0; j < 10000; ++j) {
                            LockServiceFactory instance = LockServiceFactory.getInstance();
                            Thread.currentThread();
                            Thread.sleep(0L);
                            instance.resetAll();
                        }
                    }
                    catch (NullPointerException e) {
                        errors.incrementAndGet();
                        npeErrors.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        errors.incrementAndGet();
                    }
                    catch (RuntimeException | BrokenBarrierException e) {
                        errors.incrementAndGet();
                    }
                    finally {
                        endLatch.countDown();
                    }
                });
            }
            endLatch.await();
            Assert.assertEquals((String)"NPE Errors", (long)0L, (long)npeErrors.get());
            Assert.assertEquals((String)"Errors", (long)0L, (long)errors.get());
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    private MockDatabase getMockDatabase() {
        DatabaseFactory factory = DatabaseFactory.getInstance();
        for (Database db : factory.getInternalDatabases()) {
            if (!(db instanceof MockDatabase)) continue;
            return (MockDatabase)db;
        }
        return null;
    }
}

