/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lockservice;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.MockDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.StandardLockService;
import liquibase.logging.Logger;
import liquibase.logging.mdc.MdcManager;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class StandardLockServiceTest {
    public static final LocalDateTime LOCKGRANTED_DATETIME = LocalDateTime.of(2021, 6, 1, 20, 34);
    public static final Date LOCKGRANTED_DATE = Date.from(Instant.ofEpochMilli(1622580938000L));
    public static final int ID0 = 23;
    public static final int ID1 = 42;
    public static final String LOCKEDBY = "The devil";
    private StandardLockService lockService;
    private Scope mockedScope;

    @Before
    public void before() throws Exception {
        this.mockedScope = (Scope)Mockito.mock(Scope.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        MdcManager mdcManager = (MdcManager)Mockito.mock(MdcManager.class);
        Mockito.when((Object)this.mockedScope.getLog((Class)Mockito.any())).thenReturn((Object)logger);
        Mockito.when((Object)this.mockedScope.getMdcManager()).thenReturn((Object)mdcManager);
        this.lockService = new StandardLockService(){

            public boolean hasDatabaseChangeLogLockTable() throws DatabaseException {
                return true;
            }
        };
        this.lockService.setDatabase((Database)new MockDatabase());
    }

    @Test
    public void shouldAcceptLocaldatetimeInLOCKGRANTED() throws LockException {
        try (MockedStatic scope = Mockito.mockStatic(Scope.class);){
            scope.when(Scope::getCurrentScope).thenReturn((Object)this.mockedScope);
            scope.when(() -> Scope.child((Map)Mockito.anyMap(), (Scope.ScopedRunnerWithReturn)((Scope.ScopedRunnerWithReturn)Mockito.any(Scope.ScopedRunnerWithReturn.class)))).thenReturn(StandardLockServiceTest.sampleLockData());
            Object[] databaseChangeLogLocks = this.lockService.listLocks();
            Assertions.assertThat((Object[])databaseChangeLogLocks).hasSize(2);
            Assertions.assertThat((int)databaseChangeLogLocks[0].getId()).isEqualTo(23);
            Assertions.assertThat((Date)databaseChangeLogLocks[0].getLockGranted()).isEqualTo((Object)Date.from(LOCKGRANTED_DATETIME.atZone(ZoneId.systemDefault()).toInstant()));
            Assertions.assertThat((String)databaseChangeLogLocks[0].getLockedBy()).isEqualTo(LOCKEDBY);
            Assertions.assertThat((int)databaseChangeLogLocks[1].getId()).isEqualTo(42);
            Assertions.assertThat((Date)databaseChangeLogLocks[1].getLockGranted()).isEqualTo((Object)LOCKGRANTED_DATE);
            Assertions.assertThat((String)databaseChangeLogLocks[1].getLockedBy()).isEqualTo(LOCKEDBY);
        }
    }

    private static List<Map<String, ?>> sampleLockData() {
        TreeMap<String, Object> columnMapRow0 = new TreeMap<String, Object>();
        columnMapRow0.put("ID", 23);
        columnMapRow0.put("LOCKED", true);
        columnMapRow0.put("LOCKGRANTED", LOCKGRANTED_DATETIME);
        columnMapRow0.put("LOCKEDBY", LOCKEDBY);
        TreeMap<String, Object> columnMapRow1 = new TreeMap<String, Object>();
        columnMapRow1.put("ID", 42);
        columnMapRow1.put("LOCKED", 1);
        columnMapRow1.put("LOCKGRANTED", LOCKGRANTED_DATE);
        columnMapRow1.put("LOCKEDBY", LOCKEDBY);
        return Arrays.asList(columnMapRow0, columnMapRow1);
    }
}

