/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.List;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.MockChangeLogParser;
import liquibase.parser.core.sql.SqlChangeLogParser;
import liquibase.parser.core.xml.XMLChangeLogSAXParser;
import liquibase.resource.ResourceAccessor;
import liquibase.test.JUnitResourceAccessor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeLogParserFactoryTest {
    @Before
    public void setup() {
        ChangeLogParserFactory.reset();
    }

    @After
    public void after() {
        ChangeLogParserFactory.reset();
    }

    @Test
    public void getInstance() {
        Assert.assertNotNull((Object)ChangeLogParserFactory.getInstance());
        Assert.assertSame((Object)ChangeLogParserFactory.getInstance(), (Object)ChangeLogParserFactory.getInstance());
    }

    @Test
    public void register() {
        ChangeLogParserFactory.getInstance().getParsers().clear();
        Assert.assertEquals((long)5L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
        ChangeLogParserFactory.getInstance().register((ChangeLogParser)new MockChangeLogParser("mock"));
        Assert.assertEquals((long)6L, (long)ChangeLogParserFactory.getInstance().getParsers().size());
    }

    @Test
    public void unregister_instance() {
        ChangeLogParserFactory factory = ChangeLogParserFactory.getInstance();
        factory.getParsers().clear();
        Assert.assertEquals((long)5L, (long)factory.getParsers().size());
        XMLChangeLogSAXParser changeLogParser = new XMLChangeLogSAXParser();
        factory.register((ChangeLogParser)new SqlChangeLogParser());
        factory.register((ChangeLogParser)changeLogParser);
        Assert.assertEquals((long)7L, (long)factory.getParsers().size());
        factory.unregister((ChangeLogParser)changeLogParser);
        Assert.assertEquals((long)6L, (long)factory.getParsers().size());
    }

    @Test
    public void reset() {
        ChangeLogParserFactory instance1 = ChangeLogParserFactory.getInstance();
        ChangeLogParserFactory.reset();
        Assert.assertNotSame((Object)instance1, (Object)ChangeLogParserFactory.getInstance());
    }

    @Test
    public void builtInGeneratorsAreFound() {
        List generators = ChangeLogParserFactory.getInstance().getParsers();
        Assert.assertEquals((long)5L, (long)generators.size());
    }

    @Test
    public void getParsers() throws Exception {
        ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)parser);
        Assert.assertTrue((boolean)(parser instanceof XMLChangeLogSAXParser));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getExtensionParser() throws Exception {
        ChangeLogParserFactory parserFactory = ChangeLogParserFactory.getInstance();
        ChangeLogParser defaultParser = parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor());
        Assert.assertNotNull((Object)defaultParser);
        Assert.assertTrue((boolean)(defaultParser instanceof XMLChangeLogSAXParser));
        XMLChangeLogSAXParser otherXmlParser = new XMLChangeLogSAXParser(){

            public int getPriority() {
                return 100;
            }
        };
        parserFactory.register((ChangeLogParser)otherXmlParser);
        try {
            Assert.assertSame((Object)otherXmlParser, (Object)parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor()));
            Assert.assertNotSame((Object)defaultParser, (Object)parserFactory.getParser("asdf.xml", (ResourceAccessor)new JUnitResourceAccessor()));
        }
        finally {
            parserFactory.unregister((ChangeLogParser)otherXmlParser);
        }
    }
}

